/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.instant.InstantSchematicBlock;
import com.slymask3.instantblocks.network.packet.SchematicUpdatePacket;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import com.slymask3.instantblocks.util.SchematicHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class InstantBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public String createMessage = "";
    public String errorMessage = "";
    public String createVariable = "";
    public String errorVariable = "";
    boolean isDirectional = false;
    ClientHelper.Screen screen = null;

    protected InstantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setCreateMessage(String message) {
        this.setCreateMessage(message, "");
    }

    public void setCreateMessage(String message, String variable) {
        this.createMessage = message;
        this.createVariable = variable.isEmpty() ? "" : ChatFormatting.GREEN + variable;
    }

    public void setErrorMessage(String message) {
        this.setErrorMessage(message, "");
    }

    public void setErrorMessage(String message, String variable) {
        this.errorMessage = message;
        this.errorVariable = variable.isEmpty() ? "" : ChatFormatting.RED + variable;
    }

    public void setDirectional(boolean directional) {
        this.isDirectional = directional;
        if (directional) {
            this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.EAST));
        }
    }

    public void setScreen(ClientHelper.Screen screen) {
        this.screen = screen;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.isDirectional ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_()) : super.m_5573_(context);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Common.CONFIG.reload();
        return this.screen == null ? this.onActivate(world, pos, player, hand) : this.onActivateGui(world, pos, player, hand);
    }

    public boolean canActivate(Level world, BlockPos pos, Player player) {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    private boolean isDisabled(Player player) {
        if (!this.isEnabled()) {
            Helper.sendMessage(player, "ib.message.error.disabled");
            return true;
        }
        return false;
    }

    private InteractionResult onActivate(Level world, BlockPos pos, Player player, InteractionHand hand) {
        if (Helper.isServer(world)) {
            if (hand == InteractionHand.OFF_HAND) {
                return InteractionResult.FAIL;
            }
            if (this.isDisabled(player)) {
                return InteractionResult.FAIL;
            }
            ItemStack is = player.m_21120_(hand);
            if (Common.CONFIG.USE_WANDS()) {
                if (!Helper.isWand(is)) {
                    Helper.sendMessage(player, "ib.message.error.wand");
                    return InteractionResult.FAIL;
                }
                if (Helper.wandDamage(Helper.getBlock(world, pos)) > is.m_41776_() - is.m_41773_() && !player.m_7500_()) {
                    Helper.sendMessage(player, "ib.message.error.wand_durability");
                    return InteractionResult.FAIL;
                }
            }
            if (!this.canActivate(world, pos, player)) {
                return InteractionResult.FAIL;
            }
            return this.activate(world, pos, player);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult onActivateGui(Level world, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        if (this.isDisabled(player)) {
            return InteractionResult.FAIL;
        }
        if (!this.canActivate(world, pos, player)) {
            return InteractionResult.FAIL;
        }
        ItemStack is = player.m_21120_(hand);
        if (Common.CONFIG.USE_WANDS()) {
            if (!Helper.isWand(is)) {
                Helper.sendMessage(player, "ib.message.error.wand");
                return InteractionResult.FAIL;
            }
            if (Helper.wandDamage(Helper.getBlock(world, pos)) > is.m_41776_() - is.m_41773_() && !player.m_7500_()) {
                Helper.sendMessage(player, "ib.message.error.wand_durability");
                return InteractionResult.FAIL;
            }
        }
        if (Helper.isServer(world) && this instanceof InstantSchematicBlock) {
            Common.NETWORK.sendToClient((ServerPlayer)player, new SchematicUpdatePacket(SchematicHelper.getSchematics(), pos));
        } else if (Helper.isClient(world)) {
            ClientHelper.showScreen(this.screen, player, world, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult activate(Level world, BlockPos pos, Player player) {
        if (this.build(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player)) {
            this.afterBuild(world, pos, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean build(Level world, int x, int y, int z, Player player) {
        return true;
    }

    private void afterBuild(Level world, BlockPos pos, Player player) {
        ItemStack is;
        Helper.sendMessage(player, this.createMessage, this.createVariable, pos);
        Helper.giveExp(world, player, Common.CONFIG.XP_AMOUNT());
        if (Common.CONFIG.USE_WANDS() && Helper.isWand(is = player.m_21120_(InteractionHand.MAIN_HAND))) {
            is.m_41622_(Helper.wandDamage(this), (LivingEntity)player, entity -> entity.m_21190_(InteractionHand.MAIN_HAND));
        }
    }
}

