/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block;

import com.mojang.math.Vector3f;
import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.core.ModBlocks;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class InstantLiquidBlock
extends InstantBlock {
    public ArrayList<BlockPos> posList = new ArrayList();
    public Block blockCheck;
    public final Block blockReplace;
    public String create;
    public String create1;
    public boolean isSuction = false;
    public ParticleOptions particle = null;
    public static final DustParticleOptions WHITE_DUST = new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)0xFFFFFF)), 1.0f);

    public InstantLiquidBlock(BlockBehaviour.Properties properties, Block blockCheck, Block blockReplace) {
        super(properties);
        this.blockCheck = blockCheck;
        this.blockReplace = blockReplace;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        if (this.particle != null) {
            for (int i = 0; i < 8; ++i) {
                world.m_7106_(this.particle, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    }

    public boolean m_6104_(@Nonnull BlockState state, BlockState adjacentBlockState, @Nonnull Direction side) {
        return adjacentBlockState.m_60713_((Block)this) || super.m_6104_(state, adjacentBlockState, side);
    }

    @Nonnull
    public VoxelShape m_5909_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return !this.isSuction;
    }

    private int getMax() {
        return this.isSuction ? Common.CONFIG.MAX_FILL() : Common.CONFIG.MAX_LIQUID();
    }

    private Block getMainReplaceBlock() {
        if (this.isSuction) {
            return this.blockCheck == Blocks.f_49990_ ? ModBlocks.INSTANT_WATER : ModBlocks.INSTANT_LAVA;
        }
        return this.blockReplace;
    }

    @Override
    public boolean canActivate(Level world, BlockPos pos, Player player) {
        if (this.isSuction) {
            Helper.sendMessage(player, "", "", pos, ClientHelper.Particles.NO_LIQUID);
        }
        if (world.m_46472_().equals((Object)Level.f_46429_) && this.blockReplace.equals(Blocks.f_49990_) && !Common.CONFIG.ALLOW_WATER_IN_NETHER()) {
            Helper.sendMessage(player, "ib.message.error.water_disabled");
            return false;
        }
        this.checkForBlock(world, pos);
        if (this.isSuction && this.posList.isEmpty()) {
            Helper.sendMessage(player, "ib.message.error.no_liquid");
            return false;
        }
        if (this.posList.size() >= this.getMax()) {
            Helper.sendMessage(player, this.errorMessage, ChatFormatting.RED + String.valueOf(this.isSuction ? Common.CONFIG.MAX_FILL() : Common.CONFIG.MAX_LIQUID()));
            this.posList = new ArrayList();
            return false;
        }
        return true;
    }

    @Override
    public boolean build(Level world, int x, int y, int z, Player player) {
        for (BlockPos pos : this.posList) {
            ((Builder.Single)Builder.Single.setup(world, pos).setBlock(this.blockReplace)).build();
        }
        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(this.getMainReplaceBlock())).build();
        if (this.posList.size() > 0) {
            this.setCreateMessage(this.create, String.valueOf(this.isSuction ? this.posList.size() : this.posList.size() + 1));
        } else {
            this.setCreateMessage(this.create1);
        }
        this.posList = new ArrayList();
        if (this.isSuction) {
            this.blockCheck = null;
        }
        return true;
    }

    private void checkForBlock(Level world, BlockPos pos) {
        this.check(world, pos.m_142390_(1));
        this.check(world, pos.m_142385_(1));
        this.check(world, pos.m_142383_(1));
        this.check(world, pos.m_142386_(1));
        if (!Common.CONFIG.SIMPLE_LIQUID() || this.isSuction) {
            this.check(world, pos.m_6625_(1));
        }
        if (this.isSuction) {
            this.check(world, pos.m_6630_(1));
        }
    }

    private void check(Level world, BlockPos pos) {
        Block blockCurrent = Helper.getBlock(world, pos);
        if (this.isCorrectBlock(blockCurrent) && this.posList.size() < this.getMax() && this.addPos(pos)) {
            if (this.blockCheck == null) {
                this.blockCheck = blockCurrent;
            }
            this.checkForBlock(world, pos);
        }
    }

    private boolean isCorrectBlock(Block block) {
        if (this.blockCheck == null) {
            return block == Blocks.f_49990_ || block == Blocks.f_49991_;
        }
        if (this.blockCheck == Blocks.f_50016_) {
            return block == this.blockCheck || block instanceof BushBlock;
        }
        return block == this.blockCheck;
    }

    private boolean addPos(BlockPos pos) {
        if (!this.posList.contains(pos)) {
            this.posList.add(pos);
            return true;
        }
        return false;
    }

    public static class LiquidSoundType
    extends SoundType {
        public LiquidSoundType(SoundEvent breakSound, SoundEvent placeSound) {
            super(1.0f, 1.0f, breakSound, placeSound, placeSound, placeSound, placeSound);
        }
    }
}

