/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.entity;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.entity.InstantBlockEntity;
import com.slymask3.instantblocks.core.ModTiles;
import com.slymask3.instantblocks.util.ColorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public class SkydiveBlockEntity
extends InstantBlockEntity {
    public String[] color = new String[11];
    public int[] colorCode = new int[11];
    public boolean teleport;
    public int radius;

    public SkydiveBlockEntity(BlockPos pos, BlockState state) {
        super(ModTiles.SKYDIVE, pos, state);
        for (int i = 0; i < this.color.length; ++i) {
            String color;
            this.color[i] = color = ColorHelper.indexRainbowToString(i);
            this.colorCode[i] = ColorHelper.textToColor(color).getRGB();
        }
        this.teleport = true;
        this.radius = Common.CONFIG.SKYDIVE_RADIUS();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        for (int i = 0; i < this.color.length; ++i) {
            this.color[i] = nbt.m_128461_("Color" + i);
            this.colorCode[i] = nbt.m_128451_("ColorCode" + i);
        }
        this.teleport = nbt.m_128471_("Teleport");
        this.radius = nbt.m_128451_("Radius");
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        for (int i = 0; i < this.color.length; ++i) {
            nbt.m_128359_("Color" + i, this.color[i]);
            nbt.m_128405_("ColorCode" + i, this.colorCode[i]);
        }
        nbt.m_128379_("Teleport", this.teleport);
        nbt.m_128405_("Radius", this.radius);
    }

    public void update(String[] color, int radius, boolean teleport) {
        this.color = color;
        this.colorCode = new int[color.length];
        for (int i = 0; i < color.length; ++i) {
            this.colorCode[i] = ColorHelper.textToColor(color[i]).getRGB();
        }
        this.teleport = teleport;
        this.radius = radius;
        this.markUpdated();
    }
}

