/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InstantEscapeLadderBlock
extends InstantBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public InstantEscapeLadderBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.4f).m_60918_(SoundType.f_56748_).m_60955_().m_60960_((state, world, pos) -> false).m_60922_((state, world, pos, entityType) -> false).m_60924_((state, world, pos) -> false).m_60971_((state, world, pos) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_ESCAPE_LADDER();
    }

    @Override
    public boolean canActivate(Level world, BlockPos pos, Player player) {
        if (world.m_45527_(pos.m_6630_(1))) {
            Helper.sendMessage(player, "ib.message.error.escape_ladder");
            return false;
        }
        return true;
    }

    @Override
    public boolean build(Level world, int x, int y, int z, Player player) {
        int i;
        int y_top;
        Block ladder = Blocks.f_50155_;
        Block torch = Blocks.f_50081_;
        Block air = Blocks.f_50016_;
        Direction direction = (Direction)world.m_8055_(new BlockPos(x, y, z)).m_61143_((Property)FACING);
        if (world.m_46472_().equals((Object)Level.f_46429_)) {
            y_top = world.m_151558_();
            for (i = y + 3; i < world.m_151558_(); ++i) {
                if (!Helper.getBlock(world, x, i, z).equals(Blocks.f_50016_) || !Helper.getBlock(world, x, i + 1, z).equals(Blocks.f_50016_) || !Helper.getBlock(world, x, i + 2, z).equals(Blocks.f_50016_) || !Helper.getBlock(world, x, i + 3, z).equals(Blocks.f_50016_)) continue;
                y_top = i;
                break;
            }
        } else {
            y_top = y - 1;
            while (!world.m_45527_(new BlockPos(x, y_top, z))) {
                ++y_top;
            }
        }
        for (i = y - 1; i < y_top; ++i) {
            ((Builder.Multiple)Builder.Multiple.setup(world, x - 1, y - 1, z - 1, 3, 1, 3).setStone()).build();
            ((Builder.Multiple)Builder.Multiple.setup(world, x - 1, i, z - 1, 3, 1, 3).setStone()).build();
            ((Builder.Single)Builder.Single.setup(world, x, i, z).setBlock(air)).build();
            ((Builder.Single)((Builder.Single)Builder.Single.setup(world, x, i, z).setBlock(ladder)).setDirection(direction)).build();
            ((Builder.Single)Builder.Single.setup(world, x, y, z).offset(direction, 0, 1, 0, 0).setBlock(air)).build();
            ((Builder.Single)Builder.Single.setup(world, x, y + 1, z).offset(direction, 0, 1, 0, 0).setBlock(air)).build();
            for (int m = y + 6; m < i; m += 6) {
                ((Builder.Single)Builder.Single.setup(world, x, m, z).offset(direction, 0, 1, 0, 0).setBlock(torch)).build();
            }
        }
        this.setCreateMessage("ib.message.create.escape_ladder", String.valueOf(y_top - y));
        return true;
    }

    public VoxelShape m_5940_(BlockState p_54372_, BlockGetter p_54373_, BlockPos p_54374_, CollisionContext p_54375_) {
        switch ((Direction)p_54372_.m_61143_((Property)FACING)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return EAST_AABB;
    }

    private boolean canAttachTo(BlockGetter p_54349_, BlockPos p_54350_, Direction p_54351_) {
        BlockState blockstate = p_54349_.m_8055_(p_54350_);
        return blockstate.m_60783_(p_54349_, p_54350_, p_54351_);
    }

    public boolean m_7898_(BlockState p_54353_, LevelReader p_54354_, BlockPos p_54355_) {
        Direction direction = (Direction)p_54353_.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)p_54354_, p_54355_.m_142300_(direction.m_122424_()), direction);
    }

    public BlockState m_7417_(BlockState p_54363_, Direction p_54364_, BlockState p_54365_, LevelAccessor p_54366_, BlockPos p_54367_, BlockPos p_54368_) {
        if (p_54364_.m_122424_() == p_54363_.m_61143_((Property)FACING) && !p_54363_.m_60710_((LevelReader)p_54366_, p_54367_)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)p_54363_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_54366_.m_186469_(p_54367_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_54366_));
        }
        return super.m_7417_(p_54363_, p_54364_, p_54365_, p_54366_, p_54367_, p_54368_);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext p_54347_) {
        BlockState blockstate;
        if (!p_54347_.m_7058_() && (blockstate = p_54347_.m_43725_().m_8055_(p_54347_.m_8083_().m_142300_(p_54347_.m_43719_().m_122424_()))).m_60713_((Block)this) && blockstate.m_61143_((Property)FACING) == p_54347_.m_43719_()) {
            return null;
        }
        BlockState blockstate1 = this.m_49966_();
        Level levelreader = p_54347_.m_43725_();
        BlockPos blockpos = p_54347_.m_8083_();
        FluidState fluidstate = p_54347_.m_43725_().m_6425_(p_54347_.m_8083_());
        for (Direction direction : p_54347_.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockstate1 = (BlockState)blockstate1.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate1.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_6843_(BlockState p_54360_, Rotation p_54361_) {
        return (BlockState)p_54360_.m_61124_((Property)FACING, (Comparable)p_54361_.m_55954_((Direction)p_54360_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_54357_, Mirror p_54358_) {
        return p_54357_.m_60717_(p_54358_.m_54846_((Direction)p_54357_.m_61143_((Property)FACING)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_54370_) {
        p_54370_.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState p_54377_) {
        return (Boolean)p_54377_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_54377_);
    }
}

