/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.HarvestBlockEntity;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class InstantHarvestBlock
extends InstantBlock
implements EntityBlock {
    public InstantHarvestBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(1.5f).m_60918_(SoundType.f_56736_));
        this.setScreen(ClientHelper.Screen.HARVEST);
        this.setCreateMessage("ib.message.create.harvest");
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_HARVEST();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HarvestBlockEntity(pos, state);
    }

    @Override
    public boolean build(Level world, int X, int Y, int Z, Player player) {
        HarvestBlockEntity blockEntity = (HarvestBlockEntity)world.m_7702_(new BlockPos(X, Y, Z));
        int radius = Common.CONFIG.RADIUS_HARVEST();
        ((Builder.Single)Builder.Single.setup(world, X, Y, Z).setBlock(Blocks.f_50087_)).build();
        ChestBlockEntity chest = (ChestBlockEntity)world.m_7702_(new BlockPos(X, Y, Z));
        Random rand = new Random();
        int x = X - radius;
        int y = Y + radius;
        int z = Z - radius;
        int x_base = x;
        int z_base = z;
        for (int i = 0; i < radius * 2 + 1; ++i) {
            for (int j = 0; j < radius * 2 + 1; ++j) {
                for (int k = 0; k < radius * 2 + 1; ++k) {
                    Block block = Helper.getBlock(world, x, y, z);
                    BlockState state = world.m_8055_(new BlockPos(x, y, z));
                    if (chest.m_8020_(chest.m_6643_() - 1) != ItemStack.f_41583_) {
                        if (Helper.isDoubleChest(chest)) {
                            ++Y;
                            --X;
                        } else {
                            ++X;
                        }
                        ((Builder.Single)Builder.Single.setup(world, X, Y, Z).setBlock(Blocks.f_50087_)).build();
                        chest = (ChestBlockEntity)world.m_7702_(new BlockPos(X, Y, Z));
                    }
                    if (block == Blocks.f_49999_ && blockEntity.logOak) {
                        this.addLog(chest, x, y, z, block, Blocks.f_50746_, blockEntity.replant);
                    } else if (block == Blocks.f_50000_ && blockEntity.logSpruce) {
                        this.addLog(chest, x, y, z, block, Blocks.f_50747_, blockEntity.replant);
                    } else if (block == Blocks.f_50001_ && blockEntity.logBirch) {
                        this.addLog(chest, x, y, z, block, Blocks.f_50748_, blockEntity.replant);
                    } else if (block == Blocks.f_50002_ && blockEntity.logJungle) {
                        this.addLog(chest, x, y, z, block, Blocks.f_50749_, blockEntity.replant);
                    } else if (block == Blocks.f_50003_ && blockEntity.logAcacia) {
                        this.addLog(chest, x, y, z, block, Blocks.f_50750_, blockEntity.replant);
                    } else if (block == Blocks.f_50004_ && blockEntity.logDark) {
                        this.addLog(chest, x, y, z, block, Blocks.f_50751_, blockEntity.replant);
                    } else if (block == Blocks.f_50092_ && (Integer)state.m_61143_((Property)CropBlock.f_52244_) == 7 && blockEntity.wheat) {
                        Helper.addToChest(chest, Items.f_42405_, 1);
                        this.replantBlock(world, x, y, z, Blocks.f_50092_, blockEntity.replant);
                    } else if (block == Blocks.f_50249_ && (Integer)state.m_61143_((Property)CarrotBlock.f_52244_) == 7 && blockEntity.carrot) {
                        Helper.addToChest(chest, Items.f_42619_, rand.nextInt(4) + 1);
                        this.replantBlock(world, x, y, z, Blocks.f_50249_, blockEntity.replant);
                    } else if (block == Blocks.f_50250_ && (Integer)state.m_61143_((Property)PotatoBlock.f_52244_) == 7 && blockEntity.potato) {
                        Helper.addToChest(chest, Items.f_42620_, rand.nextInt(4) + 1);
                        this.replantBlock(world, x, y, z, Blocks.f_50250_, blockEntity.replant);
                    } else if (block == Blocks.f_50128_ && blockEntity.cactus) {
                        Block blockBelow = Helper.getBlock(world, x, y - 1, z);
                        if ((blockBelow == Blocks.f_49992_ || blockBelow == Blocks.f_49993_) && blockEntity.replant) {
                            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50128_)).build();
                        } else {
                            Helper.addToChest(chest, block, 1);
                            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
                        }
                    } else if (block == Blocks.f_50133_ && blockEntity.pumpkin) {
                        Helper.addToChest(chest, block, 1);
                        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
                    } else if (block == Blocks.f_50186_ && blockEntity.melon) {
                        Helper.addToChest(chest, Items.f_42575_, rand.nextInt(5) + 3);
                        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
                    } else if (block == Blocks.f_50130_ && blockEntity.sugarcane) {
                        if (this.canPlaceSugarCane(Helper.getBlock(world, x, y - 1, z)) && blockEntity.replant) {
                            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(block)).build();
                        } else {
                            Helper.addToChest(chest, Items.f_41909_, 1);
                            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
                        }
                    } else if (block == Blocks.f_50262_ && (Integer)state.m_61143_((Property)CocoaBlock.f_51736_) == 2 && blockEntity.cocoa) {
                        Helper.addToChest(chest, Items.f_42533_, 3);
                        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
                    } else if ((block == Blocks.f_50181_ || block == Blocks.f_50073_) && blockEntity.mushroom) {
                        Helper.addToChest(chest, Blocks.f_50073_, 1);
                        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
                    } else if ((block == Blocks.f_50180_ || block == Blocks.f_50072_) && blockEntity.mushroom) {
                        Helper.addToChest(chest, Blocks.f_50072_, 1);
                        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
                    } else if (block == Blocks.f_50200_ && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) == 3 && blockEntity.netherwart) {
                        Helper.addToChest(chest, Items.f_42588_, rand.nextInt(3) + 2);
                        this.replantBlock(world, x, y, z, Blocks.f_50200_, blockEntity.replant);
                    } else if (block instanceof LeavesBlock) {
                        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
                    }
                    ++x;
                }
                ++z;
                x = x_base;
            }
            z = z_base;
            --y;
        }
        return true;
    }

    private void addLog(ChestBlockEntity chest, int x, int y, int z, Block block, Block sapling, boolean replant) {
        Level world = chest.m_58904_();
        Helper.addToChest(chest, block, 1);
        this.replantBlock(world, x, y, z, sapling, (Helper.getBlock(world, x, y - 1, z) == Blocks.f_50493_ || Helper.getBlock(world, x, y - 1, z) == Blocks.f_50440_) && replant);
    }

    private void replantBlock(Level world, int x, int y, int z, Block block, boolean replant) {
        if (replant) {
            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(block)).build();
        } else {
            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
        }
    }

    private boolean canPlaceSugarCane(Block block) {
        return block == Blocks.f_50493_ || block == Blocks.f_50440_ || block == Blocks.f_49992_ || block == Blocks.f_49993_;
    }
}

