/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.Helper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InstantLightBlock
extends InstantBlock {
    public final ArrayList<BlockPos> posList = new ArrayList();

    public InstantLightBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundType.f_56736_).m_60910_().m_60966_().m_60953_(par1 -> 14));
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_LIGHT();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0);
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + 1.0;
        double d2 = (double)pos.m_123343_() + 0.5;
        world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
        world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public boolean build(Level world, int x, int y, int z, Player player) {
        this.checkForDarkness(world, x, y, z);
        if (this.posList.isEmpty()) {
            Helper.sendMessage(player, "ib.message.error.light", ChatFormatting.RED + String.valueOf(Common.CONFIG.RADIUS_LIGHT()));
            return false;
        }
        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50081_)).build();
        this.setCreateMessage("ib.message.create.light", String.valueOf(this.posList.size()));
        this.posList.clear();
        return true;
    }

    private void checkForDarkness(Level world, int x_center, int y_center, int z_center) {
        int radius = Common.CONFIG.RADIUS_LIGHT();
        Random random = new Random();
        for (int y = y_center + radius; y > y_center - radius * 2; y -= random.nextInt(3) + 2) {
            for (int x = x_center - radius; x < x_center + radius * 2; x += random.nextInt(3) + 2) {
                for (int z = z_center - radius; z < z_center + radius * 2; z += random.nextInt(3) + 2) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (world.m_8055_(pos).m_60734_() != Blocks.f_50016_ || world.m_45524_(pos, 0) >= 8 || !this.canPlaceTorch(world, pos)) continue;
                    this.addPos(pos);
                    this.placeTorch(world, pos);
                }
            }
        }
    }

    private boolean canPlaceTorch(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos, Direction.UP) || world.m_8055_(pos.m_142127_()).m_60783_((BlockGetter)world, pos, Direction.SOUTH) || world.m_8055_(pos.m_142126_()).m_60783_((BlockGetter)world, pos, Direction.WEST) || world.m_8055_(pos.m_142128_()).m_60783_((BlockGetter)world, pos, Direction.NORTH) || world.m_8055_(pos.m_142125_()).m_60783_((BlockGetter)world, pos, Direction.EAST);
    }

    private void placeTorch(Level world, BlockPos pos) {
        if (world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos, Direction.UP)) {
            ((Builder.Single)((Builder.Single)Builder.Single.setup(world, pos).setBlock(Blocks.f_50081_)).setDirection(Direction.UP)).build();
        } else if (world.m_8055_(pos.m_142127_()).m_60783_((BlockGetter)world, pos, Direction.SOUTH)) {
            ((Builder.Single)((Builder.Single)Builder.Single.setup(world, pos).setBlock(Blocks.f_50082_)).setDirection(Direction.SOUTH)).build();
        } else if (world.m_8055_(pos.m_142126_()).m_60783_((BlockGetter)world, pos, Direction.WEST)) {
            ((Builder.Single)((Builder.Single)Builder.Single.setup(world, pos).setBlock(Blocks.f_50082_)).setDirection(Direction.WEST)).build();
        } else if (world.m_8055_(pos.m_142128_()).m_60783_((BlockGetter)world, pos, Direction.NORTH)) {
            ((Builder.Single)((Builder.Single)Builder.Single.setup(world, pos).setBlock(Blocks.f_50082_)).setDirection(Direction.NORTH)).build();
        } else if (world.m_8055_(pos.m_142125_()).m_60783_((BlockGetter)world, pos, Direction.EAST)) {
            ((Builder.Single)((Builder.Single)Builder.Single.setup(world, pos).setBlock(Blocks.f_50082_)).setDirection(Direction.EAST)).build();
        }
    }

    private boolean addPos(BlockPos pos) {
        if (!this.posList.contains(pos)) {
            this.posList.add(pos);
            return true;
        }
        return false;
    }
}

