/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.SchematicBlockEntity;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import com.slymask3.instantblocks.util.SchematicHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class InstantSchematicBlock
extends InstantBlock
implements EntityBlock {
    public InstantSchematicBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(1.5f).m_60918_(SoundType.f_56736_));
        this.setScreen(ClientHelper.Screen.SCHEMATIC);
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_SCHEMATIC();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SchematicBlockEntity(pos, state);
    }

    @Override
    public boolean build(Level world, int x, int y, int z, Player player) {
        SchematicBlockEntity blockEntity = (SchematicBlockEntity)world.m_7702_(new BlockPos(x, y, z));
        SchematicHelper.Schematic schematic = SchematicHelper.readSchematic(blockEntity.schematic);
        if (schematic != null) {
            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
            InstantSchematicBlock.buildSchematic(world, x, y, z, schematic, blockEntity.center, blockEntity.ignoreAir);
            this.setCreateMessage("ib.message.create.schematic", blockEntity.schematic);
            return true;
        }
        Helper.sendMessage(player, "ib.message.error.schematic", ChatFormatting.RED + blockEntity.schematic);
        return false;
    }

    public static void buildSchematic(Level world, int X, int Y, int Z, SchematicHelper.Schematic schematic, boolean center, boolean ignoreAir) {
        int width = schematic.width;
        int height = schematic.height;
        int length = schematic.length;
        int x_offset = 0;
        int z_offset = 0;
        if (center) {
            x_offset = width / 2;
            z_offset = length / 2;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = y * width * length + z * width + x;
                    BlockState state = schematic.getBlockState(index);
                    BlockPos pos = new BlockPos(x + X - x_offset, y + Y, z + Z - z_offset);
                    if (ignoreAir && state.m_60734_() == Blocks.f_50016_) continue;
                    ((Builder.Single)Builder.Single.setup(world, pos).setBlock(state)).build();
                    CompoundTag tag = schematic.getBlockEntityTag(x, y, z);
                    BlockEntity entity = world.m_7702_(pos);
                    if (tag == null || entity == null) continue;
                    entity.m_142466_(tag);
                }
            }
        }
        for (CompoundTag entityTag : schematic.getEntityTags()) {
            Optional optional = EntityType.m_20642_((CompoundTag)entityTag, (Level)world);
            if (!optional.isPresent()) continue;
            Entity entity = (Entity)optional.get();
            world.m_7967_(entity);
        }
    }
}

