/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.SkydiveBlockEntity;
import com.slymask3.instantblocks.core.ModBlocks;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.ColorHelper;
import com.slymask3.instantblocks.util.Helper;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class InstantSkydiveBlock
extends InstantBlock
implements EntityBlock {
    public InstantSkydiveBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60978_(0.8f).m_60918_(SoundType.f_56745_));
        this.setScreen(ClientHelper.Screen.SKYDIVE);
        this.setCreateMessage("ib.message.create.skydive");
        this.setDirectional(true);
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_SKYDIVE();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SkydiveBlockEntity(pos, state);
    }

    @Override
    public boolean build(Level world, int x, int y, int z, Player player) {
        int i;
        SkydiveBlockEntity blockEntity = (SkydiveBlockEntity)world.m_7702_(new BlockPos(x, y, z));
        int[] selectedColors = blockEntity.colorCode;
        int radius = blockEntity.radius;
        if (selectedColors.length == 0) {
            Helper.sendMessage(player, "ib.message.error.no_colors");
            return false;
        }
        Direction direction = (Direction)world.m_8055_(new BlockPos(x, y, z)).m_61143_((Property)FACING);
        ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
        int index = 0;
        Color[] colors = new Color[selectedColors.length * 10];
        for (i = 0; i < selectedColors.length; ++i) {
            Color base;
            Color after = i + 1 < selectedColors.length ? new Color(selectedColors[i + 1]) : new Color(selectedColors[0]);
            colors[index] = base = new Color(selectedColors[i]);
            colors[++index] = ColorHelper.getColorBetween(base, after, 90, 10);
            colors[++index] = ColorHelper.getColorBetween(base, after, 80, 20);
            colors[++index] = ColorHelper.getColorBetween(base, after, 70, 30);
            colors[++index] = ColorHelper.getColorBetween(base, after, 60, 40);
            colors[++index] = ColorHelper.getColorBetween(base, after, 50, 50);
            colors[++index] = ColorHelper.getColorBetween(base, after, 40, 60);
            colors[++index] = ColorHelper.getColorBetween(base, after, 30, 70);
            colors[++index] = ColorHelper.getColorBetween(base, after, 20, 80);
            colors[++index] = ColorHelper.getColorBetween(base, after, 10, 90);
            ++index;
        }
        i = 0;
        int min = Helper.getMinSkydive(world);
        int max = Helper.getMaxSkydive(world);
        int water = Common.CONFIG.SKYDIVE_WATER();
        for (int c = max; c >= min; --c) {
            if (i >= colors.length) {
                i = 0;
            }
            int color = colors[i].getRGB();
            if (c == min) {
                Builder.Circle.setup(world, x, c, z, radius).setBlock(Builder.BlockType.color(color)).build();
            } else if (c < min + water + 1) {
                Builder.Circle.setup(world, x, c, z, radius).setInner(Builder.BlockType.block(Blocks.f_49990_)).setOuter(Builder.BlockType.color(color)).build();
            } else {
                Builder.Circle.setup(world, x, c, z, radius).setInner(Builder.BlockType.block(Blocks.f_50016_)).setOuter(Builder.BlockType.color(color)).build();
            }
            if (c == min + water + 1) {
                ((Builder.Single)Builder.Single.setup(world, x + radius, c, z).setBlock(Builder.BlockType.color(color, ModBlocks.SKYDIVE_TP))).build();
                ((Builder.Single)Builder.Single.setup(world, x - radius, c, z).setBlock(Builder.BlockType.color(color, ModBlocks.SKYDIVE_TP))).build();
                ((Builder.Single)Builder.Single.setup(world, x, c, z + radius).setBlock(Builder.BlockType.color(color, ModBlocks.SKYDIVE_TP))).build();
                ((Builder.Single)Builder.Single.setup(world, x, c, z - radius).setBlock(Builder.BlockType.color(color, ModBlocks.SKYDIVE_TP))).build();
            }
            ++i;
        }
        if (blockEntity.teleport) {
            if (direction == Direction.SOUTH) {
                Helper.teleport(world, player, x, max + 1, z + radius);
            } else if (direction == Direction.WEST) {
                Helper.teleport(world, player, x - radius, max + 1, z);
            } else if (direction == Direction.NORTH) {
                Helper.teleport(world, player, x, max + 1, z - radius);
            } else if (direction == Direction.EAST) {
                Helper.teleport(world, player, x + radius, max + 1, z);
            }
        }
        return true;
    }
}

