/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.StatueBlockEntity;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class InstantStatueBlock
extends InstantBlock
implements EntityBlock {
    public InstantStatueBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(1.5f).m_60918_(SoundType.f_56736_));
        this.setScreen(ClientHelper.Screen.STATUE);
        this.setDirectional(true);
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_STATUE();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StatueBlockEntity(pos, state);
    }

    public Skin getSkin(String username) {
        if (!username.equalsIgnoreCase("")) {
            try {
                JsonObject metadata;
                GsonBuilder builder = new GsonBuilder();
                builder.setPrettyPrinting();
                Gson gson = builder.create();
                String user_api_contents = InstantStatueBlock.get_contents("https://api.mojang.com/users/profiles/minecraft/" + username);
                JsonObject user_json = (JsonObject)gson.fromJson(user_api_contents, JsonObject.class);
                String uuid = user_json.get("id").getAsString();
                String uuid_api_contents = InstantStatueBlock.get_contents("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
                JsonObject uuid_json = (JsonObject)gson.fromJson(uuid_api_contents, JsonObject.class);
                String base64 = uuid_json.get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
                String base64_decoded = new String(Base64.getDecoder().decode(base64));
                JsonObject image_json = (JsonObject)gson.fromJson(base64_decoded, JsonObject.class);
                JsonObject skin_json = image_json.get("textures").getAsJsonObject().get("SKIN").getAsJsonObject();
                String image_url = skin_json.get("url").getAsString();
                Skin skin = new Skin(ImageIO.read(new URL(image_url)));
                if (skin_json.has("metadata") && (metadata = skin_json.get("metadata").getAsJsonObject()).has("model") && metadata.get("model").getAsString().equalsIgnoreCase("slim")) {
                    skin.setSlim(true);
                }
                return skin;
            }
            catch (Exception e) {
                Common.LOG.error(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public boolean build(Level world, int x, int y, int z, Player player) {
        StatueBlockEntity blockEntity = (StatueBlockEntity)world.m_7702_(new BlockPos(x, y, z));
        Direction direction = (Direction)world.m_8055_(new BlockPos(x, y, z)).m_61143_((Property)FACING);
        Skin skin = this.getSkin(blockEntity.username);
        if (skin != null) {
            BufferedImage img = skin.getImage();
            ((Builder.Single)Builder.Single.setup(world, x, y, z).setBlock(Blocks.f_50016_)).build();
            InstantStatueBlock.buildHead(world, x, y, z, img, direction, blockEntity.head, blockEntity.rgb);
            InstantStatueBlock.buildBody(world, x, y, z, img, direction, blockEntity.body, blockEntity.rgb);
            InstantStatueBlock.buildLegs(world, x, y, z, img, direction, blockEntity.legLeft, blockEntity.legRight, blockEntity.rgb);
            if (skin.isSlim()) {
                InstantStatueBlock.buildArmsSlim(world, x, y, z, img, direction, blockEntity.armLeft, blockEntity.armRight, blockEntity.rgb);
            } else {
                InstantStatueBlock.buildArms(world, x, y, z, img, direction, blockEntity.armLeft, blockEntity.armRight, blockEntity.rgb);
            }
            this.setCreateMessage("ib.message.create.statue", blockEntity.username);
            return true;
        }
        Helper.sendMessage(player, "ib.message.error.statue", ChatFormatting.RED + blockEntity.username);
        return false;
    }

    private static String get_contents(String url_string) {
        StringBuilder content = new StringBuilder();
        try {
            String line;
            URL url = new URL(url_string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line).append("\n");
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    private static void buildHead(Level world, int x, int y, int z, BufferedImage img, Direction direction, boolean build, boolean rgb) {
        if (build) {
            int ytimes;
            int xtimes;
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31, z).offset(direction, -5 + ytimes, -4 + xtimes).setImageColor(img, 8 + xtimes, ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 24, z).offset(direction, -5 + ytimes, -4 + xtimes).setImageColor(img, 16 + xtimes, ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31 - ytimes, z).offset(direction, -5 + xtimes, -4).setImageColor(img, xtimes, 8 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31 - ytimes, z).offset(direction, 2 - xtimes, 3).setImageColor(img, 16 + xtimes, 8 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31 - ytimes, z).offset(direction, 2, -4 + xtimes).setImageColor(img, 8 + xtimes, 8 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 8; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 31 - ytimes, z).offset(direction, -5, 3 - xtimes).setImageColor(img, 24 + xtimes, 8 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static void buildBody(Level world, int x, int y, int z, BufferedImage img, Direction direction, boolean build, boolean rgb) {
        if (build) {
            int ytimes;
            int xtimes;
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, -4 + xtimes).setImageColor(img, 20 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -ytimes, -4 + xtimes).setImageColor(img, 28 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, -4).setImageColor(img, 16 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, 3).setImageColor(img, 28 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, -4 + xtimes).setImageColor(img, 20 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 8; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, 3 - xtimes).setImageColor(img, 32 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static void buildArms(Level world, int x, int y, int z, BufferedImage img, Direction direction, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, 4).setImageColor(img, 48 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, 7).setImageColor(img, 40 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, 4 + xtimes).setImageColor(img, 44 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -3 + ytimes, 4 + xtimes).setImageColor(img, 48 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, 7 - xtimes).setImageColor(img, 44 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, 4 + xtimes).setImageColor(img, 52 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, -5).setImageColor(img, 48 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, -8).setImageColor(img, 40 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, -5 - xtimes).setImageColor(img, 44 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -3 + ytimes, -5 - xtimes).setImageColor(img, 48 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, -8 + xtimes).setImageColor(img, 44 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, -5 - xtimes).setImageColor(img, 52 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static void buildArmsSlim(Level world, int x, int y, int z, BufferedImage img, Direction direction, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, 4).setImageColor(img, 47 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, 6).setImageColor(img, 40 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, 4 + xtimes).setImageColor(img, 44 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -3 + ytimes, 4 + xtimes).setImageColor(img, 47 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, 6 - xtimes).setImageColor(img, 44 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, 4 + xtimes).setImageColor(img, 51 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -xtimes, -5).setImageColor(img, 48 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3 + xtimes, -7).setImageColor(img, 40 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23, z).offset(direction, -3 + ytimes, -5 - xtimes).setImageColor(img, 44 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 12, z).offset(direction, -3 + ytimes, -5 - xtimes).setImageColor(img, 47 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, 0, -7 + xtimes).setImageColor(img, 44 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 3; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 23 - ytimes, z).offset(direction, -3, -5 - xtimes).setImageColor(img, 51 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static void buildLegs(Level world, int x, int y, int z, BufferedImage img, Direction direction, boolean buildLeft, boolean buildRight, boolean rgb) {
        int ytimes;
        int xtimes;
        if (buildLeft) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11, z).offset(direction, -3 + ytimes, xtimes).setImageColor(img, 4 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y, z).offset(direction, -3 + ytimes, xtimes).setImageColor(img, 8 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -xtimes, 3).setImageColor(img, 8 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -3 + xtimes, 0).setImageColor(img, xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, 0, xtimes).setImageColor(img, 4 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -3, 3 - xtimes).setImageColor(img, 12 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
        if (buildRight) {
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11, z).offset(direction, -3 + ytimes, -4 + xtimes).setImageColor(img, 4 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 4; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y, z).offset(direction, -3 + ytimes, -4 + xtimes).setImageColor(img, 8 + xtimes, 16 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -xtimes, -1).setImageColor(img, 8 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -3 + xtimes, -4).setImageColor(img, xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, 0, -1 - xtimes).setImageColor(img, 4 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
            for (xtimes = 0; xtimes < 4; ++xtimes) {
                for (ytimes = 0; ytimes < 12; ++ytimes) {
                    ((Builder.Single)Builder.Single.setup(world, x, y + 11 - ytimes, z).offset(direction, -3, -4 + xtimes).setImageColor(img, 12 + xtimes, 20 + ytimes, rgb)).build();
                }
            }
        }
    }

    private static class Skin {
        private final BufferedImage image;
        private boolean slim;

        public Skin(BufferedImage image) {
            this.image = image;
            this.slim = false;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public boolean isSlim() {
            return this.slim;
        }

        public void setSlim(boolean slim) {
            this.slim = slim;
        }
    }
}

