/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.entity.SchematicBlockEntity;
import com.slymask3.instantblocks.gui.components.SelectionList;
import com.slymask3.instantblocks.gui.screens.InstantScreen;
import com.slymask3.instantblocks.network.packet.SchematicPacket;
import com.slymask3.instantblocks.util.SchematicHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SchematicScreen
extends InstantScreen {
    private SchematicList schematicList;
    private int selected = -1;
    private final ArrayList<String> schematics = SchematicHelper.SCHEMATICS_LIST;
    private EditBox input;
    private Checkbox center;
    private Checkbox ignoreAir;

    public SchematicScreen(Player player, Level world, BlockPos pos) {
        super(player, world, pos, "ib.gui.schematic.title");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        SchematicBlockEntity blockEntity = (SchematicBlockEntity)this.world.m_7702_(this.pos);
        Button open = new Button(this.f_96543_ / 2 + 134, 50, 20, 20, (Component)new TextComponent(">"), p_88642_ -> Util.m_137581_().m_137644_(new File("schematics")), new Button.OnTooltip(){

            public void m_93752_(Button button, PoseStack poseStack, int x, int y) {
                SchematicScreen.this.m_96617_(poseStack, List.of(new TranslatableComponent("ib.gui.schematic.open").m_7532_()), x, y);
            }

            public void m_142753_(Consumer<Component> consumer) {
                consumer.accept((Component)new TranslatableComponent("ib.gui.schematic.open"));
            }
        });
        this.center = new Checkbox(this.f_96543_ / 2 - 4 - 150, 75, 150, 20, (Component)new TranslatableComponent("ib.gui.schematic.center"), blockEntity.center);
        this.ignoreAir = new Checkbox(this.f_96543_ / 2 + 4, 75, 150, 20, (Component)new TranslatableComponent("ib.gui.schematic.ignore"), blockEntity.ignoreAir);
        this.input = new EditBox(this.f_96547_, this.f_96543_ / 2 - 4 - 150, 50, 284, 20, (Component)new TextComponent("Input")){

            public void m_94164_(String textToWrite) {
                super.m_94164_(textToWrite);
                SchematicScreen.this.checkForSchematic();
            }

            public void m_94180_(int pNum) {
                super.m_94180_(pNum);
                SchematicScreen.this.checkForSchematic();
            }
        };
        this.input.m_94144_(blockEntity.schematic);
        this.schematicList = new SchematicList(this.f_96543_ / 2 - 4 - 150, 111, 302, this.f_96544_ / 4);
        this.m_7787_((GuiEventListener)this.schematicList);
        this.done.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.center);
        this.m_142416_((GuiEventListener)this.ignoreAir);
        this.m_142416_((GuiEventListener)this.input);
        this.m_142416_((GuiEventListener)this.schematicList);
        this.m_142416_((GuiEventListener)open);
        this.m_94718_((GuiEventListener)this.input);
        this.checkForSchematic();
    }

    @Override
    protected void renderLabels(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.schematic.input"), (float)(this.f_96543_ / 2 - 4 - 150), 37.0f, 0xA0A0A0);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.schematic.input"), (float)(this.f_96543_ / 2 - 4 - 150), 37.0f, 0xA0A0A0);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.schematic.file", new Object[]{this.input.m_94155_()}), (float)(this.f_96543_ / 2 - 2 - 150), (float)(this.f_96544_ / 4 + 115), this.done.f_93623_ ? 65280 : 0xAA0000);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.schematic.found", new Object[]{this.schematics.size()}), (float)(this.f_96543_ / 2 - 2 - 150), 100.0f, 0xFFFFFF);
        if (this.schematics.size() == 0) {
            this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.schematic.instructions.1"), (float)(this.f_96543_ / 2 - 3 - 150), 120.0f, 0xAA0000);
            this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.schematic.instructions.2"), (float)(this.f_96543_ / 2 - 3 - 150), 130.0f, 0xAA0000);
            this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.schematic.instructions.3"), (float)(this.f_96543_ / 2 - 3 - 150), 140.0f, 0xAA0000);
        }
    }

    @Override
    public void sendInfo(boolean activate) {
        Common.NETWORK.sendToServer(new SchematicPacket(activate, this.pos, this.input.m_94155_(), this.center.m_93840_(), this.ignoreAir.m_93840_()));
    }

    public void checkForSchematic() {
        this.done.f_93623_ = this.schematics.contains(this.input.m_94155_());
        if (this.done.f_93623_) {
            for (int i = 0; i < this.schematics.size(); ++i) {
                if (!this.schematics.get(i).equals(this.input.m_94155_()) || this.selected == i) continue;
                this.selected = i;
                break;
            }
        } else {
            this.selected = -1;
        }
        this.schematicList.setSelectedSchematic(this.selected);
    }

    public void clickOnSchematic(int index) {
        this.selected = index;
        if (index >= 0 && index <= this.schematics.size()) {
            this.input.m_94144_(this.schematics.get(this.selected));
        }
        this.checkForSchematic();
    }

    public int getSelected() {
        return this.selected;
    }

    class SchematicList
    extends SelectionList<Entry> {
        public SchematicList(int x, int y, int width, int height) {
            super(SchematicScreen.this.f_96541_, x, y, width, height, 18);
            for (int i = 0; i < SchematicScreen.this.schematics.size(); ++i) {
                Entry entry = new Entry(i);
                this.m_7085_((AbstractSelectionList.Entry)entry);
            }
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((Entry)this.m_93511_()));
            }
        }

        protected boolean m_5694_() {
            return SchematicScreen.this.m_7222_() == this;
        }

        public void setSelectedSchematic(int index) {
            if (index > 0 && index < SchematicScreen.this.schematics.size()) {
                this.m_6987_((AbstractSelectionList.Entry)((Entry)this.m_93500_(index)));
                this.m_93494_((AbstractSelectionList.Entry)((Entry)this.m_93511_()));
            } else {
                this.m_6987_(null);
            }
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final int index;

            public Entry(int index) {
                this.index = index;
            }

            public void m_6311_(PoseStack poseStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTick) {
                int entry_y = top + 4;
                if (entry_y > SchematicList.this.f_93390_ - 5 && entry_y + entryHeight < SchematicList.this.f_93391_ + 5) {
                    String string = SchematicScreen.this.schematics.get(this.index);
                    SchematicScreen.this.f_96547_.m_92756_(poseStack, string, (float)(left + entryWidth / 2 - SchematicScreen.this.f_96547_.m_92895_(string) / 2), (float)entry_y, SchematicScreen.this.getSelected() == this.index ? 43520 : 0xFFFFFF, true);
                }
            }

            public boolean m_6375_(double p_96122_, double p_96123_, int p_96124_) {
                if (p_96124_ == 0) {
                    SchematicScreen.this.clickOnSchematic(this.index);
                    return true;
                }
                return false;
            }

            public Component m_142172_() {
                return new TranslatableComponent("narrator.select", new Object[]{SchematicScreen.this.schematics.get(this.index)});
            }
        }
    }
}

