/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.entity.TreeBlockEntity;
import com.slymask3.instantblocks.block.instant.InstantTreeBlock;
import com.slymask3.instantblocks.gui.components.SelectionList;
import com.slymask3.instantblocks.gui.screens.InstantScreen;
import com.slymask3.instantblocks.network.packet.TreePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TreeScreen
extends InstantScreen {
    private int selected = -1;
    private final int[] trees = new int[]{0, 1, 2, 3, 4, 5, 6};
    private Checkbox hollowLogs;
    private Checkbox hollowLeaves;
    private Checkbox airInside;

    public TreeScreen(Player player, Level world, BlockPos pos) {
        super(player, world, pos, "ib.gui.tree.title");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        TreeBlockEntity blockEntity = (TreeBlockEntity)this.world.m_7702_(this.pos);
        this.hollowLogs = new Checkbox(this.f_96543_ / 2 + 4, 50, 150, 20, (Component)new TranslatableComponent("ib.gui.tree.logs"), blockEntity.hollowLogs);
        this.hollowLeaves = new Checkbox(this.f_96543_ / 2 + 4, 72, 150, 20, (Component)new TranslatableComponent("ib.gui.tree.leaves"), blockEntity.hollowLeaves);
        this.airInside = new Checkbox(this.f_96543_ / 2 + 4, 94, 150, 20, (Component)new TranslatableComponent("ib.gui.tree.air"), blockEntity.airInside);
        TreeList treeList = new TreeList(this.f_96543_ / 2 - 4 - 150, 50, 144, 120);
        treeList.setSelectedTree(blockEntity.f_58855_);
        this.m_7787_((GuiEventListener)treeList);
        this.done.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.hollowLogs);
        this.m_142416_((GuiEventListener)this.hollowLeaves);
        this.m_142416_((GuiEventListener)this.airInside);
        this.m_142416_((GuiEventListener)treeList);
    }

    @Override
    protected void renderLabels(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.tree.options"), (float)(this.f_96543_ / 2 + 4), 40.0f, 0xA0A0A0);
        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("ib.gui.tree.type"), (float)(this.f_96543_ / 2 - 2 - 150), 40.0f, 0xA0A0A0);
    }

    @Override
    public void sendInfo(boolean activate) {
        Common.NETWORK.sendToServer(new TreePacket(activate, this.pos, this.selected, this.hollowLogs.m_93840_(), this.hollowLeaves.m_93840_(), this.airInside.m_93840_()));
    }

    public void setSelected(int index) {
        this.selected = index;
        this.done.f_93623_ = index >= 0 && index < this.trees.length;
    }

    public int getSelected() {
        return this.selected;
    }

    class TreeList
    extends SelectionList<Entry> {
        public TreeList(int x, int y, int width, int height) {
            super(TreeScreen.this.f_96541_, x, y, width, height, 18);
            for (int tree : TreeScreen.this.trees) {
                Entry entry = new Entry(tree);
                this.m_7085_((AbstractSelectionList.Entry)entry);
            }
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((Entry)this.m_93511_()));
            }
        }

        protected boolean m_5694_() {
            return TreeScreen.this.m_7222_() == this;
        }

        public void setSelectedTree(int index) {
            if (index > 0 && index < TreeScreen.this.trees.length) {
                this.m_6987_((AbstractSelectionList.Entry)((Entry)this.m_93500_(index)));
                this.m_93494_((AbstractSelectionList.Entry)((Entry)this.m_93511_()));
            } else {
                this.m_6987_(null);
            }
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final int index;

            public Entry(int index) {
                this.index = index;
            }

            public void m_6311_(PoseStack poseStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTick) {
                int entry_y = top + 4;
                if (entry_y > TreeList.this.f_93390_ - 5 && entry_y + entryHeight < TreeList.this.f_93391_ + 5) {
                    String string = InstantTreeBlock.treeToString(this.index, (Player)Minecraft.m_91087_().f_91074_);
                    TreeScreen.this.f_96547_.m_92756_(poseStack, string, (float)(left + entryWidth / 2 - TreeScreen.this.f_96547_.m_92895_(string) / 2), (float)entry_y, TreeScreen.this.getSelected() == this.index ? 43520 : 0xFFFFFF, true);
                }
            }

            public boolean m_6375_(double p_96122_, double p_96123_, int p_96124_) {
                if (p_96124_ == 0) {
                    TreeScreen.this.setSelected(this.index);
                    return true;
                }
                return false;
            }

            public Component m_142172_() {
                return new TranslatableComponent("narrator.select", new Object[]{InstantTreeBlock.treeToString(this.index, (Player)Minecraft.m_91087_().f_91074_)});
            }
        }
    }
}

