/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.network;

import com.slymask3.instantblocks.network.PacketHelper;
import com.slymask3.instantblocks.network.packet.AbstractPacket;
import com.slymask3.instantblocks.network.packet.ClientPacket;
import com.slymask3.instantblocks.network.packet.HarvestPacket;
import com.slymask3.instantblocks.network.packet.SchematicPacket;
import com.slymask3.instantblocks.network.packet.SchematicUpdatePacket;
import com.slymask3.instantblocks.network.packet.SkydivePacket;
import com.slymask3.instantblocks.network.packet.StatuePacket;
import com.slymask3.instantblocks.network.packet.TreePacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgePacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("instantblocks", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void register() {
        int index = 100;
        INSTANCE.registerMessage(++index, ClientPacket.class, (message, buffer) -> message.write(message, (FriendlyByteBuf)buffer), ClientPacket::decode, Handler::client);
        INSTANCE.registerMessage(++index, SkydivePacket.class, (message, buffer) -> message.write(message, (FriendlyByteBuf)buffer), SkydivePacket::decode, Handler::common);
        INSTANCE.registerMessage(++index, StatuePacket.class, (message, buffer) -> message.write(message, (FriendlyByteBuf)buffer), StatuePacket::decode, Handler::common);
        INSTANCE.registerMessage(++index, HarvestPacket.class, (message, buffer) -> message.write(message, (FriendlyByteBuf)buffer), HarvestPacket::decode, Handler::common);
        INSTANCE.registerMessage(++index, TreePacket.class, (message, buffer) -> message.write(message, (FriendlyByteBuf)buffer), TreePacket::decode, Handler::common);
        INSTANCE.registerMessage(++index, SchematicPacket.class, (message, buffer) -> message.write(message, (FriendlyByteBuf)buffer), SchematicPacket::decode, Handler::common);
        INSTANCE.registerMessage(++index, SchematicUpdatePacket.class, (message, buffer) -> message.write(message, (FriendlyByteBuf)buffer), SchematicUpdatePacket::decode, Handler::client);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientHandler {
        public static void handle(AbstractPacket message, Supplier<NetworkEvent.Context> context) {
            if (message.getClass().equals(ClientPacket.class)) {
                PacketHelper.handleClient((ClientPacket)message, (Player)Minecraft.m_91087_().f_91074_);
            } else if (message.getClass().equals(SchematicUpdatePacket.class)) {
                PacketHelper.handleSchematicUpdate((SchematicUpdatePacket)message, (Player)Minecraft.m_91087_().f_91074_);
            }
        }
    }

    public static class Handler {
        public static void common(AbstractPacket message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (message.getClass().equals(SkydivePacket.class)) {
                    PacketHelper.handleSkydive((SkydivePacket)message, (Player)((NetworkEvent.Context)context.get()).getSender());
                } else if (message.getClass().equals(StatuePacket.class)) {
                    PacketHelper.handleStatue((StatuePacket)message, (Player)((NetworkEvent.Context)context.get()).getSender());
                } else if (message.getClass().equals(HarvestPacket.class)) {
                    PacketHelper.handleHarvest((HarvestPacket)message, (Player)((NetworkEvent.Context)context.get()).getSender());
                } else if (message.getClass().equals(TreePacket.class)) {
                    PacketHelper.handleTree((TreePacket)message, (Player)((NetworkEvent.Context)context.get()).getSender());
                } else if (message.getClass().equals(SchematicPacket.class)) {
                    PacketHelper.handleSchematic((SchematicPacket)message, (Player)((NetworkEvent.Context)context.get()).getSender());
                }
            });
            context.get().setPacketHandled(true);
        }

        public static void client(AbstractPacket message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> Handler.lambda$client$2(message, (Supplier)context)));
            context.get().setPacketHandled(true);
        }

        private static /* synthetic */ Runnable lambda$client$2(AbstractPacket message, Supplier context) {
            return () -> Handler.lambda$client$1(message, (Supplier)context);
        }

        private static /* synthetic */ void lambda$client$1(AbstractPacket message, Supplier context) {
            ClientHandler.handle(message, context);
        }
    }
}

