/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.network;

import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.HarvestBlockEntity;
import com.slymask3.instantblocks.block.entity.SchematicBlockEntity;
import com.slymask3.instantblocks.block.entity.SkydiveBlockEntity;
import com.slymask3.instantblocks.block.entity.StatueBlockEntity;
import com.slymask3.instantblocks.block.entity.TreeBlockEntity;
import com.slymask3.instantblocks.network.packet.ClientPacket;
import com.slymask3.instantblocks.network.packet.HarvestPacket;
import com.slymask3.instantblocks.network.packet.InstantPacket;
import com.slymask3.instantblocks.network.packet.SchematicPacket;
import com.slymask3.instantblocks.network.packet.SchematicUpdatePacket;
import com.slymask3.instantblocks.network.packet.SkydivePacket;
import com.slymask3.instantblocks.network.packet.StatuePacket;
import com.slymask3.instantblocks.network.packet.TreePacket;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import com.slymask3.instantblocks.util.SchematicHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PacketHelper {
    private static void activate(InstantPacket message, Level world, Player player) {
        if (message.activate) {
            InstantBlock block = (InstantBlock)Helper.getBlock(world, message.pos);
            block.activate(world, message.pos, player);
        }
    }

    public static void handleClient(ClientPacket message, Player player) {
        if (player != null) {
            if (message.particles != ClientHelper.Particles.NONE.ordinal()) {
                Level world = player.m_183503_();
                ClientHelper.playSound(world, message.pos, ClientHelper.Particles.values()[message.particles]);
                ClientHelper.showParticles(world, message.pos, ClientHelper.Particles.values()[message.particles]);
            }
            if (!message.message.isEmpty()) {
                ClientHelper.sendMessage(player, message.message, message.variable);
            }
        }
    }

    public static void handleSkydive(SkydivePacket message, Player player) {
        Level world;
        SkydiveBlockEntity blockEntity;
        if (player != null && (blockEntity = (SkydiveBlockEntity)(world = player.m_183503_()).m_7702_(message.pos)) != null) {
            blockEntity.update(message._colors, message._radius, message._tp);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleStatue(StatuePacket message, Player player) {
        Level world;
        StatueBlockEntity blockEntity;
        if (player != null && (blockEntity = (StatueBlockEntity)(world = player.m_183503_()).m_7702_(message.pos)) != null) {
            blockEntity.update(message._username, message._head, message._body, message._armLeft, message._armRight, message._legLeft, message._legRight, message._rgb);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleHarvest(HarvestPacket message, Player player) {
        Level world;
        HarvestBlockEntity blockEntity;
        if (player != null && (blockEntity = (HarvestBlockEntity)(world = player.m_183503_()).m_7702_(message.pos)) != null) {
            blockEntity.update(message._logOak, message._logSpruce, message._logBirch, message._logJungle, message._logAcacia, message._logDark, message._wheat, message._carrot, message._potato, message._cactus, message._pumpkin, message._melon, message._sugarcane, message._cocoa, message._mushroom, message._netherwart, message._replant);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleTree(TreePacket message, Player player) {
        Level world;
        TreeBlockEntity blockEntity;
        if (player != null && (blockEntity = (TreeBlockEntity)(world = player.m_183503_()).m_7702_(message.pos)) != null) {
            blockEntity.update(message.type, message.hollowLogs, message.hollowLeaves, message.airInside);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleSchematic(SchematicPacket message, Player player) {
        Level world;
        SchematicBlockEntity blockEntity;
        if (player != null && (blockEntity = (SchematicBlockEntity)(world = player.m_183503_()).m_7702_(message.pos)) != null) {
            blockEntity.update(message._schematic, message._center, message._air);
            PacketHelper.activate(message, world, player);
        }
    }

    public static void handleSchematicUpdate(SchematicUpdatePacket message, Player player) {
        if (player != null) {
            SchematicHelper.SCHEMATICS_LIST = message.schematics;
            ClientHelper.showScreen(ClientHelper.Screen.SCHEMATIC, player, player.m_183503_(), message.pos);
        }
    }

    public static enum PacketID {
        CLIENT,
        SKYDIVE,
        STATUE,
        HARVEST,
        TREE,
        SCHEMATIC,
        SCHEMATIC_UPDATE;

    }
}

