/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.util.Helper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.BlockState;

public class SchematicHelper {
    public static final String SCHEMATICS_DIR = "schematics";
    public static ArrayList<String> SCHEMATICS_LIST = new ArrayList();

    public static Schematic readSchematic(String schematicName) {
        try {
            File file = new File("schematics/" + schematicName);
            FileInputStream fis = new FileInputStream(file);
            CompoundTag tag = NbtIo.m_128939_((InputStream)fis);
            fis.close();
            return new Schematic(tag);
        }
        catch (Exception e) {
            Common.LOG.info("Failed to read schematic: " + e.getMessage());
            return null;
        }
    }

    public static void createSchematicsDir() {
        File dir = new File(SCHEMATICS_DIR);
        if (!dir.exists()) {
            try {
                dir.mkdir();
            }
            catch (SecurityException se) {
                Common.LOG.error("Failed to create schematics directory: " + se.getMessage());
            }
        }
    }

    public static ArrayList<String> getSchematics() {
        ArrayList<String> schematics = new ArrayList<String>();
        File dir = new File("schematics/");
        File[] files = dir.listFiles(file -> file.isFile() && (file.getName().toLowerCase().endsWith(".schematic") || file.getName().toLowerCase().endsWith(".schem")));
        if (files != null) {
            for (File file2 : files) {
                schematics.add(file2.getName());
            }
        }
        return schematics;
    }

    public static class Schematic {
        public final short width;
        public final short height;
        public final short length;
        public final byte[] blocks;
        private final HashMap<Integer, BlockState> map;
        private final HashMap<BlockPos, CompoundTag> blockEntities;
        private final ArrayList<CompoundTag> entities;

        public Schematic(CompoundTag tag) {
            this.width = tag.m_128448_("Width");
            this.height = tag.m_128448_("Height");
            this.length = tag.m_128448_("Length");
            this.blocks = tag.m_128463_("BlockData");
            this.map = new HashMap();
            CompoundTag palette = tag.m_128469_("Palette");
            for (Object blockStateString : palette.m_128431_()) {
                int key = palette.m_128451_((String)blockStateString);
                BlockState state = Helper.readBlockState((String)blockStateString);
                this.map.put(key, state);
            }
            this.blockEntities = new HashMap();
            ListTag blockEntities = tag.m_128437_("BlockEntities", 10);
            for (Tag entity : blockEntities) {
                CompoundTag entityTag = (CompoundTag)entity;
                int[] pos = entityTag.m_128465_("Pos");
                this.blockEntities.put(new BlockPos(pos[0], pos[1], pos[2]), entityTag);
            }
            this.entities = new ArrayList();
            ListTag entities = tag.m_128437_("Entities", 10);
            for (Tag entity : entities) {
                CompoundTag entityTag = (CompoundTag)entity;
                this.entities.add(entityTag);
            }
        }

        public BlockState getBlockState(int index) {
            return this.map.get(this.blocks[index]);
        }

        public CompoundTag getBlockEntityTag(int x, int y, int z) {
            return this.blockEntities.get(new BlockPos(x, y, z));
        }

        public ArrayList<CompoundTag> getEntityTags() {
            return this.entities;
        }
    }
}

