/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.config.ForgeConfig;
import com.slymask3.instantblocks.core.ModBlocks;
import com.slymask3.instantblocks.init.ForgeTiles;
import com.slymask3.instantblocks.init.IRegistryHelper;
import com.slymask3.instantblocks.init.Registration;
import com.slymask3.instantblocks.network.ForgePacketHandler;
import com.slymask3.instantblocks.network.IPacketHandler;
import com.slymask3.instantblocks.network.packet.AbstractPacket;
import com.slymask3.instantblocks.util.SchematicHelper;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="instantblocks")
public class InstantBlocks {
    public InstantBlocks() {
        Common.ITEM_GROUP = new CreativeModeTab(CreativeModeTab.f_40748_.length, "instantblocks"){

            @NotNull
            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ModBlocks.INSTANT_WOOD_HOUSE);
            }
        };
        Common.NETWORK = new PacketHandler();
        Common.TILES = new ForgeTiles();
        Common.CONFIG = new ForgeConfig();
        ForgeConfig.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setupCommon);
        modEventBus.addListener(this::setupRegistry);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        ForgePacketHandler.register();
        SchematicHelper.createSchematicsDir();
    }

    private void setupRegistry(RegisterEvent event) {
        if (event.getForgeRegistry() != null) {
            if (event.getForgeRegistry().getRegistryKey().equals((Object)Registry.f_122901_)) {
                Registration.registerBlocks(new ForgeRegistryHelper<Block>(event.getForgeRegistry()));
            } else if (event.getForgeRegistry().getRegistryKey().equals((Object)Registry.f_122904_)) {
                Registration.registerItems(new ForgeRegistryHelper<Item>(event.getForgeRegistry()));
            } else if (event.getForgeRegistry().getRegistryKey().equals((Object)Registry.f_122907_)) {
                Registration.registerTiles(new ForgeRegistryHelper(event.getForgeRegistry()));
            }
        }
    }

    public static class PacketHandler
    implements IPacketHandler {
        @Override
        public void sendToServer(AbstractPacket message) {
            ForgePacketHandler.INSTANCE.sendToServer((Object)message);
        }

        @Override
        public void sendToClient(ServerPlayer player, AbstractPacket message) {
            ForgePacketHandler.INSTANCE.sendTo((Object)message, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static class ForgeRegistryHelper<T>
    implements IRegistryHelper<T> {
        final IForgeRegistry<T> registry;

        public ForgeRegistryHelper(IForgeRegistry<T> registry) {
            this.registry = registry;
        }

        @Override
        public void register(ResourceLocation name, T entry) {
            this.registry.register(name, entry);
        }
    }
}

