/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.util.Builder;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InstantGlassDomeBlock
extends InstantBlock {
    public InstantGlassDomeBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.5f).m_60918_(SoundType.f_56744_).m_60955_().m_60960_((state, world, pos) -> false).m_60922_((state, world, pos, entityType) -> false).m_60924_((state, world, pos) -> false).m_60971_((state, world, pos) -> false));
        this.setCreateMessage("ib.message.create.dome");
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_GLASS_DOME();
    }

    public boolean m_6104_(@Nonnull BlockState state, BlockState adjacentBlockState, @Nonnull Direction side) {
        return adjacentBlockState.m_60713_((Block)this) || super.m_6104_(state, adjacentBlockState, side);
    }

    @Nonnull
    public VoxelShape m_5909_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.m_83040_();
    }

    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return true;
    }

    @Override
    public boolean build(Level world, int x, int y, int z, Player player) {
        Block glass = Blocks.f_50058_;
        Block torch = Blocks.f_50081_;
        Block air = Blocks.f_50016_;
        int radius = Common.CONFIG.RADIUS_DOME();
        Builder.Circle.setup(world, x, y, z, radius).setBlock(Builder.BlockType.stone()).build();
        Builder.Sphere.setup(world, x, y + 1, z, radius).setOuter(Builder.BlockType.block(glass)).setInner(Builder.BlockType.block(air)).setHalf().build();
        for (int i = 3; i < radius; i += 6) {
            ((Builder.Single)Builder.Single.setup(world, x + i, y + 1, z).setBlock(torch)).build();
            ((Builder.Single)Builder.Single.setup(world, x - i, y + 1, z).setBlock(torch)).build();
            ((Builder.Single)Builder.Single.setup(world, x, y + 1, z + i).setBlock(torch)).build();
            ((Builder.Single)Builder.Single.setup(world, x, y + 1, z - i).setBlock(torch)).build();
        }
        return true;
    }
}

