/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.block.instant;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.TreeBlockEntity;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import com.slymask3.instantblocks.util.Helper;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InstantTreeBlock
extends InstantBlock
implements EntityBlock {
    public InstantTreeBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(SoundType.f_56740_).m_60910_().m_60966_());
        this.setScreen(ClientHelper.Screen.TREE);
    }

    @Override
    public boolean isEnabled() {
        return Common.CONFIG.ENABLE_TREE();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TreeBlockEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    }

    @Override
    public boolean build(Level world, int x_center, int y, int z_center, Player player) {
        TreeBlockEntity blockEntity = (TreeBlockEntity)world.m_7702_(new BlockPos(x_center, y, z_center));
        int size = Common.CONFIG.TREE_SIZE();
        int half = (int)Math.floor(size / 2);
        int x = x_center - half;
        int z = z_center - half;
        switch (blockEntity.f_58855_) {
            case 0: {
                this.buildOak(world, x, y, z, Blocks.f_49999_, Blocks.f_50050_, size, blockEntity);
                break;
            }
            case 1: {
                this.buildSpruce(world, x, y, z, Blocks.f_50000_, Blocks.f_50051_, size, blockEntity);
                break;
            }
            case 2: {
                this.buildBirch(world, x, y, z, Blocks.f_50001_, Blocks.f_50052_, size, blockEntity);
                break;
            }
            case 3: {
                this.buildJungle(world, x, y, z, Blocks.f_50002_, Blocks.f_50053_, size, blockEntity);
                break;
            }
            case 4: {
                this.buildAcacia(world, x, y, z, Blocks.f_50003_, Blocks.f_50054_, size, blockEntity);
                break;
            }
            case 5: {
                this.buildDarkOak(world, x, y, z, Blocks.f_50004_, Blocks.f_50055_, size, blockEntity);
                break;
            }
            case 6: {
                this.buildOak(world, x, y, z, Blocks.f_50212_, Blocks.f_50213_, size, blockEntity);
                break;
            }
            default: {
                Helper.sendMessage(player, "ib.message.error.tree");
                return false;
            }
        }
        this.setCreateMessage("ib.message.create.tree", InstantTreeBlock.treeToString(blockEntity.f_58855_, player));
        return true;
    }

    private void buildOak(Level world, int x, int y, int z, Block log, Block leaves, int size, TreeBlockEntity blockEntity) {
        this.buildLog(world, x, y, z, log, size, blockEntity, false, true, true, true, true, true);
        this.buildLog(world, x, y + size, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 2, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 3, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 4, z, log, size, blockEntity, true, false, true, true, true, true);
        this.buildLeaves(world, x + size * 2, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z - size, leaves, size, blockEntity, false, true, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, true, false, true, false);
        this.buildLeaves(world, x, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, true, false, false);
        this.buildLeaves(world, x, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 2, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x + size * 2, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 3, z, leaves, size, blockEntity, true, false, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 3, z - size, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x, y + size * 3, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 3, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z, leaves, size, blockEntity, true, false, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 4, z, leaves, size, blockEntity, false, false, true, true, true, false);
        this.buildLeaves(world, x, y + size * 4, z + size, leaves, size, blockEntity, false, false, false, true, true, false);
        this.buildLeaves(world, x, y + size * 4, z - size, leaves, size, blockEntity, false, false, true, false, true, false);
        this.buildLeaves(world, x - size, y + size * 4, z + size, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 4, z, leaves, size, blockEntity, false, false, false, false, false, true);
        this.buildLeaves(world, x - size, y + size * 4, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 5, z, leaves, size, blockEntity, true, false, true, true, true, false);
        this.buildLeaves(world, x, y + size * 5, z + size, leaves, size, blockEntity, true, false, false, true, true, true);
        this.buildLeaves(world, x, y + size * 5, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size, leaves, size, blockEntity, true, false, true, false, true, true);
        this.buildLeaves(world, x - size, y + size * 5, z, leaves, size, blockEntity, true, false, true, true, false, true);
    }

    private void buildSpruce(Level world, int x, int y, int z, Block log, Block leaves, int size, TreeBlockEntity blockEntity) {
        this.buildLog(world, x, y, z, log, size, blockEntity, false, true, true, true, true, true);
        this.buildLog(world, x, y + size, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 2, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 3, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 4, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 5, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 6, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 7, z, log, size, blockEntity, true, false, true, true, true, true);
        this.buildLeaves(world, x + size * 3, y + size * 2, z + size * 2, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 2, z + size, leaves, size, blockEntity, true, true, false, false, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 2, z, leaves, size, blockEntity, true, true, false, false, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 2, z - size, leaves, size, blockEntity, true, true, false, false, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 2, z - size * 2, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z + size * 3, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z + size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z - size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z - size * 3, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 2, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 2, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 2, z + size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 2, z - size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 2, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 2, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 2, z + size, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 2, z, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 2, z - size, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 2, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x + size * 2, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 3, z, leaves, size, blockEntity, true, false, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 3, z - size, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x, y + size * 3, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 3, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z, leaves, size, blockEntity, true, false, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 4, z, leaves, size, blockEntity, false, false, true, true, true, false);
        this.buildLeaves(world, x, y + size * 4, z + size, leaves, size, blockEntity, false, false, false, true, true, true);
        this.buildLeaves(world, x, y + size * 4, z - size, leaves, size, blockEntity, false, false, true, false, true, true);
        this.buildLeaves(world, x - size, y + size * 4, z, leaves, size, blockEntity, false, false, true, true, false, true);
        this.buildLeaves(world, x + size * 2, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z, leaves, size, blockEntity, true, true, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z - size, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x, y + size * 5, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 5, z, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 6, z, leaves, size, blockEntity, true, false, true, true, true, false);
        this.buildLeaves(world, x, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, true, true, true);
        this.buildLeaves(world, x, y + size * 6, z - size, leaves, size, blockEntity, true, false, true, false, true, true);
        this.buildLeaves(world, x - size, y + size * 6, z, leaves, size, blockEntity, true, false, true, true, false, true);
        this.buildLeaves(world, x + size, y + size * 8, z, leaves, size, blockEntity, true, true, true, true, true, false);
        this.buildLeaves(world, x, y + size * 8, z + size, leaves, size, blockEntity, true, true, false, true, true, true);
        this.buildLeaves(world, x, y + size * 8, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 8, z - size, leaves, size, blockEntity, true, true, true, false, true, true);
        this.buildLeaves(world, x - size, y + size * 8, z, leaves, size, blockEntity, true, true, true, true, false, true);
        this.buildLeaves(world, x, y + size * 9, z, leaves, size, blockEntity, true, false, true, true, true, true);
    }

    private void buildBirch(Level world, int x, int y, int z, Block log, Block leaves, int size, TreeBlockEntity blockEntity) {
        this.buildLog(world, x, y, z, log, size, blockEntity, false, true, true, true, true, true);
        this.buildLog(world, x, y + size, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 2, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 3, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 4, z, log, size, blockEntity, true, false, true, true, true, true);
        this.buildLeaves(world, x + size * 2, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 2, z - size, leaves, size, blockEntity, false, true, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, true, false, true, false);
        this.buildLeaves(world, x, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, true, false, false);
        this.buildLeaves(world, x, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z + size * 2, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 2, z - size * 2, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 2, z + size, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 2, z, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 2, z - size, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 2, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x + size * 2, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 3, z, leaves, size, blockEntity, true, false, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 3, z - size, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x, y + size * 3, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 3, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 3, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z + size, leaves, size, blockEntity, true, false, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z, leaves, size, blockEntity, true, false, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 3, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 4, z, leaves, size, blockEntity, false, false, true, true, true, false);
        this.buildLeaves(world, x, y + size * 4, z + size, leaves, size, blockEntity, false, false, false, true, true, false);
        this.buildLeaves(world, x, y + size * 4, z - size, leaves, size, blockEntity, false, false, true, false, true, false);
        this.buildLeaves(world, x - size, y + size * 4, z + size, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 4, z, leaves, size, blockEntity, false, false, false, false, false, true);
        this.buildLeaves(world, x - size, y + size * 4, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 5, z, leaves, size, blockEntity, true, false, true, true, true, false);
        this.buildLeaves(world, x, y + size * 5, z + size, leaves, size, blockEntity, true, false, false, true, true, true);
        this.buildLeaves(world, x, y + size * 5, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size, leaves, size, blockEntity, true, false, true, false, true, true);
        this.buildLeaves(world, x - size, y + size * 5, z, leaves, size, blockEntity, true, false, true, true, false, true);
    }

    private void buildJungle(Level world, int x, int y, int z, Block log, Block leaves, int size, TreeBlockEntity blockEntity) {
        this.buildLog(world, x, y, z, log, size, blockEntity, false, true, true, true, true, true);
        this.buildLog(world, x, y + size, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 2, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 3, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 4, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 5, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 6, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 7, z, log, size, blockEntity, true, false, true, true, true, true);
        this.buildLeaves(world, x + size * 2, y + size * 5, z + size, leaves, size, blockEntity, false, true, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z, leaves, size, blockEntity, false, true, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z - size, leaves, size, blockEntity, false, true, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size * 2, leaves, size, blockEntity, false, true, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size * 2, leaves, size, blockEntity, false, true, true, false, true, false);
        this.buildLeaves(world, x, y + size * 5, z + size * 2, leaves, size, blockEntity, false, true, false, true, false, false);
        this.buildLeaves(world, x, y + size * 5, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size * 2, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z + size * 2, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 5, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size * 2, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z + size, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 5, z, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x + size * 2, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 6, z, leaves, size, blockEntity, true, false, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 6, z - size, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 6, z + size * 2, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 6, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 6, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 6, z - size * 2, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x, y + size * 6, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x, y + size * 6, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 6, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 6, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 6, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 6, z, leaves, size, blockEntity, true, false, false, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 6, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 7, z, leaves, size, blockEntity, false, false, true, true, true, false);
        this.buildLeaves(world, x, y + size * 7, z + size, leaves, size, blockEntity, false, false, false, true, true, false);
        this.buildLeaves(world, x, y + size * 7, z - size, leaves, size, blockEntity, false, false, true, false, true, false);
        this.buildLeaves(world, x - size, y + size * 7, z + size, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 7, z, leaves, size, blockEntity, false, false, false, false, false, true);
        this.buildLeaves(world, x - size, y + size * 7, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 8, z, leaves, size, blockEntity, true, false, true, true, true, false);
        this.buildLeaves(world, x, y + size * 8, z + size, leaves, size, blockEntity, true, false, false, true, true, true);
        this.buildLeaves(world, x, y + size * 8, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 8, z - size, leaves, size, blockEntity, true, false, true, false, true, true);
        this.buildLeaves(world, x - size, y + size * 8, z, leaves, size, blockEntity, true, false, true, true, false, true);
    }

    private void buildAcacia(Level world, int x, int y, int z, Block log, Block leaves, int size, TreeBlockEntity blockEntity) {
        this.buildLog(world, x, y, z, log, size, blockEntity, false, true, true, true, true, true);
        this.buildLog(world, x, y + size, z, log, size, blockEntity, false, false, true, true, true, true);
        this.buildLog(world, x, y + size * 2, z, log, size, blockEntity, true, false, true, true, false, true);
        this.buildLog(world, x + size, y + size * 2, z, log, size, blockEntity, true, true, true, true, true, false);
        this.buildLog(world, x + size * 2, y + size * 3, z, log, size, blockEntity, true, true, true, true, true, true);
        this.buildLog(world, x - size, y + size * 3, z, log, size, blockEntity, true, true, true, true, true, true);
        this.buildLog(world, x + size * 3, y + size * 4, z, log, size, blockEntity, true, true, true, true, true, true);
        this.buildLog(world, x - size * 2, y + size * 4, z, log, size, blockEntity, false, true, true, true, true, true);
        this.buildLog(world, x - size * 2, y + size * 5, z, log, size, blockEntity, true, false, true, true, true, true);
        this.buildLeaves(world, x + size * 5, y + size * 4, z + size, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size * 5, y + size * 4, z, leaves, size, blockEntity, true, true, false, false, true, false);
        this.buildLeaves(world, x + size * 5, y + size * 4, z - size, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x + size * 4, y + size * 4, z + size * 2, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size * 4, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 4, y + size * 4, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 4, y + size * 4, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 4, y + size * 4, z - size * 2, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 4, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x + size * 3, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 3, y + size * 4, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 3, y + size * 4, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x + size * 2, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x + size, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x + size, y + size * 4, z, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x + size, y + size * 4, z - size, leaves, size, blockEntity, false, true, true, false, false, true);
        this.buildLeaves(world, x + size * 4, y + size * 5, z + size, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size * 4, y + size * 5, z, leaves, size, blockEntity, true, false, false, false, true, false);
        this.buildLeaves(world, x + size * 4, y + size * 5, z - size, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 5, z + size, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x + size * 3, y + size * 5, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size * 3, y + size * 5, z - size, leaves, size, blockEntity, true, false, true, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z + size, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z - size, leaves, size, blockEntity, true, false, true, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x, y + size * 5, z + size * 3, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size * 3, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x - size, y + size * 5, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z + size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size * 4, y + size * 5, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 4, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size * 4, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size * 4, y + size * 5, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 4, y + size * 5, z - size, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size * 4, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, false, false, false, false);
        this.buildLeaves(world, x - size * 4, y + size * 5, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x - size * 5, y + size * 5, z + size * 2, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 5, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 5, y + size * 5, z, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 5, y + size * 5, z - size, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 5, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x, y + size * 6, z, leaves, size, blockEntity, true, false, true, true, true, false);
        this.buildLeaves(world, x - size, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x - size, y + size * 6, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z - size, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x - size * 2, y + size * 6, z + size * 2, leaves, size, blockEntity, true, false, false, true, true, true);
        this.buildLeaves(world, x - size * 2, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 6, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 6, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 6, z - size * 2, leaves, size, blockEntity, true, false, true, false, true, true);
        this.buildLeaves(world, x - size * 3, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 6, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 6, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x - size * 4, y + size * 6, z, leaves, size, blockEntity, true, false, true, true, false, true);
    }

    private void buildDarkOak(Level world, int x, int y, int z, Block log, Block leaves, int size, TreeBlockEntity blockEntity) {
        this.buildLog(world, x, y, z, log, size, blockEntity, false, true, false, true, true, false);
        this.buildLog(world, x, y + size, z, log, size, blockEntity, false, false, false, true, true, false);
        this.buildLog(world, x, y + size * 2, z, log, size, blockEntity, false, false, false, false, true, false);
        this.buildLog(world, x, y + size * 3, z, log, size, blockEntity, false, false, false, false, true, false);
        this.buildLog(world, x, y + size * 4, z, log, size, blockEntity, false, false, false, false, true, false);
        this.buildLog(world, x, y + size * 5, z, log, size, blockEntity, true, false, false, true, true, false);
        this.buildLog(world, x, y, z - size, log, size, blockEntity, false, true, true, false, true, false);
        this.buildLog(world, x, y + size, z - size, log, size, blockEntity, false, false, true, false, true, false);
        this.buildLog(world, x, y + size * 2, z - size, log, size, blockEntity, false, false, true, false, true, false);
        this.buildLog(world, x, y + size * 3, z - size, log, size, blockEntity, false, false, true, false, true, false);
        this.buildLog(world, x, y + size * 4, z - size, log, size, blockEntity, false, false, true, false, true, false);
        this.buildLog(world, x, y + size * 5, z - size, log, size, blockEntity, true, false, true, false, true, false);
        this.buildLog(world, x - size, y, z, log, size, blockEntity, false, true, false, true, false, true);
        this.buildLog(world, x - size, y + size, z, log, size, blockEntity, false, false, false, true, false, true);
        this.buildLog(world, x - size, y + size * 2, z, log, size, blockEntity, false, false, false, true, false, true);
        this.buildLog(world, x - size, y + size * 3, z, log, size, blockEntity, false, false, false, true, false, true);
        this.buildLog(world, x - size, y + size * 4, z, log, size, blockEntity, false, false, false, true, false, true);
        this.buildLog(world, x - size, y + size * 5, z, log, size, blockEntity, true, false, false, true, false, true);
        this.buildLog(world, x - size, y, z - size, log, size, blockEntity, false, true, true, false, false, true);
        this.buildLog(world, x - size, y + size, z - size, log, size, blockEntity, false, false, true, false, false, true);
        this.buildLog(world, x - size, y + size * 2, z - size, log, size, blockEntity, false, false, true, false, false, true);
        this.buildLog(world, x - size, y + size * 3, z - size, log, size, blockEntity, false, false, true, false, false, true);
        this.buildLog(world, x - size, y + size * 4, z - size, log, size, blockEntity, false, false, true, false, false, true);
        this.buildLog(world, x - size, y + size * 5, z - size, log, size, blockEntity, true, false, true, false, false, true);
        this.buildLog(world, x, y + size * 2, z + size, log, size, blockEntity, false, true, false, true, true, true);
        this.buildLog(world, x, y + size * 3, z + size, log, size, blockEntity, false, false, false, true, true, true);
        this.buildLog(world, x, y + size * 4, z + size, log, size, blockEntity, true, false, false, true, true, true);
        this.buildLeaves(world, x + size * 2, y + size * 4, z + size * 2, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z, leaves, size, blockEntity, false, true, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z - size, leaves, size, blockEntity, false, true, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z - size * 2, leaves, size, blockEntity, false, true, false, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 4, z - size * 3, leaves, size, blockEntity, false, true, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 4, z + size * 3, leaves, size, blockEntity, false, true, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 4, z + size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 4, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 4, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 4, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 4, z - size * 3, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x, y + size * 4, z + size * 3, leaves, size, blockEntity, false, true, false, true, false, false);
        this.buildLeaves(world, x, y + size * 4, z + size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 4, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x, y + size * 4, z - size * 3, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 4, z + size * 3, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 4, z + size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 4, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 4, z - size * 3, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 4, z + size * 2, leaves, size, blockEntity, false, true, false, true, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 4, z, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 4, z - size, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 4, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 4, z - size * 3, leaves, size, blockEntity, false, true, true, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 4, z + size * 2, leaves, size, blockEntity, false, true, false, true, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 4, z + size, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 4, z, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 4, z - size, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 4, z - size * 2, leaves, size, blockEntity, false, true, false, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 4, z - size * 3, leaves, size, blockEntity, false, true, true, false, false, true);
        this.buildLeaves(world, x + size * 3, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, true, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 5, z, leaves, size, blockEntity, true, true, false, false, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 5, z - size, leaves, size, blockEntity, true, true, false, false, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, false, false, true, false);
        this.buildLeaves(world, x + size * 3, y + size * 5, z - size * 3, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z + size, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z - size * 2, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size * 2, y + size * 5, z - size * 3, leaves, size, blockEntity, true, false, true, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size * 3, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size * 2, leaves, size, blockEntity, true, false, false, false, true, false);
        this.buildLeaves(world, x + size, y + size * 5, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size * 2, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size * 3, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 5, z - size * 4, leaves, size, blockEntity, true, true, true, false, true, false);
        this.buildLeaves(world, x, y + size * 5, z + size * 3, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x, y + size * 5, z + size * 2, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size * 2, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size * 3, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 5, z - size * 4, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z + size * 3, leaves, size, blockEntity, true, false, false, true, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z + size * 2, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size * 2, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size * 3, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 5, z - size * 4, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z + size * 2, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z + size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size * 2, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size * 3, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size * 4, leaves, size, blockEntity, true, true, true, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z + size * 3, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 5, z + size * 2, leaves, size, blockEntity, true, false, false, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 5, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 5, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z - size * 2, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z - size * 3, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 3, y + size * 5, z - size * 4, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x - size * 4, y + size * 5, z + size, leaves, size, blockEntity, true, true, false, true, false, true);
        this.buildLeaves(world, x - size * 4, y + size * 5, z, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 4, y + size * 5, z - size, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 4, y + size * 5, z - size * 2, leaves, size, blockEntity, true, true, false, false, false, true);
        this.buildLeaves(world, x - size * 4, y + size * 5, z - size * 3, leaves, size, blockEntity, true, true, true, false, false, true);
        this.buildLeaves(world, x + size * 2, y + size * 6, z, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size * 2, y + size * 6, z - size, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x + size, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x + size, y + size * 6, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 6, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x + size, y + size * 6, z - size * 2, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x, y + size * 6, z + size * 2, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 6, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 6, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 6, z - size * 2, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x, y + size * 6, z - size * 3, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x - size, y + size * 6, z + size * 2, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z - size, leaves, size, blockEntity, false, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z - size * 2, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size, y + size * 6, z - size * 3, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 6, z + size, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size * 2, y + size * 6, z, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 6, z - size, leaves, size, blockEntity, true, false, false, false, false, false);
        this.buildLeaves(world, x - size * 2, y + size * 6, z - size * 2, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 6, z, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size * 3, y + size * 6, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
        this.buildLeaves(world, x, y + size * 7, z, leaves, size, blockEntity, true, false, false, true, true, false);
        this.buildLeaves(world, x, y + size * 7, z - size, leaves, size, blockEntity, true, false, true, false, true, false);
        this.buildLeaves(world, x - size, y + size * 7, z, leaves, size, blockEntity, true, false, false, true, false, true);
        this.buildLeaves(world, x - size, y + size * 7, z - size, leaves, size, blockEntity, true, false, true, false, false, true);
    }

    private void buildLog(Level world, int x, int y, int z, Block block, int size, TreeBlockEntity blockEntity, boolean up, boolean down, boolean north, boolean south, boolean east, boolean west) {
        this.buildBlock(world, x, y, z, block, size, blockEntity.hollowLogs, blockEntity.airInside, up, down, north, south, east, west);
    }

    private void buildLeaves(Level world, int x, int y, int z, Block block, int size, TreeBlockEntity blockEntity, boolean up, boolean down, boolean north, boolean south, boolean east, boolean west) {
        this.buildBlock(world, x, y, z, block, size, blockEntity.hollowLeaves, blockEntity.airInside, up, down, north, south, east, west);
    }

    private void buildBlock(Level world, int x, int y, int z, Block block, int size, boolean hollow, boolean airInside, boolean up, boolean down, boolean north, boolean south, boolean east, boolean west) {
        if (!hollow) {
            ((Builder.Multiple)Builder.Multiple.setup(world, x, y, z, size, size, size).setBlock(block)).build();
        } else {
            if (airInside) {
                ((Builder.Multiple)Builder.Multiple.setup(world, x, y, z, size, size, size).setBlock(Blocks.f_50016_)).build();
            }
            if (up) {
                ((Builder.Multiple)Builder.Multiple.setup(world, x, y + (size - 1), z, size, 1, size).setBlock(block)).build();
            }
            if (down) {
                ((Builder.Multiple)Builder.Multiple.setup(world, x, y, z, size, 1, size).setBlock(block)).build();
            }
            if (north) {
                ((Builder.Multiple)Builder.Multiple.setup(world, x, y, z, size, size, 1).setBlock(block)).build();
            }
            if (south) {
                ((Builder.Multiple)Builder.Multiple.setup(world, x, y, z + (size - 1), size, size, 1).setBlock(block)).build();
            }
            if (east) {
                ((Builder.Multiple)Builder.Multiple.setup(world, x + (size - 1), y, z, 1, size, size).setBlock(block)).build();
            }
            if (west) {
                ((Builder.Multiple)Builder.Multiple.setup(world, x, y, z, 1, size, size).setBlock(block)).build();
            }
        }
    }

    public static String treeToString(int tree, Player player) {
        return switch (tree) {
            case 0 -> Component.m_237113_((String)String.format(Locale.ENGLISH, Language.m_128107_().m_6834_("ib.gui.tree.oak"), new Object[0])).getString();
            case 1 -> Component.m_237113_((String)String.format(Locale.ENGLISH, Language.m_128107_().m_6834_("ib.gui.tree.spruce"), new Object[0])).getString();
            case 2 -> Component.m_237113_((String)String.format(Locale.ENGLISH, Language.m_128107_().m_6834_("ib.gui.tree.birch"), new Object[0])).getString();
            case 3 -> Component.m_237113_((String)String.format(Locale.ENGLISH, Language.m_128107_().m_6834_("ib.gui.tree.jungle"), new Object[0])).getString();
            case 4 -> Component.m_237113_((String)String.format(Locale.ENGLISH, Language.m_128107_().m_6834_("ib.gui.tree.acacia"), new Object[0])).getString();
            case 5 -> Component.m_237113_((String)String.format(Locale.ENGLISH, Language.m_128107_().m_6834_("ib.gui.tree.dark_oak"), new Object[0])).getString();
            case 6 -> Component.m_237113_((String)String.format(Locale.ENGLISH, Language.m_128107_().m_6834_("ib.gui.tree.glass"), new Object[0])).getString();
            default -> "Error";
        };
    }
}

