/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.slymask3.instantblocks.block.entity.SkydiveBlockEntity;
import com.slymask3.instantblocks.util.ColorHelper;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ColorEditBox
extends EditBox {
    private final int index;
    private final Font font;

    public ColorEditBox(Font font, int x, int y, int width, int length, int index, SkydiveBlockEntity tileEntity) {
        super(font, x, y, width, length, (Component)Component.m_237110_((String)"ib.gui.skydive.color", (Object[])new Object[]{index + 1}));
        this.font = font;
        this.index = index;
        this.m_94144_(tileEntity.color[index]);
    }

    public Color getColor() {
        return ColorHelper.textToColor(this.m_94155_());
    }

    public void renderLabel(PoseStack poseStack) {
        this.font.m_92763_(poseStack, (Component)Component.m_237110_((String)"ib.gui.skydive.color", (Object[])new Object[]{this.index + 1}), (float)(this.f_93620_ - 50), (float)(this.f_93621_ + 3), ColorHelper.textToColor(this.m_94155_()).getRGB());
    }

    public void setRandomHex() {
        this.m_94144_(this.createRandomHex());
    }

    private String createRandomHex() {
        Color color = ColorHelper.generateRandomColor();
        return String.format("%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public Button getClearButton() {
        return new ClearButton(this.f_93620_ + this.f_93618_ + 5, this.f_93621_ + 1, onPress -> this.m_94144_(""));
    }

    public static class ClearButton
    extends Button {
        public ClearButton(int x, int y, Button.OnPress onPress) {
            super(x, y, 12, 12, (Component)Component.m_237113_((String)"X"), onPress);
        }

        public void m_6303_(PoseStack p_86777_, int p_86778_, int p_86779_, float p_86780_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("realms", "textures/gui/realms/cross_icon.png"));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = this.m_198029_() ? 12.0f : 0.0f;
            ClearButton.m_93133_((PoseStack)p_86777_, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)f, (int)12, (int)12, (int)12, (int)24);
        }
    }
}

