/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.entity.SkydiveBlockEntity;
import com.slymask3.instantblocks.gui.components.ColorEditBox;
import com.slymask3.instantblocks.gui.screens.InstantScreen;
import com.slymask3.instantblocks.network.packet.SkydivePacket;
import java.util.ArrayList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SkydiveScreen
extends InstantScreen {
    private final ColorEditBox[] color = new ColorEditBox[11];
    private final Button[] colorClear = new Button[11];
    private Checkbox tp;
    private EditBox radius;

    public SkydiveScreen(Player player, Level world, BlockPos pos) {
        super(player, world, pos, "ib.gui.skydive.title");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        SkydiveBlockEntity blockEntity = (SkydiveBlockEntity)this.world.m_7702_(this.pos);
        Button random = new Button(this.f_96543_ / 2 + 4, this.f_96544_ / 4 + 98 + 12, 150, 20, (Component)Component.m_237115_((String)"ib.gui.skydive.random"), p_88642_ -> this.setRandom());
        this.tp = new Checkbox(this.f_96543_ / 2 + 4, this.f_96544_ / 4 + 76 + 12, 150, 20, (Component)Component.m_237115_((String)"ib.gui.skydive.teleport"), blockEntity.teleport);
        EditBox radiusField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 4 - 100 - 12, this.f_96544_ / 4 + 100 + 12, 110, 16, (Component)Component.m_237113_((String)"radius")){

            public void m_94164_(String textToWrite) {
                if (Character.isDigit(textToWrite.charAt(0)) && this.m_94155_().length() < 4) {
                    super.m_94164_(textToWrite);
                }
            }
        };
        radiusField.m_94144_(String.valueOf(blockEntity.radius));
        this.radius = radiusField;
        int cutoff = 6;
        for (int i = 0; i < this.color.length; ++i) {
            int color_y;
            int color_x;
            if (i < cutoff) {
                color_x = this.f_96543_ / 2 - 4 - 100;
                color_y = 45 + 18 * i;
            } else {
                color_x = this.f_96543_ / 2 + 4 + 50;
                color_y = 45 + 18 * (i - cutoff);
            }
            this.color[i] = new ColorEditBox(this.f_96547_, color_x, color_y, 60, 14, i, blockEntity);
            this.colorClear[i] = this.color[i].getClearButton();
            this.m_142416_((GuiEventListener)this.color[i]);
            this.m_142416_((GuiEventListener)this.colorClear[i]);
        }
        this.m_142416_((GuiEventListener)random);
        this.m_142416_((GuiEventListener)this.tp);
        this.m_142416_((GuiEventListener)this.radius);
    }

    @Override
    protected void renderLabels(PoseStack poseStack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)"ib.gui.skydive.input"), (float)(this.f_96543_ / 2 - 4 - 150), 33.0f, 0xA0A0A0);
        this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)"ib.gui.skydive.radius"), (float)(this.f_96543_ / 2 - 4 - 150), (float)(this.f_96544_ / 4 + 104 + 12), 0xE0E0E0);
        for (ColorEditBox colorEditBox : this.color) {
            colorEditBox.renderLabel(poseStack);
        }
    }

    @Override
    public void sendInfo(boolean activate) {
        int radius;
        try {
            radius = Integer.parseInt(this.radius.m_94155_());
        }
        catch (NumberFormatException e) {
            radius = Common.CONFIG.SKYDIVE_RADIUS();
        }
        String[] colors = this.getColors();
        Common.NETWORK.sendToServer(new SkydivePacket(activate, this.pos, colors.length, colors, radius, this.tp.m_93840_()));
    }

    private String[] getColors() {
        ArrayList<String> colorsBuilder = new ArrayList<String>();
        for (ColorEditBox colorEditBox : this.color) {
            if (colorEditBox.m_94155_().equals("")) continue;
            colorsBuilder.add(colorEditBox.m_94155_());
        }
        return colorsBuilder.toArray(new String[0]);
    }

    private void setRandom() {
        for (ColorEditBox colorEditBox : this.color) {
            colorEditBox.setRandomHex();
        }
    }
}

