/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.network.packet;

import com.slymask3.instantblocks.network.PacketHelper;
import com.slymask3.instantblocks.network.packet.AbstractPacket;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class SchematicUpdatePacket
extends AbstractPacket {
    public final int amount;
    public final ArrayList<String> schematics;
    public final BlockPos pos;

    public SchematicUpdatePacket(ArrayList<String> schematics, BlockPos pos) {
        super(PacketHelper.PacketID.SCHEMATIC_UPDATE);
        this.amount = schematics.size();
        this.schematics = schematics;
        this.pos = pos;
    }

    @Override
    public <PKT extends AbstractPacket> FriendlyByteBuf write(PKT packet, FriendlyByteBuf buffer) {
        SchematicUpdatePacket message = (SchematicUpdatePacket)packet;
        buffer.writeInt(message.amount);
        for (int i = 0; i < message.schematics.size(); ++i) {
            buffer.m_130070_(message.schematics.get(i));
        }
        buffer.m_130064_(message.pos);
        return buffer;
    }

    public static SchematicUpdatePacket decode(FriendlyByteBuf buffer) {
        int amount = buffer.readInt();
        ArrayList<String> schematics = new ArrayList<String>();
        for (int i = 0; i < amount; ++i) {
            schematics.add(buffer.m_130277_());
        }
        BlockPos pos = buffer.m_130135_();
        return new SchematicUpdatePacket(schematics, pos);
    }
}

