/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantBlock;
import com.slymask3.instantblocks.block.entity.ColorBlockEntity;
import com.slymask3.instantblocks.core.ModBlocks;
import com.slymask3.instantblocks.util.ColorHelper;
import com.slymask3.instantblocks.util.Helper;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class Builder {

    public static class Context
    extends BlockPlaceContext {
        public Context(Level world, BlockPos pos) {
            super(world, null, InteractionHand.MAIN_HAND, ItemStack.f_41583_, new BlockHitResult(Vec3.f_82478_, Direction.DOWN, pos, false));
        }
    }

    public static class Sphere
    extends Base<Sphere> {
        final int radius;
        BlockType outerBlockType;
        BlockType innerBlockType;
        boolean half;

        private Sphere(Level world, int x, int y, int z, int radius) {
            super(world, x, y, z);
            this.radius = radius;
            this.half = false;
        }

        public static Sphere setup(Level world, int x, int y, int z, int radius) {
            return new Sphere(world, x, y, z, radius);
        }

        @Override
        public Sphere setBlock(BlockType type) {
            this.outerBlockType = type;
            this.innerBlockType = type;
            return this;
        }

        public Sphere setOuter(BlockType type) {
            this.outerBlockType = type;
            return this;
        }

        public Sphere setInner(BlockType type) {
            this.innerBlockType = type;
            return this;
        }

        public Sphere setHalf() {
            this.half = true;
            return this;
        }

        @Override
        public void build() {
            for (int xc = 0; xc <= 2 * this.radius; ++xc) {
                for (int zc = 0; zc <= 2 * this.radius; ++zc) {
                    for (int yc = 0; yc <= 2 * this.radius; ++yc) {
                        double distance = Math.sqrt((xc - this.radius) * (xc - this.radius) + (zc - this.radius) * (zc - this.radius) + (yc - this.radius) * (yc - this.radius));
                        int y_pos = this.y + yc - this.radius;
                        if (y_pos < this.y && this.half) continue;
                        if (distance > (double)this.radius - 0.4 && distance < (double)this.radius + 0.5) {
                            ((Single)Single.setup(this.world, this.x + xc - this.radius, this.y + yc - this.radius, this.z + zc - this.radius).setBlock(this.outerBlockType)).build();
                            continue;
                        }
                        if (!(distance < (double)this.radius - 0.3)) continue;
                        ((Single)Single.setup(this.world, this.x + xc - this.radius, this.y + yc - this.radius, this.z + zc - this.radius).setBlock(this.innerBlockType)).build();
                    }
                }
            }
        }
    }

    public static class Circle
    extends Base<Circle> {
        BlockType outerBlockType;
        BlockType innerBlockType;
        final int radius;

        private Circle(Level world, int x, int y, int z, int radius) {
            super(world, x, y, z);
            this.radius = radius;
        }

        public static Circle setup(Level world, int x, int y, int z, int radius) {
            return new Circle(world, x, y, z, radius);
        }

        @Override
        public Circle setBlock(BlockType type) {
            this.outerBlockType = type;
            this.innerBlockType = type;
            return this;
        }

        public Circle setOuter(BlockType type) {
            this.outerBlockType = type;
            return this;
        }

        public Circle setInner(BlockType type) {
            this.innerBlockType = type;
            return this;
        }

        @Override
        public void build() {
            for (int row = 0; row <= 2 * this.radius; ++row) {
                for (int col = 0; col <= 2 * this.radius; ++col) {
                    double distance = Math.sqrt((row - this.radius) * (row - this.radius) + (col - this.radius) * (col - this.radius));
                    if (distance > (double)this.radius - 0.4 && distance < (double)this.radius + 0.5) {
                        ((Single)Single.setup(this.world, this.x + row - this.radius, this.y, this.z + col - this.radius).setBlock(this.outerBlockType)).build();
                        continue;
                    }
                    if (!(distance < (double)this.radius - 0.3)) continue;
                    ((Single)Single.setup(this.world, this.x + row - this.radius, this.y, this.z + col - this.radius).setBlock(this.innerBlockType)).build();
                }
            }
        }
    }

    public static class Multiple
    extends Base<Multiple> {
        final int x1;
        final int y1;
        final int z1;
        final int x2;
        final int y2;
        final int z2;

        private Multiple(Level world, int x, int y, int z, int x1, int y1, int z1, int x2, int y2, int z2) {
            super(world, x, y, z);
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.x2 = x2;
            this.y2 = y2;
            this.z2 = z2;
        }

        public static Multiple setup(Level world, int x, int y, int z, Direction direction, int forward, int back, int left, int right, int forwardX, int backX, int leftX, int rightX, int upX, int downX) {
            int x1 = x;
            int z1 = z;
            int x2 = x;
            int z2 = z;
            int y2 = y + upX - downX;
            if (direction == Direction.SOUTH) {
                x1 = x - left + right;
                z1 = z - forward + back;
                x2 = x1 - leftX + rightX;
                z2 = z1 - forwardX + backX;
            } else if (direction == Direction.WEST) {
                x1 = x + forward - back;
                z1 = z - left + right;
                x2 = x1 + forwardX - backX;
                z2 = z1 - leftX + rightX;
            } else if (direction == Direction.NORTH) {
                x1 = x + left - right;
                z1 = z + forward - back;
                x2 = x1 + leftX - rightX;
                z2 = z1 + forwardX - backX;
            } else if (direction == Direction.EAST) {
                x1 = x - forward + back;
                z1 = z + left - right;
                x2 = x1 - forwardX + backX;
                z2 = z1 + leftX - rightX;
            }
            return new Multiple(world, x, y, z, x1, y, z1, x2, y2, z2);
        }

        public static Multiple setup(Level world, int x_start, int y_start, int z_start, int x_times, int y_times, int z_times) {
            return new Multiple(world, x_start, y_start, z_start, x_start, y_start, z_start, x_start + x_times - 1, y_start + y_times - 1, z_start + z_times - 1);
        }

        @Override
        public void build() {
            boolean x_dir = Helper.isPositive(this.x1 - this.x2);
            boolean y_dir = Helper.isPositive(this.y1 - this.y2);
            boolean z_dir = Helper.isPositive(this.z1 - this.z2);
            int y_cur = this.y1;
            while (y_dir ? y_cur >= this.y2 : y_cur <= this.y2) {
                int z_cur = this.z1;
                while (z_dir ? z_cur >= this.z2 : z_cur <= this.z2) {
                    int x_cur = this.x1;
                    while (x_dir ? x_cur >= this.x2 : x_cur <= this.x2) {
                        ((Single)((Single)Single.setup(this.world, x_cur, y_cur, z_cur).setBlock(this.blockType)).setDirection(this.direction)).build();
                        x_cur += x_dir ? -1 : 1;
                    }
                    z_cur += z_dir ? -1 : 1;
                }
                y_cur += y_dir ? -1 : 1;
            }
        }
    }

    public static class Single
    extends Base<Single> {
        private Single(Level world, int x, int y, int z) {
            super(world, x, y, z);
        }

        public Single offset(Direction direction, int forwardBack, int leftRight) {
            int forward = Helper.isPositive(forwardBack) ? 0 : Math.abs(forwardBack);
            int back = Helper.isPositive(forwardBack) ? forwardBack : 0;
            int left = Helper.isPositive(leftRight) ? leftRight : 0;
            int right = Helper.isPositive(leftRight) ? 0 : Math.abs(leftRight);
            return this.offset(direction, forward, back, left, right, 0, 0);
        }

        public Single offset(Direction direction, int forward, int back, int left, int right) {
            return this.offset(direction, forward, back, left, right, 0, 0);
        }

        public Single offset(Direction direction, int forward, int back, int left, int right, int up, int down) {
            this.y = this.y + up - down;
            if (direction == Direction.SOUTH) {
                this.x = this.x - left + right;
                this.z = this.z - forward + back;
            } else if (direction == Direction.WEST) {
                this.x = this.x + forward - back;
                this.z = this.z - left + right;
            } else if (direction == Direction.NORTH) {
                this.x = this.x + left - right;
                this.z = this.z + forward - back;
            } else if (direction == Direction.EAST) {
                this.x = this.x - forward + back;
                this.z = this.z + left - right;
            }
            return this;
        }

        public static Single setup(Level world, int x, int y, int z) {
            return new Single(world, x, y, z);
        }

        public static Single setup(Level world, BlockPos pos) {
            return new Single(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }

        @Override
        public void build() {
            BlockState state = this.blockType.getBlockState(this.world, this.y);
            Block block = this.blockType.getBlock(this.world, this.y);
            Block getBlock = this.getBlock();
            if (Common.CONFIG.KEEP_BLOCKS() && getBlock instanceof InstantBlock) {
                return;
            }
            if (this.world.m_46472_().equals((Object)Level.f_46429_) && block.equals(Blocks.f_49990_) && !Common.CONFIG.ALLOW_WATER_IN_NETHER()) {
                state = Blocks.f_50016_.m_49966_();
            }
            if (this.canSet(getBlock)) {
                Context context;
                if (block instanceof CrossCollisionBlock && (state = block.m_5573_((BlockPlaceContext)(context = new Context(this.world, new BlockPos(this.x, this.y, this.z))))) == null) {
                    return;
                }
                if (block instanceof SlabBlock && this.direction == Direction.UP) {
                    this.direction = null;
                    state = (BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP);
                }
                if (this.direction != null && state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)this.direction);
                }
                if (block == Blocks.f_50093_) {
                    state = (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7));
                }
                if (block instanceof BedBlock && this.direction != null) {
                    state = (BlockState)state.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD);
                }
                if (block instanceof LeavesBlock) {
                    state = (BlockState)state.m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.TRUE);
                }
                if (block instanceof ChestBlock && this.direction != null) {
                    BlockPos left_pos = new BlockPos(this.x, this.y, this.z).m_5484_(this.direction.m_122428_(), 1);
                    BlockPos right_pos = new BlockPos(this.x, this.y, this.z).m_5484_(this.direction.m_122427_(), 1);
                    BlockState left = this.world.m_8055_(left_pos);
                    BlockState right = this.world.m_8055_(right_pos);
                    if (left.m_60734_() == Blocks.f_50087_ && left.m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE && left.m_61143_((Property)ChestBlock.f_51478_) == this.direction) {
                        this.world.m_7731_(left_pos, (BlockState)state.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT), this.flag);
                        state = (BlockState)state.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT);
                    } else if (right.m_60734_() == Blocks.f_50087_ && right.m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE && right.m_61143_((Property)ChestBlock.f_51478_) == this.direction) {
                        this.world.m_7731_(left_pos, (BlockState)state.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT), this.flag);
                        state = (BlockState)state.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT);
                    }
                }
                this.world.m_7731_(new BlockPos(this.x, this.y, this.z), state, this.flag);
                if (block instanceof DoorBlock) {
                    this.world.m_7731_(new BlockPos(this.x, this.y, this.z).m_7494_(), (BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER), 3);
                }
                if (block instanceof BedBlock && this.direction != null) {
                    this.world.m_7731_(new BlockPos(this.x, this.y, this.z).m_5484_(this.direction.m_122424_(), 1), (BlockState)state.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT), 3);
                }
                if (this.blockType.isColor()) {
                    try {
                        ColorBlockEntity entity = (ColorBlockEntity)this.world.m_7702_(new BlockPos(this.x, this.y, this.z));
                        if (entity != null) {
                            entity.color = this.blockType.getColor();
                        }
                    }
                    catch (Exception e) {
                        Common.LOG.info(e.getMessage());
                    }
                }
            }
        }

        private boolean canSet(Block block) {
            return block.m_155943_() >= 0.0f || block.equals(Blocks.f_50016_);
        }

        public Block getBlock() {
            return this.world.m_8055_(new BlockPos(this.x, this.y, this.z)).m_60734_();
        }

        public BlockEntity getBlockEntity() {
            return this.world.m_7702_(new BlockPos(this.x, this.y, this.z));
        }
    }

    public static abstract class Base<T extends Base<T>> {
        final Level world;
        int x;
        int y;
        int z;
        BlockType blockType;
        Direction direction;
        final int flag;

        private Base(Level world, int x, int y, int z) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.flag = 2;
        }

        public T setBlock(BlockType blockType) {
            this.blockType = blockType;
            return (T)this;
        }

        public T setBlock(Block block) {
            return this.setBlock(block.m_49966_());
        }

        public T setBlock(BlockState state) {
            return this.setBlock(BlockType.block(state));
        }

        public T setColor(int color) {
            return this.setBlock(BlockType.color(color));
        }

        public T setImageColor(BufferedImage image, int x, int y, boolean useRGB) {
            return useRGB ? this.setColor(image.getRGB(x, y)) : this.setBlock(ColorHelper.getWoolColor(ColorHelper.getColorAt(image, x, y)));
        }

        public T setStone() {
            return this.setBlock(BlockType.stone());
        }

        public T setDirection(Direction direction) {
            this.direction = direction;
            return (T)this;
        }

        public void build() {
        }
    }

    public static class BlockType {
        final Type type;
        final BlockState state;
        final int color;

        private BlockType(Type type, BlockState state, int color) {
            this.type = type;
            this.state = state;
            this.color = color;
        }

        public static BlockType block(Block block) {
            return BlockType.block(block.m_49966_());
        }

        public static BlockType block(BlockState state) {
            return new BlockType(Type.BLOCK, state, 0);
        }

        public static BlockType color(int color) {
            return BlockType.color(color, ModBlocks.COLOR);
        }

        public static BlockType color(int color, Block block) {
            return new BlockType(Type.COLOR, block.m_49966_(), color);
        }

        public static BlockType stone() {
            return new BlockType(Type.STONE, null, 0);
        }

        public Type getType() {
            return this.type;
        }

        public boolean isColor() {
            return this.type == Type.COLOR;
        }

        public Block getBlock(Level world, int y) {
            return this.getBlockState(world, y).m_60734_();
        }

        public BlockState getBlockState(Level world, int y) {
            if (this.type == Type.STONE) {
                BlockState state;
                ResourceKey dimension = world.m_46472_();
                if (dimension.equals((Object)Level.f_46428_)) {
                    if (y > 8) {
                        state = Blocks.f_50069_.m_49966_();
                    } else if (y < 0) {
                        state = Blocks.f_152550_.m_49966_();
                    } else {
                        ArrayList<Helper.WeightedBlock> blocks = new ArrayList<Helper.WeightedBlock>();
                        blocks.add(new Helper.WeightedBlock(Blocks.f_50069_, y + 1));
                        blocks.add(new Helper.WeightedBlock(Blocks.f_152550_, 10 - y + 1));
                        state = Helper.getRandomBlock(blocks).m_49966_();
                    }
                } else {
                    state = dimension.equals((Object)Level.f_46429_) ? Blocks.f_50134_.m_49966_() : (dimension.equals((Object)Level.f_46430_) ? Blocks.f_50259_.m_49966_() : Blocks.f_50069_.m_49966_());
                }
                return state;
            }
            return this.state;
        }

        public int getColor() {
            return this.color;
        }

        static enum Type {
            BLOCK,
            COLOR,
            STONE;

        }
    }
}

