/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.block.InstantLiquidBlock;
import com.slymask3.instantblocks.block.entity.ColorBlockEntity;
import com.slymask3.instantblocks.gui.screens.HarvestScreen;
import com.slymask3.instantblocks.gui.screens.SchematicScreen;
import com.slymask3.instantblocks.gui.screens.SkydiveScreen;
import com.slymask3.instantblocks.gui.screens.StatueScreen;
import com.slymask3.instantblocks.gui.screens.TreeScreen;
import com.slymask3.instantblocks.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ClientHelper {
    public static void playSound(Level world, BlockPos pos, Particles particles) {
        SoundEvent sound = switch (particles) {
            case Particles.GENERATE -> new SoundEvent(new ResourceLocation("minecraft", Common.CONFIG.SOUND_GENERATE()));
            case Particles.NO_LIQUID -> new SoundEvent(new ResourceLocation("minecraft", Common.CONFIG.SOUND_NO_LIQUID()));
            default -> SoundEvents.f_12275_;
        };
        world.m_5594_((Player)Minecraft.m_91087_().f_91074_, pos, sound, SoundSource.BLOCKS, 0.4f, 1.0f);
    }

    public static void showParticles(Level world, BlockPos pos, Particles particles) {
        if (Common.CONFIG.SHOW_EFFECTS()) {
            switch (particles) {
                case GENERATE: {
                    for (double i = 0.0; i <= 1.0; i += 0.2) {
                        for (double n = 0.0; n <= 1.0; n += 0.2) {
                            for (double v = 0.0; v <= 1.0; v += 0.2) {
                                world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, (double)pos.m_123341_() + i, (double)pos.m_123342_() + v, (double)pos.m_123343_() + n, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                    break;
                }
                case NO_LIQUID: {
                    world.m_7106_((ParticleOptions)InstantLiquidBlock.WHITE_DUST, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)InstantLiquidBlock.WHITE_DUST, (double)pos.m_123341_() + 1.2, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)InstantLiquidBlock.WHITE_DUST, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 1.2, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)InstantLiquidBlock.WHITE_DUST, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.2, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)InstantLiquidBlock.WHITE_DUST, (double)pos.m_123341_() - 0.2, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                    world.m_7106_((ParticleOptions)InstantLiquidBlock.WHITE_DUST, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() - 0.2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static void sendMessage(Player player, String message, String variable) {
        if (Common.CONFIG.SHOW_MESSAGES() && Helper.isClient(player.m_9236_())) {
            player.m_5661_((Component)Component.m_237110_((String)message, (Object[])new Object[]{variable.isEmpty() ? new Object[]{} : variable}), true);
        }
    }

    public static void showScreen(Screen screen, Player player, Level world, BlockPos pos) {
        if (Helper.isClient(world)) {
            switch (screen) {
                case SKYDIVE: {
                    Minecraft.m_91087_().m_91152_((net.minecraft.client.gui.screens.Screen)new SkydiveScreen(player, world, pos));
                    break;
                }
                case STATUE: {
                    Minecraft.m_91087_().m_91152_((net.minecraft.client.gui.screens.Screen)new StatueScreen(player, world, pos));
                    break;
                }
                case HARVEST: {
                    Minecraft.m_91087_().m_91152_((net.minecraft.client.gui.screens.Screen)new HarvestScreen(player, world, pos));
                    break;
                }
                case TREE: {
                    Minecraft.m_91087_().m_91152_((net.minecraft.client.gui.screens.Screen)new TreeScreen(player, world, pos));
                    break;
                }
                case SCHEMATIC: {
                    Minecraft.m_91087_().m_91152_((net.minecraft.client.gui.screens.Screen)new SchematicScreen(player, world, pos));
                }
            }
        }
    }

    public static enum Particles {
        NONE,
        GENERATE,
        NO_LIQUID;

    }

    public static enum Screen {
        STATUE,
        HARVEST,
        SKYDIVE,
        SCHEMATIC,
        TREE;

    }

    public static class Color
    implements BlockColor {
        public int m_92566_(BlockState state, BlockAndTintGetter blockAndTintGetter, BlockPos pos, int tintIndex) {
            if (blockAndTintGetter == null) {
                return -1;
            }
            BlockEntity tileEntity = blockAndTintGetter.m_7702_(pos);
            if (tileEntity instanceof ColorBlockEntity) {
                return ((ColorBlockEntity)tileEntity).color;
            }
            return -1;
        }
    }
}

