/*
 * Decompiled with CFR 0.152.
 */
package com.slymask3.instantblocks.util;

import com.slymask3.instantblocks.Common;
import com.slymask3.instantblocks.item.InstantWandItem;
import com.slymask3.instantblocks.network.packet.ClientPacket;
import com.slymask3.instantblocks.util.Builder;
import com.slymask3.instantblocks.util.ClientHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Helper {
    public static boolean isServer(Level world) {
        return !world.m_5776_();
    }

    public static boolean isClient(Level world) {
        return world.m_5776_();
    }

    public static void giveExp(Level world, Player player, int amount) {
        if (amount > 0 && Helper.isServer(world)) {
            player.m_6756_(amount);
        }
    }

    public static void teleport(Level world, Player player, int x, int y, int z) {
        if (Helper.isServer(world)) {
            player.m_6021_((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }
    }

    public static void addToChest(ChestBlockEntity chest, Block block, int amount) {
        Helper.addToChest(chest, block.m_5456_(), amount);
    }

    public static void addToChest(ChestBlockEntity chest, Item item, int amount) {
        if (chest != null) {
            ItemStack itemStack = new ItemStack((ItemLike)item, amount);
            for (int i = 0; i < chest.m_6643_(); ++i) {
                ItemStack itemStackSlot = chest.m_8020_(i);
                if (itemStackSlot.m_41656_(itemStack) && itemStackSlot.m_41613_() < itemStackSlot.m_41741_()) {
                    chest.m_6836_(i, new ItemStack((ItemLike)item, itemStackSlot.m_41613_() + amount));
                    break;
                }
                if (chest.m_8020_(i) != ItemStack.f_41583_) continue;
                chest.m_6836_(i, new ItemStack((ItemLike)item, amount));
                break;
            }
        }
    }

    public static boolean isWand(ItemStack is) {
        return is.m_41720_() instanceof InstantWandItem;
    }

    public static int wandDamage(Block block) {
        return switch (block.m_7705_().substring("instantblocks".length() + 7)) {
            case "instant_wood_house" -> Common.CONFIG.DAMAGE_WOODEN_HOUSE();
            case "instant_mining_ladder" -> Common.CONFIG.DAMAGE_MINING_LADDER();
            case "instant_glass_dome" -> Common.CONFIG.DAMAGE_GLASS_DOME();
            case "instant_farm" -> Common.CONFIG.DAMAGE_FARM();
            case "instant_skydive" -> Common.CONFIG.DAMAGE_SKYDIVE();
            case "instant_grinder" -> Common.CONFIG.DAMAGE_GRINDER();
            case "instant_pool" -> Common.CONFIG.DAMAGE_POOL();
            case "instant_escape_ladder" -> Common.CONFIG.DAMAGE_ESCAPE_LADDER();
            case "instant_water" -> Common.CONFIG.DAMAGE_WATER();
            case "instant_lava" -> Common.CONFIG.DAMAGE_LAVA();
            case "instant_suction" -> Common.CONFIG.DAMAGE_SUCTION();
            case "instant_rail" -> Common.CONFIG.DAMAGE_RAIL();
            case "instant_statue" -> Common.CONFIG.DAMAGE_STATUE();
            case "instant_harvest" -> Common.CONFIG.DAMAGE_HARVEST();
            case "instant_light" -> Common.CONFIG.DAMAGE_LIGHT();
            case "instant_schematic" -> Common.CONFIG.DAMAGE_SCHEMATIC();
            case "instant_tree" -> Common.CONFIG.DAMAGE_TREE();
            default -> 1;
        };
    }

    public static boolean isPositive(int i) {
        if (i == 0) {
            return true;
        }
        return i >> 31 == 0;
    }

    public static boolean isDoubleChest(ChestBlockEntity chest) {
        return chest.m_6643_() == 54;
    }

    public static int getMinSkydive(Level world) {
        int min = Common.CONFIG.SKYDIVE_MIN();
        if (min < world.m_141937_() - 4) {
            min = world.m_141937_() - 5;
        }
        return min;
    }

    public static int getMaxSkydive(Level world) {
        int max = Common.CONFIG.SKYDIVE_MAX();
        if (max > world.m_151558_() - 3) {
            max = world.m_151558_() - 4;
        }
        return max;
    }

    public static void sendMessage(Player player, String message) {
        Helper.sendMessage(player, message, "", BlockPos.f_121853_, ClientHelper.Particles.NONE);
    }

    public static void sendMessage(Player player, String message, String variable) {
        Helper.sendMessage(player, message, variable, BlockPos.f_121853_, ClientHelper.Particles.NONE);
    }

    public static void sendMessage(Player player, String message, String variable, BlockPos pos) {
        Helper.sendMessage(player, message, variable, pos, ClientHelper.Particles.GENERATE);
    }

    public static void sendMessage(Player player, String message, String variable, BlockPos pos, ClientHelper.Particles particles) {
        if (Helper.isServer(player.m_9236_())) {
            Common.NETWORK.sendToClient((ServerPlayer)player, new ClientPacket(message, variable, pos, particles.ordinal()));
        }
    }

    public static Block getBlock(Level world, int x, int y, int z) {
        return Helper.getBlock(world, new BlockPos(x, y, z));
    }

    public static Block getBlock(Level world, BlockPos pos) {
        return Builder.Single.setup(world, pos).getBlock();
    }

    public static Block getRandomBlock(List<WeightedBlock> blocks) {
        Random random = new Random();
        int total = 0;
        for (WeightedBlock block : blocks) {
            total += block.getWeight();
        }
        int r = random.nextInt(total) + 1;
        int count = 0;
        for (WeightedBlock block : blocks) {
            if ((count += block.getWeight()) < r) continue;
            return block.getBlock();
        }
        return blocks.get(0).getBlock();
    }

    public static Block readBlock(String string, Block fallback) {
        return Helper.readBlockState(string, fallback.m_49966_()).m_60734_();
    }

    public static BlockState readBlockState(String string) {
        return Helper.readBlockState(string, Blocks.f_50016_.m_49966_());
    }

    public static BlockState readBlockState(String string, BlockState fallback) {
        BlockState state;
        CompoundTag tag = new CompoundTag();
        String[] split = string.split("\\[", 2);
        tag.m_128359_("Name", split[0]);
        if (split.length == 2) {
            String[] properties;
            CompoundTag propertiesTag = new CompoundTag();
            for (String property : properties = split[1].replace("]", "").split(",")) {
                String[] values = property.split("=");
                if (values.length != 2) continue;
                propertiesTag.m_128359_(values[0], values[1]);
            }
            tag.m_128365_("Properties", (Tag)propertiesTag);
        }
        if ((state = NbtUtils.m_129241_((CompoundTag)tag)).m_60734_().equals(Blocks.f_50016_)) {
            return fallback;
        }
        return state;
    }

    public static class WeightedBlock {
        private final Block block;
        private final int weight;

        public WeightedBlock(Block block, int weight) {
            this.block = block;
            this.weight = weight;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

