/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.math2d;

import kotlin.Metadata;
import org.anti_ad.mc.common.math2d.Point;
import org.anti_ad.mc.common.math2d.Size;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\"\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\t\u0010&\u001a\u00020\bH\u00c6\u0003J\t\u0010'\u001a\u00020\bH\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\t\u0010)\u001a\u00020\bH\u00c6\u0003J\u0016\u0010*\u001a\u00020+2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0011\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0003H\u0086\u0002J1\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u001a\u0010-\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005J\u0013\u0010.\u001a\u00020+2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u00020\bH\u00d6\u0001J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\bJ\u0010\u00103\u001a\u00020+2\b\u00104\u001a\u0004\u0018\u00010\u0000J\t\u00105\u001a\u000206H\u00d6\u0001R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0011\u0010\u001f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u000fR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000f\u00a8\u00067"}, d2={"Lorg/anti_ad/mc/common/math2d/Rectangle;", "", "location", "Lorg/anti_ad/mc/common/math2d/Point;", "size", "Lorg/anti_ad/mc/common/math2d/Size;", "(Lorg/anti_ad/mc/common/math2d/Point;Lorg/anti_ad/mc/common/math2d/Size;)V", "x", "", "y", "width", "height", "(IIII)V", "bottom", "getBottom", "()I", "bottomLeft", "getBottomLeft", "()Lorg/anti_ad/mc/common/math2d/Point;", "bottomRight", "getBottomRight", "getHeight", "left", "getLeft", "getLocation", "right", "getRight", "getSize", "()Lorg/anti_ad/mc/common/math2d/Size;", "top", "getTop", "topLeft", "getTopLeft", "topRight", "getTopRight", "getWidth", "getX", "getY", "component1", "component2", "component3", "component4", "contains", "", "point", "copy", "equals", "other", "hashCode", "inflated", "amount", "insideOf", "parent", "toString", "", "common"})
public final class Rectangle {
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public Rectangle(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public Rectangle(@NotNull Point point, @NotNull Size size) {
        this(point.getX(), point.getY(), size.getWidth(), size.getHeight());
    }

    public final int getLeft() {
        return this.x;
    }

    public final int getTop() {
        return this.y;
    }

    public final int getRight() {
        return this.x + this.width;
    }

    public final int getBottom() {
        return this.y + this.height;
    }

    @NotNull
    public final Point getTopLeft() {
        return new Point(this.getLeft(), this.getTop());
    }

    @NotNull
    public final Point getTopRight() {
        return new Point(this.getRight(), this.getTop());
    }

    @NotNull
    public final Point getBottomLeft() {
        return new Point(this.getLeft(), this.getBottom());
    }

    @NotNull
    public final Point getBottomRight() {
        return new Point(this.getRight(), this.getBottom());
    }

    @NotNull
    public final Point getLocation() {
        return new Point(this.x, this.y);
    }

    @NotNull
    public final Size getSize() {
        return new Size(this.width, this.height);
    }

    @NotNull
    public final Rectangle copy(@NotNull Point point, @NotNull Size size) {
        return new Rectangle(point, size);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, Point point, Size size, int n2, Object object) {
        if ((n2 & 1) != 0) {
            point = rectangle.getLocation();
        }
        if ((n2 & 2) != 0) {
            size = rectangle.getSize();
        }
        return rectangle.copy(point, size);
    }

    @NotNull
    public final Rectangle inflated(int n2) {
        return new Rectangle(this.x - n2, this.y - n2, this.width + (n2 << 1), this.height + (n2 << 1));
    }

    public final boolean contains(@NotNull Point point) {
        return this.contains(point.getX(), point.getY());
    }

    public final boolean contains(int n2, int n3) {
        int n4 = this.getLeft();
        boolean bl = n2 < this.getRight() ? n4 <= n2 : false;
        if (bl) {
            n4 = this.getTop();
            boolean bl2 = n3 < this.getBottom() ? n4 <= n3 : false;
            if (bl2) {
                return true;
            }
        }
        return false;
    }

    public final boolean insideOf(@Nullable Rectangle rectangle) {
        if (rectangle != null) {
            if (this.x < rectangle.x) {
                return false;
            }
            if (this.y < rectangle.y) {
                return false;
            }
            if (this.x + this.width > rectangle.x + rectangle.width) {
                return false;
            }
            if (this.y + this.height > rectangle.y + rectangle.height) {
                return false;
            }
        }
        return true;
    }

    public final int component1() {
        return this.x;
    }

    public final int component2() {
        return this.y;
    }

    public final int component3() {
        return this.width;
    }

    public final int component4() {
        return this.height;
    }

    @NotNull
    public final Rectangle copy(int n2, int n3, int n4, int n5) {
        return new Rectangle(n2, n3, n4, n5);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, int n2, int n3, int n4, int n5, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n2 = rectangle.x;
        }
        if ((n6 & 2) != 0) {
            n3 = rectangle.y;
        }
        if ((n6 & 4) != 0) {
            n4 = rectangle.width;
        }
        if ((n6 & 8) != 0) {
            n5 = rectangle.height;
        }
        return rectangle.copy(n2, n3, n4, n5);
    }

    @NotNull
    public final String toString() {
        return "Rectangle(x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + ')';
    }

    public final int hashCode() {
        return ((Integer.hashCode(this.x) * 31 + Integer.hashCode(this.y)) * 31 + Integer.hashCode(this.width)) * 31 + Integer.hashCode(this.height);
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        object = (Rectangle)object;
        if (this.x != ((Rectangle)object).x) {
            return false;
        }
        if (this.y != ((Rectangle)object).y) {
            return false;
        }
        if (this.width != ((Rectangle)object).width) {
            return false;
        }
        return this.height == ((Rectangle)object).height;
    }
}

