/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.item.rule.file;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.anti_ad.mc.common.Log;
import org.anti_ad.mc.ipnext.item.rule.EmptyRule;
import org.anti_ad.mc.ipnext.item.rule.Parameter;
import org.anti_ad.mc.ipnext.item.rule.Rule;
import org.anti_ad.mc.ipnext.item.rule.file.CustomRule;
import org.anti_ad.mc.ipnext.item.rule.file.RuleDefinition;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFile;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFileRegister$RuleFinder;
import org.anti_ad.mc.ipnext.item.rule.file.RuleFileRegister$searchAndPutCustomRule$1;
import org.anti_ad.mc.ipnext.item.rule.natives.NativeRules;
import org.anti_ad.mc.ipnext.item.rule.parameter.NativeParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u0005J\u0014\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0014\u0010\u001b\u001a\u00020\u00102\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/anti_ad/mc/ipnext/item/rule/file/RuleFileRegister;", "", "()V", "cachedRules", "", "", "Lorg/anti_ad/mc/ipnext/item/rule/file/RuleDefinition;", "loadedFileNames", "", "getLoadedFileNames", "()Ljava/util/Set;", "names", "ruleFiles", "", "Lorg/anti_ad/mc/ipnext/item/rule/file/RuleFile;", "checkOverrides", "", "clear", "getCustomRule", "Lorg/anti_ad/mc/ipnext/item/rule/file/CustomRule;", "ruleName", "getCustomRuleOrEmpty", "Lorg/anti_ad/mc/ipnext/item/rule/Rule;", "getNativeRule", "getParameter", "Lorg/anti_ad/mc/ipnext/item/rule/Parameter;", "parameterName", "reloadRuleFiles", "", "searchAndPutCustomRule", "validateRules", "RuleFinder", "forge-1.15"})
public final class RuleFileRegister {
    @NotNull
    public static final RuleFileRegister INSTANCE = new RuleFileRegister();
    @NotNull
    private static final Set loadedFileNames = new LinkedHashSet();
    @NotNull
    private static final List ruleFiles = new ArrayList();
    @NotNull
    private static final Map cachedRules = new LinkedHashMap();
    @NotNull
    private static final Set names = new LinkedHashSet();

    private RuleFileRegister() {
    }

    @NotNull
    public final Set getLoadedFileNames() {
        return loadedFileNames;
    }

    public final void reloadRuleFiles(@NotNull List list2) {
        Log.INSTANCE.trace("[-] Rule file parsing...");
        Log.INSTANCE.trace("    step: (1) parse indent -> (2) parse rule -> syntax ok");
        Log.INSTANCE.indent();
        Iterator iterator = ((Iterable)list2).iterator();
        while (iterator.hasNext()) {
            ((RuleFile)iterator.next()).parseContent();
        }
        Log.INSTANCE.unindent();
        this.clear();
        ruleFiles.addAll(list2);
        this.checkOverrides();
        this.validateRules();
    }

    private final void clear() {
        loadedFileNames.clear();
        ruleFiles.clear();
        cachedRules.clear();
        names.clear();
    }

    private final void checkOverrides() {
        Log.INSTANCE.trace("[-] Check overrides...");
        for (RuleFile ruleFile : ruleFiles) {
            for (String string : ruleFile.getRulesMap().keySet()) {
                if (names.contains(string)) {
                    Log.INSTANCE.info("Rule @" + string + " overrode by file " + ruleFile.getFileName());
                }
                names.add(string);
            }
        }
    }

    private final void validateRules() {
        Log.INSTANCE.trace("[-] Validate rules...");
        Log.INSTANCE.indent();
        for (String string : names) {
            Log.INSTANCE.trace("[-] Validating rule @".concat(String.valueOf(string)));
            Log.INSTANCE.indent();
            if (this.getCustomRule(string) == null) {
                Log.INSTANCE.debug("rule @" + string + " failed to parse");
            }
            Log.INSTANCE.unindent();
        }
        Log.INSTANCE.unindent();
    }

    @NotNull
    public final Rule getCustomRuleOrEmpty(@NotNull String string) {
        CustomRule customRule = this.getCustomRule(string);
        if (customRule != null) {
            return customRule;
        }
        EmptyRule emptyRule = EmptyRule.INSTANCE;
        Log.INSTANCE.warn("Rule @" + string + " not found");
        return emptyRule;
    }

    @Nullable
    public final CustomRule getCustomRule(@NotNull String string) {
        RuleDefinition ruleDefinition = cachedRules.containsKey(string) ? (RuleDefinition)MapsKt.getValue((Map)cachedRules, (Object)string) : this.searchAndPutCustomRule(string);
        if (ruleDefinition != null) {
            return ruleDefinition.createCustomRule();
        }
        return null;
    }

    @Nullable
    public final Rule getNativeRule(@NotNull String string) {
        Function0 function0 = (Function0)NativeRules.INSTANCE.getMap().get(string);
        if (function0 != null) {
            return (Rule)function0.invoke();
        }
        return null;
    }

    @Nullable
    public final Parameter getParameter(@NotNull String string) {
        return (Parameter)NativeParameters.INSTANCE.getMap().get(string);
    }

    private final RuleDefinition searchAndPutCustomRule(String string) {
        Log.INSTANCE.trace("[-] Searching rule @" + string + "...");
        Log.INSTANCE.indent();
        RuleDefinition ruleDefinition = new RuleFileRegister$RuleFinder(string).searchCustomRule();
        Log.INSTANCE.unindent();
        if (cachedRules.containsKey(string)) {
            Log.INSTANCE.trace(">> rule " + string + " already exist in cached map... skip putting");
        } else {
            cachedRules.put(string, ruleDefinition);
        }
        CollectionsKt.removeAll((List)ruleFiles, (Function1)RuleFileRegister$searchAndPutCustomRule$1.INSTANCE);
        return ruleDefinition;
    }

    public static final /* synthetic */ List access$getRuleFiles$p() {
        return ruleFiles;
    }
}

