/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.forge;

import com.mojang.blaze3d.platform.InputConstants;
import kotlin.Unit;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.anti_ad.mc.common.vanilla.Vanilla;
import org.anti_ad.mc.common.vanilla.glue.IVanillaUtilKt;
import org.anti_ad.mc.ipnext.config.Tweaks;
import org.anti_ad.mc.ipnext.event.ClientEventHandler;
import org.anti_ad.mc.ipnext.event.LockSlotsHandler;
import org.anti_ad.mc.ipnext.gui.inject.ContainerScreenEventHandler;
import org.anti_ad.mc.ipnext.gui.inject.ScreenEventHandler;
import org.anti_ad.mc.ipnext.inventory.GeneralInventoryActions;

public class ForgeEventHandler {
    @SubscribeEvent
    public void clientClick(TickEvent.ClientTickEvent clientTickEvent) {
        if (clientTickEvent.phase == TickEvent.Phase.START) {
            ClientEventHandler.INSTANCE.onTickPre();
            return;
        }
        ClientEventHandler.INSTANCE.onTick();
    }

    @SubscribeEvent
    public void joinWorld(WorldEvent.Load load) {
        if (IVanillaUtilKt.getVanillaUtil().isOnClientThread()) {
            ClientEventHandler.INSTANCE.onJoinWorld();
        }
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent itemCraftedEvent) {
        ClientEventHandler.INSTANCE.onCrafted();
    }

    @SubscribeEvent
    public void onInitGuiPost(GuiScreenEvent.InitGuiEvent.Post post) {
        ScreenEventHandler.INSTANCE.onScreenInit(post.getGui(), abstractButton -> {
            post.addWidget((GuiEventListener)abstractButton);
            return Unit.INSTANCE;
        });
    }

    @SubscribeEvent
    public void preScreenRender(GuiScreenEvent.DrawScreenEvent.Pre pre) {
        ScreenEventHandler.INSTANCE.preRender();
    }

    @SubscribeEvent
    public void postScreenRender(GuiScreenEvent.DrawScreenEvent.Post post) {
        ScreenEventHandler.INSTANCE.postRender();
    }

    @SubscribeEvent
    public void onBackgroundRender(GuiContainerEvent.DrawBackground drawBackground) {
        ContainerScreenEventHandler.INSTANCE.onBackgroundRender(drawBackground.getMatrixStack(), drawBackground.getMouseX(), drawBackground.getMouseY());
    }

    @SubscribeEvent
    public void onForegroundRender(GuiContainerEvent.DrawForeground drawForeground) {
        ContainerScreenEventHandler.INSTANCE.onForegroundRender(drawForeground.getMatrixStack(), drawForeground.getMouseX(), drawForeground.getMouseY());
    }

    @SubscribeEvent
    public void onGuiKeyPressedPre(GuiScreenEvent.KeyboardKeyPressedEvent.Pre pre) {
        if (!IVanillaUtilKt.getVanillaUtil().inGame()) {
            return;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)pre.getKeyCode(), (int)pre.getScanCode());
        if (Tweaks.INSTANCE.getPREVENT_CLOSE_GUI_DROP_ITEM().getBooleanValue() && (pre.getKeyCode() == 256 || Vanilla.INSTANCE.mc().f_91066_.f_92092_.isActiveAndMatches(key))) {
            GeneralInventoryActions.INSTANCE.handleCloseContainer();
        }
    }

    public void onOverlayLayerPre(RenderGameOverlayEvent.PreLayer preLayer) {
        if (preLayer.getOverlay() == ForgeIngameGui.HOTBAR_ELEMENT) {
            LockSlotsHandler.INSTANCE.preRenderHud();
        }
    }

    @SubscribeEvent
    public void onOverlayLayerPost(RenderGameOverlayEvent.PostLayer postLayer) {
        if (postLayer.getOverlay() == ForgeIngameGui.HOTBAR_ELEMENT) {
            LockSlotsHandler.INSTANCE.postRenderHud();
        }
    }
}

