/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.inventory.sandbox;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.anti_ad.mc.common.annotation.MayThrow;
import org.anti_ad.mc.ipnext.inventory.data.ExtensionsKt;
import org.anti_ad.mc.ipnext.inventory.data.ItemTracker;
import org.anti_ad.mc.ipnext.inventory.data.MutableItemTracker;
import org.anti_ad.mc.ipnext.inventory.sandbox.ContainerSandbox;
import org.anti_ad.mc.ipnext.inventory.sandbox.ContainerSandboxKt;
import org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator.DiffCalculator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0003J\u001c\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0015H\u0007J\u001c\u0010\u0016\u001a\u00020\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u0015H\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068G\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/anti_ad/mc/ipnext/inventory/sandbox/ItemPlanner;", "", "items", "Lorg/anti_ad/mc/ipnext/inventory/data/MutableItemTracker;", "(Lorg/anti_ad/mc/ipnext/inventory/data/MutableItemTracker;)V", "clicks", "", "Lorg/anti_ad/mc/ipnext/inventory/sandbox/SandboxClick;", "getClicks", "()Ljava/util/List;", "innerSandbox", "Lorg/anti_ad/mc/ipnext/inventory/sandbox/ContainerSandbox;", "itemTracker", "Lorg/anti_ad/mc/ipnext/inventory/data/ItemTracker;", "getItemTracker", "()Lorg/anti_ad/mc/ipnext/inventory/data/ItemTracker;", "trackingItems", "innerSync", "", "sandbox", "action", "Lkotlin/Function1;", "tracker", "forge-1.18"})
public final class ItemPlanner {
    @NotNull
    private final ContainerSandbox innerSandbox;
    @Nullable
    private ItemTracker trackingItems;

    public ItemPlanner(@NotNull MutableItemTracker mutableItemTracker) {
        this.innerSandbox = new ContainerSandbox(mutableItemTracker, null, 2, null);
    }

    @MayThrow
    private final void innerSync() {
        ItemTracker itemTracker = this.trackingItems;
        if (itemTracker != null) {
            ItemTracker itemTracker2 = itemTracker;
            DiffCalculator.INSTANCE.apply(this.innerSandbox, itemTracker2);
            if (!Intrinsics.areEqual((Object)this.innerSandbox.getItems(), (Object)itemTracker2)) {
                throw new IllegalStateException("ContainerSandbox actual result not same as goal".toString());
            }
            this.trackingItems = null;
            return;
        }
    }

    private final ItemTracker getItemTracker() {
        ItemTracker itemTracker = this.trackingItems;
        if (itemTracker == null) {
            itemTracker = this.innerSandbox.getItems();
        }
        return itemTracker;
    }

    @MayThrow
    public final void sandbox(@NotNull Function1 function1) {
        this.innerSync();
        function1.invoke((Object)this.innerSandbox);
    }

    @MayThrow
    public final void tracker(@NotNull Function1 object) {
        int n2 = this.innerSandbox.getClickCount();
        ItemTracker itemTracker = this.getItemTracker();
        MutableItemTracker mutableItemTracker = this.getItemTracker().copyAsMutable();
        object.invoke((Object)mutableItemTracker);
        object = mutableItemTracker;
        if (n2 != this.innerSandbox.getClickCount()) {
            throw new IllegalStateException(("ContainerSandbox out of sync expected " + n2 + " current " + this.innerSandbox.getClickCount()).toString());
        }
        if (!Intrinsics.areEqual((Object)ExtensionsKt.collect(itemTracker), (Object)ExtensionsKt.collect((ItemTracker)object))) {
            throw new IllegalStateException("Unequal before and after item counts".toString());
        }
        this.trackingItems = (ItemTracker)object;
    }

    @MayThrow
    @NotNull
    public final List getClicks() {
        this.innerSync();
        return ContainerSandboxKt.toList(this.innerSandbox.getClickNode());
    }
}

