/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.config.builder;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JvmStreamsKt;
import org.anti_ad.mc.common.Log;
import org.anti_ad.mc.common.Savable;
import org.anti_ad.mc.common.config.IConfigElement;
import org.anti_ad.mc.common.config.builder.ConfigSaveLoadManager$encoder$1;
import org.anti_ad.mc.common.extensions.Java_ioKt;
import org.anti_ad.mc.common.extensions.JsonKt;
import org.anti_ad.mc.common.vanilla.glue.IVanillaUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/anti_ad/mc/common/config/builder/ConfigSaveLoadManager;", "Lorg/anti_ad/mc/common/Savable;", "config", "Lorg/anti_ad/mc/common/config/IConfigElement;", "path", "", "(Lorg/anti_ad/mc/common/config/IConfigElement;Ljava/lang/String;)V", "configFile", "Ljava/nio/file/Path;", "encoder", "Lkotlinx/serialization/json/Json;", "getEncoder$annotations", "()V", "load", "", "save", "common"})
public final class ConfigSaveLoadManager
implements Savable {
    @NotNull
    private final IConfigElement config;
    @NotNull
    private final Path configFile;
    @NotNull
    private final String path;
    @NotNull
    private final Json encoder;

    public ConfigSaveLoadManager(@NotNull IConfigElement iConfigElement, @NotNull String string) {
        this.config = iConfigElement;
        this.configFile = Java_ioKt.div(IVanillaUtilKt.getVanillaUtil().configDirectory(), string);
        this.path = IVanillaUtilKt.getLoggingPath(this.configFile);
        this.encoder = kotlinx.serialization.json.JsonKt.Json$default(null, (Function1)ConfigSaveLoadManager$encoder$1.INSTANCE, (int)1, null);
    }

    private static /* synthetic */ void getEncoder$annotations() {
    }

    @Override
    public final void save() {
        try {
            JsonElement jsonElement = this.config.toJsonElement();
            JvmStreamsKt.encodeToStream((Json)this.encoder, (SerializationStrategy)((SerializationStrategy)JsonElement.Companion.serializer()), (Object)jsonElement, (OutputStream)Files.newOutputStream(this.configFile, Arrays.copyOf(new OpenOption[0], 0)));
            return;
        }
        catch (IOException iOException) {
            Log.INSTANCE.error("Failed to write config file " + this.path);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public final void load() {
        try {
            JsonElement jsonElement;
            if (!Java_ioKt.exists(this.configFile)) {
                return;
            }
            boolean bl = false;
            JsonElement jsonElement2 = JsonKt.toJsonElement(PathsKt.readText$default((Path)this.configFile, null, (int)1, null));
            JsonObject jsonObject = JsonElementKt.getJsonObject((JsonElement)jsonElement2);
            if ((jsonObject.get((Object)"LockedSlotsSettings") == null || jsonObject.get((Object)"AutoRefillSettings") == null) && (jsonElement = (JsonElement)jsonObject.get((Object)"ModSettings")) != null) {
                Map map = MapsKt.toMutableMap((Map)((Map)jsonObject));
                if (jsonObject.get((Object)"LockedSlotsSettings") == null) {
                    bl = true;
                    map.put("LockedSlotsSettings", jsonElement);
                }
                if (jsonObject.get((Object)"AutoRefillSettings") == null) {
                    bl = true;
                    map.put("AutoRefillSettings", jsonElement);
                }
                if (bl) {
                    jsonElement2 = (JsonElement)new JsonObject(map);
                }
            }
            this.config.fromJsonElement(jsonElement2);
            if (bl) {
                this.save();
                return;
            }
        }
        catch (IOException iOException) {
            Log.INSTANCE.error("Failed to read config file " + this.path);
            return;
        }
        catch (SerializationException serializationException) {
            Log.INSTANCE.error("Failed to parse config file " + this.path + " as JSON");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

