/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.anti_ad.mc.ipnext.inventory.data.ExtensionsKt;
import org.anti_ad.mc.ipnext.inventory.data.ItemTracker;
import org.anti_ad.mc.ipnext.inventory.sandbox.ContainerSandbox;
import org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator.DiffCalculatorInstance$CompareSlotDsl;
import org.anti_ad.mc.ipnext.inventory.sandbox.diffcalculator.DiffCalculatorInstance$filtered$1;
import org.anti_ad.mc.ipnext.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u001bR\u00020\u00000\u001a2\u001d\b\u0002\u0010\u001c\u001a\u0017\u0012\b\u0012\u00060\u001bR\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000J\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020!H&R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"Lorg/anti_ad/mc/ipnext/inventory/sandbox/diffcalculator/DiffCalculatorInstance;", "", "sandbox", "Lorg/anti_ad/mc/ipnext/inventory/sandbox/ContainerSandbox;", "goalTracker", "Lorg/anti_ad/mc/ipnext/inventory/data/ItemTracker;", "(Lorg/anti_ad/mc/ipnext/inventory/sandbox/ContainerSandbox;Lorg/anti_ad/mc/ipnext/inventory/data/ItemTracker;)V", "cursorGoal", "Lorg/anti_ad/mc/ipnext/item/ItemStack;", "getCursorGoal", "()Lorg/anti_ad/mc/ipnext/item/ItemStack;", "cursorNow", "getCursorNow", "getGoalTracker", "()Lorg/anti_ad/mc/ipnext/inventory/data/ItemTracker;", "indices", "Lkotlin/ranges/IntRange;", "getIndices", "()Lkotlin/ranges/IntRange;", "loopCounter", "", "nowTracker", "getNowTracker", "getSandbox", "()Lorg/anti_ad/mc/ipnext/inventory/sandbox/ContainerSandbox;", "filtered", "", "Lorg/anti_ad/mc/ipnext/inventory/sandbox/diffcalculator/DiffCalculatorInstance$CompareSlotDsl;", "predicate", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "increaseLoopCount", "", "run", "CompareSlotDsl", "forge-1.19"})
public abstract class DiffCalculatorInstance {
    @NotNull
    private final ContainerSandbox sandbox;
    @NotNull
    private final ItemTracker goalTracker;
    private int loopCounter;

    public DiffCalculatorInstance(@NotNull ContainerSandbox containerSandbox, @NotNull ItemTracker itemTracker) {
        this.sandbox = containerSandbox;
        this.goalTracker = itemTracker;
        if (this.getNowTracker().getSlots().size() != this.goalTracker.getSlots().size()) {
            throw new IllegalStateException("Unequal sandbox and goal slot size".toString());
        }
        if (!Intrinsics.areEqual((Object)ExtensionsKt.collect(this.getNowTracker()), (Object)ExtensionsKt.collect(this.goalTracker))) {
            throw new IllegalStateException("Unequal sandbox and goal item counts".toString());
        }
        if (!this.goalTracker.getThrownItems().containsAll(this.getNowTracker().getThrownItems())) {
            throw new IllegalStateException("Impossible. Thrown items cannot be reverted".toString());
        }
    }

    @NotNull
    public final ContainerSandbox getSandbox() {
        return this.sandbox;
    }

    @NotNull
    public final ItemTracker getGoalTracker() {
        return this.goalTracker;
    }

    @NotNull
    public final ItemTracker getNowTracker() {
        return this.sandbox.getItems();
    }

    @NotNull
    public final ItemStack getCursorNow() {
        return this.getNowTracker().getCursor();
    }

    @NotNull
    public final ItemStack getCursorGoal() {
        return this.goalTracker.getCursor();
    }

    public abstract void run();

    public final void increaseLoopCount() {
        ++this.loopCounter;
        int n2 = Math.max(this.loopCounter, this.sandbox.getClickCount());
        if (n2 > 100000) {
            throw new IllegalStateException(("Infinity loop detected. " + n2 + " > 100000").toString());
        }
    }

    @NotNull
    public final IntRange getIndices() {
        return CollectionsKt.getIndices((Collection)this.getNowTracker().getSlots());
    }

    @NotNull
    public final List filtered(@NotNull Function1 function1) {
        Object object = (Iterable)this.getIndices();
        Collection collection = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            int n2 = ((IntIterator)object).nextInt();
            DiffCalculatorInstance$CompareSlotDsl diffCalculatorInstance$CompareSlotDsl = new DiffCalculatorInstance$CompareSlotDsl(this, n2);
            DiffCalculatorInstance$CompareSlotDsl diffCalculatorInstance$CompareSlotDsl2 = (Boolean)function1.invoke((Object)diffCalculatorInstance$CompareSlotDsl) != false ? diffCalculatorInstance$CompareSlotDsl : null;
            if (diffCalculatorInstance$CompareSlotDsl2 == null) continue;
            diffCalculatorInstance$CompareSlotDsl = diffCalculatorInstance$CompareSlotDsl2;
            collection.add(diffCalculatorInstance$CompareSlotDsl);
        }
        return (List)collection;
    }

    public static /* synthetic */ List filtered$default(DiffCalculatorInstance diffCalculatorInstance, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filtered");
        }
        if ((n2 & 1) != 0) {
            function1 = DiffCalculatorInstance$filtered$1.INSTANCE;
        }
        Object object2 = (Iterable)diffCalculatorInstance.getIndices();
        object = new ArrayList();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            int n3 = ((IntIterator)object2).nextInt();
            DiffCalculatorInstance$CompareSlotDsl diffCalculatorInstance$CompareSlotDsl = new DiffCalculatorInstance$CompareSlotDsl(diffCalculatorInstance, n3);
            DiffCalculatorInstance$CompareSlotDsl diffCalculatorInstance$CompareSlotDsl2 = (Boolean)function1.invoke((Object)diffCalculatorInstance$CompareSlotDsl) != false ? diffCalculatorInstance$CompareSlotDsl : null;
            if (diffCalculatorInstance$CompareSlotDsl2 == null) continue;
            diffCalculatorInstance$CompareSlotDsl = diffCalculatorInstance$CompareSlotDsl2;
            object.add(diffCalculatorInstance$CompareSlotDsl);
        }
        return (List)object;
    }
}

