/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.nock_enough_arrows.quiver;

import com.itayfeder.nock_enough_arrows.init.EnchantmentInit;
import com.itayfeder.nock_enough_arrows.quiver.QuiverCapabilityProvider;
import com.itayfeder.nock_enough_arrows.quiver.QuiverItemStackHandler;
import com.itayfeder.nock_enough_arrows.quiver.tooltip.QuiverTooltip;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class QuiverItem
extends Item
implements DyeableLeatherItem {
    private static final String TAG_ITEMS = "Items";
    public static final int MAX_WEIGHT = 64;
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);
    public static final String SELECTED_ID = "Selected";

    public QuiverItem(Item.Properties p_150726_) {
        super(p_150726_);
    }

    public boolean m_142207_(ItemStack p_150733_, Slot p_150734_, ClickAction p_150735_, Player p_150736_) {
        if (p_150735_ != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = p_150734_.m_7993_();
        if (itemstack.m_41619_()) {
            this.playRemoveOneSound((Entity)p_150736_);
            QuiverItem.removeOne(p_150733_).ifPresent(stack -> p_150734_.m_5852_(stack));
        } else if (itemstack.m_41720_().m_142095_() && itemstack.m_204117_(ItemTags.f_13161_)) {
            QuiverItemStackHandler handler = QuiverItem.getQuiverItemStackHandler(p_150733_);
            itemstack.m_41764_(handler.addStack(itemstack).m_41613_());
        }
        return true;
    }

    public boolean m_142305_(ItemStack p_150742_, ItemStack p_150743_, Slot p_150744_, ClickAction p_150745_, Player p_150746_, SlotAccess p_150747_) {
        if (p_150745_ == ClickAction.SECONDARY && p_150744_.m_150651_(p_150746_)) {
            QuiverItemStackHandler handler;
            ItemStack addedStack;
            if (p_150743_.m_41619_()) {
                QuiverItem.removeOne(p_150742_).ifPresent(p_186347_ -> {
                    this.playRemoveOneSound((Entity)p_150746_);
                    p_150747_.m_142104_(p_186347_);
                });
            } else if (p_150743_.m_204117_(ItemTags.f_13161_) && (addedStack = (handler = QuiverItem.getQuiverItemStackHandler(p_150742_)).addStack(p_150743_)) != p_150743_) {
                this.playInsertSound((Entity)p_150746_);
                p_150743_.m_41764_(addedStack.m_41613_());
            }
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_150760_, Player p_150761_, InteractionHand p_150762_) {
        ItemStack itemstack = p_150761_.m_21120_(p_150762_);
        if (QuiverItem.dropContents(itemstack, p_150761_)) {
            this.playDropContentsSound((Entity)p_150761_);
            p_150761_.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)p_150760_.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean m_142522_(ItemStack p_150769_) {
        return QuiverItem.getContentWeight(p_150769_) > 0;
    }

    public int m_142158_(ItemStack p_150771_) {
        QuiverItemStackHandler handler = QuiverItem.getQuiverItemStackHandler(p_150771_);
        return Math.min(1 + 12 * QuiverItem.getContentWeight(p_150771_) / handler.getSlots(), 13);
    }

    public int m_142159_(ItemStack p_150773_) {
        return BAR_COLOR;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new QuiverCapabilityProvider();
    }

    public static QuiverItemStackHandler getQuiverItemStackHandler(ItemStack stack) {
        IItemHandler quiver = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)null);
        if (quiver != null && quiver instanceof QuiverItemStackHandler) {
            return (QuiverItemStackHandler)quiver;
        }
        return new QuiverItemStackHandler();
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag baseTag = stack.m_41783_();
        QuiverItemStackHandler quiverItemStackHandler = QuiverItem.getQuiverItemStackHandler(stack);
        CompoundTag capTag = quiverItemStackHandler.serializeNBT();
        CompoundTag combinedTag = new CompoundTag();
        if (baseTag != null) {
            combinedTag.m_128365_("base", (Tag)baseTag);
        }
        if (capTag != null) {
            combinedTag.m_128365_("cap", (Tag)capTag);
        }
        return combinedTag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt == null) {
            stack.m_41751_((CompoundTag)null);
        } else {
            CompoundTag baseTag = nbt.m_128469_("base");
            stack.m_41751_(baseTag);
            CompoundTag capTag = nbt.m_128469_("cap");
            QuiverItemStackHandler quiverItemStackHandler = QuiverItem.getQuiverItemStackHandler(stack);
            quiverItemStackHandler.deserializeNBT(capTag);
        }
    }

    public static float getFullnessDisplay(ItemStack p_150767_) {
        QuiverItemStackHandler handler = QuiverItem.getQuiverItemStackHandler(p_150767_);
        return (float)QuiverItem.getContentWeight(p_150767_) / (float)handler.getSlots();
    }

    private static int getContentWeight(ItemStack p_150779_) {
        return QuiverItem.getContents(p_150779_).toList().size();
    }

    private static Optional<ItemStack> removeOne(ItemStack p_150781_) {
        QuiverItemStackHandler handler = QuiverItem.getQuiverItemStackHandler(p_150781_);
        if (!handler.isAllAir()) {
            int selected = QuiverItem.getSelected(p_150781_);
            ItemStack firstStack = handler.getStackInSlot(selected);
            handler.extractItem(selected, firstStack.m_41613_(), false);
            return Optional.of(firstStack);
        }
        return Optional.empty();
    }

    private static boolean dropContents(ItemStack p_150730_, Player p_150731_) {
        QuiverItemStackHandler handler = QuiverItem.getQuiverItemStackHandler(p_150730_);
        if (handler.isEmpty()) {
            return false;
        }
        if (p_150731_ instanceof ServerPlayer) {
            List<ItemStack> listtag = handler.getItems();
            for (int i = 0; i < listtag.size(); ++i) {
                ItemStack itemstack = listtag.get(i);
                p_150731_.m_36176_(itemstack, true);
                handler.extractItem(i, itemstack.m_41613_(), false);
            }
        }
        return true;
    }

    private static Stream<ItemStack> getContents(ItemStack p_150783_) {
        QuiverItemStackHandler handler = QuiverItem.getQuiverItemStackHandler(p_150783_);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i) == ItemStack.f_41583_) continue;
            items.add(handler.getStackInSlot(i));
        }
        return items.stream();
    }

    public Optional<TooltipComponent> m_142422_(ItemStack p_150775_) {
        NonNullList nonnulllist = NonNullList.m_122779_();
        QuiverItem.getContents(p_150775_).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new QuiverTooltip((NonNullList<ItemStack>)nonnulllist, QuiverItem.getContentWeight(p_150775_), p_150775_));
    }

    public void m_7373_(ItemStack p_150749_, Level p_150750_, List<Component> p_150751_, TooltipFlag p_150752_) {
        QuiverItemStackHandler handler = QuiverItem.getQuiverItemStackHandler(p_150749_);
        p_150751_.add((Component)Component.m_237110_((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{QuiverItem.getContentWeight(p_150749_), handler.getSlots()}).m_130940_(ChatFormatting.GRAY));
        if (!handler.isAllAir()) {
            p_150751_.add((Component)Component.m_237113_((String)("Selected Arrow: " + I18n.m_118938_((String)handler.getItems().get(QuiverItem.getSelected(p_150749_)).m_41778_(), (Object[])new Object[0]))).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void m_142023_(ItemEntity p_150728_) {
        ItemUtils.m_150952_((ItemEntity)p_150728_, QuiverItem.getContents(p_150728_.m_32055_()));
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + p_186343_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity p_186352_) {
        p_186352_.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + p_186352_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity p_186354_) {
        p_186354_.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + p_186354_.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        block4: {
            int level;
            QuiverItemStackHandler handler;
            block5: {
                super.m_6883_(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
                handler = QuiverItem.getQuiverItemStackHandler(p_41404_);
                if (!handler.isAllAir() && handler.isAir(QuiverItem.getSelected(p_41404_))) {
                    QuiverItem.setSelected(p_41404_, handler.getFirstFilledSlot());
                }
                if (p_41404_.getEnchantmentLevel((Enchantment)EnchantmentInit.STOCKPILE.get()) < 1) break block4;
                level = p_41404_.getEnchantmentLevel((Enchantment)EnchantmentInit.STOCKPILE.get());
                if (handler.getSlots() == 5 + level) break block4;
                if (handler.getSlots() <= 5 + level) break block5;
                List<ItemStack> stacks = handler.getItems();
                handler.setSize(5 + level);
                int i = 0;
                for (i = 0; i < 5 + level; ++i) {
                    handler.addStack(stacks.get(i));
                }
                if (!(p_41406_ instanceof Player)) break block4;
                Player player = (Player)p_41406_;
                for (int j = i; j < stacks.size(); ++j) {
                    ItemStack itemstack = stacks.get(j);
                    player.m_36176_(itemstack, true);
                }
                break block4;
            }
            List<ItemStack> stacks = handler.getItems();
            handler.setSize(5 + level);
            for (ItemStack stack : stacks) {
                handler.addStack(stack);
            }
        }
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }

    public int m_6473_() {
        return 5;
    }

    public static int getSelected(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128451_(SELECTED_ID);
    }

    public static void setSelected(ItemStack stack, int id) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(SELECTED_ID, id);
    }
}

