/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.nock_enough_arrows.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class PublicVillagerTrades {

    public static class TreasureMapForEmeralds
    implements VillagerTrades.ItemListing {
        private final int emeraldCost;
        private final TagKey<Structure> destination;
        private final String displayName;
        private final MapDecoration.Type destinationType;
        private final int maxUses;
        private final int villagerXp;

        public TreasureMapForEmeralds(int p_207767_, TagKey<Structure> p_207768_, String p_207769_, MapDecoration.Type p_207770_, int p_207771_, int p_207772_) {
            this.emeraldCost = p_207767_;
            this.destination = p_207768_;
            this.displayName = p_207769_;
            this.destinationType = p_207770_;
            this.maxUses = p_207771_;
            this.villagerXp = p_207772_;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity p_219708_, RandomSource p_219709_) {
            if (!(p_219708_.f_19853_ instanceof ServerLevel)) {
                return null;
            }
            ServerLevel serverlevel = (ServerLevel)p_219708_.f_19853_;
            BlockPos blockpos = serverlevel.m_215011_(this.destination, p_219708_.m_20183_(), 100, true);
            if (blockpos != null) {
                ItemStack itemstack = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)itemstack);
                MapItemSavedData.m_77925_((ItemStack)itemstack, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.destinationType);
                itemstack.m_41714_((Component)Component.m_237115_((String)this.displayName));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)Items.f_42522_), itemstack, this.maxUses, this.villagerXp, 0.2f);
            }
            return null;
        }
    }

    public static class TippedArrowForItemsAndEmeralds
    implements VillagerTrades.ItemListing {
        private final ItemStack toItem;
        private final int toCount;
        private final int emeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final Item fromItem;
        private final int fromCount;
        private final float priceMultiplier;

        public TippedArrowForItemsAndEmeralds(Item p_35793_, int p_35794_, Item p_35795_, int p_35796_, int p_35797_, int p_35798_, int p_35799_) {
            this.toItem = new ItemStack((ItemLike)p_35795_);
            this.emeraldCost = p_35797_;
            this.maxUses = p_35798_;
            this.villagerXp = p_35799_;
            this.fromItem = p_35793_;
            this.fromCount = p_35794_;
            this.toCount = p_35796_;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity p_219705_, RandomSource p_219706_) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost);
            List list = Registry.f_122828_.m_123024_().filter(p_35804_ -> !p_35804_.m_43488_().isEmpty() && PotionBrewing.m_43511_((Potion)p_35804_)).collect(Collectors.toList());
            Potion potion = (Potion)list.get(p_219706_.m_188503_(list.size()));
            ItemStack itemstack1 = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)this.toItem.m_41720_(), this.toCount), (Potion)potion);
            return new MerchantOffer(itemstack, new ItemStack((ItemLike)this.fromItem, this.fromCount), itemstack1, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class SuspiciousStewForEmerald
    implements VillagerTrades.ItemListing {
        final MobEffect effect;
        final int duration;
        final int xp;
        private final float priceMultiplier;

        public SuspiciousStewForEmerald(MobEffect p_186313_, int p_186314_, int p_186315_) {
            this.effect = p_186313_;
            this.duration = p_186314_;
            this.xp = p_186315_;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity p_219702_, RandomSource p_219703_) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42718_, 1);
            SuspiciousStewItem.m_43258_((ItemStack)itemstack, (MobEffect)this.effect, (int)this.duration);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), itemstack, 12, this.xp, this.priceMultiplier);
        }
    }

    public static class ItemsForEmeralds
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final int emeraldCost;
        private final int numberOfItems;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsForEmeralds(Block p_35765_, int p_35766_, int p_35767_, int p_35768_, int p_35769_) {
            this(new ItemStack((ItemLike)p_35765_), p_35766_, p_35767_, p_35768_, p_35769_);
        }

        public ItemsForEmeralds(Item p_35741_, int p_35742_, int p_35743_, int p_35744_) {
            this(new ItemStack((ItemLike)p_35741_), p_35742_, p_35743_, 12, p_35744_);
        }

        public ItemsForEmeralds(Item p_35746_, int p_35747_, int p_35748_, int p_35749_, int p_35750_) {
            this(new ItemStack((ItemLike)p_35746_), p_35747_, p_35748_, p_35749_, p_35750_);
        }

        public ItemsForEmeralds(ItemStack p_35752_, int p_35753_, int p_35754_, int p_35755_, int p_35756_) {
            this(p_35752_, p_35753_, p_35754_, p_35755_, p_35756_, 0.05f);
        }

        public ItemsForEmeralds(ItemStack p_35758_, int p_35759_, int p_35760_, int p_35761_, int p_35762_, float p_35763_) {
            this.itemStack = p_35758_;
            this.emeraldCost = p_35759_;
            this.numberOfItems = p_35760_;
            this.maxUses = p_35761_;
            this.villagerXp = p_35762_;
            this.priceMultiplier = p_35763_;
        }

        public MerchantOffer m_213663_(Entity p_219699_, RandomSource p_219700_) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)this.itemStack.m_41720_(), this.numberOfItems), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class ItemsAndEmeraldsToItems
    implements VillagerTrades.ItemListing {
        private final ItemStack fromItem;
        private final int fromCount;
        private final int emeraldCost;
        private final ItemStack toItem;
        private final int toCount;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public ItemsAndEmeraldsToItems(ItemLike p_35725_, int p_35726_, Item p_35727_, int p_35728_, int p_35729_, int p_35730_) {
            this(p_35725_, p_35726_, 1, p_35727_, p_35728_, p_35729_, p_35730_);
        }

        public ItemsAndEmeraldsToItems(ItemLike p_35717_, int p_35718_, int p_35719_, Item p_35720_, int p_35721_, int p_35722_, int p_35723_) {
            this.fromItem = new ItemStack(p_35717_);
            this.fromCount = p_35718_;
            this.emeraldCost = p_35719_;
            this.toItem = new ItemStack((ItemLike)p_35720_);
            this.toCount = p_35721_;
            this.maxUses = p_35722_;
            this.villagerXp = p_35723_;
            this.priceMultiplier = 0.05f;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity p_219696_, RandomSource p_219697_) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, this.emeraldCost), new ItemStack((ItemLike)this.fromItem.m_41720_(), this.fromCount), new ItemStack((ItemLike)this.toItem.m_41720_(), this.toCount), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class EnchantedItemForEmeralds
    implements VillagerTrades.ItemListing {
        private final ItemStack itemStack;
        private final int baseEmeraldCost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EnchantedItemForEmeralds(Item p_35693_, int p_35694_, int p_35695_, int p_35696_) {
            this(p_35693_, p_35694_, p_35695_, p_35696_, 0.05f);
        }

        public EnchantedItemForEmeralds(Item p_35698_, int p_35699_, int p_35700_, int p_35701_, float p_35702_) {
            this.itemStack = new ItemStack((ItemLike)p_35698_);
            this.baseEmeraldCost = p_35699_;
            this.maxUses = p_35700_;
            this.villagerXp = p_35701_;
            this.priceMultiplier = p_35702_;
        }

        public MerchantOffer m_213663_(Entity p_219691_, RandomSource p_219692_) {
            int i = 5 + p_219692_.m_188503_(15);
            ItemStack itemstack = EnchantmentHelper.m_220292_((RandomSource)p_219692_, (ItemStack)new ItemStack((ItemLike)this.itemStack.m_41720_()), (int)i, (boolean)false);
            int j = Math.min(this.baseEmeraldCost + i, 64);
            ItemStack itemstack1 = new ItemStack((ItemLike)Items.f_42616_, j);
            return new MerchantOffer(itemstack1, itemstack, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class EnchantBookForEmeralds
    implements VillagerTrades.ItemListing {
        private final int villagerXp;

        public EnchantBookForEmeralds(int p_35683_) {
            this.villagerXp = p_35683_;
        }

        public MerchantOffer m_213663_(Entity p_219688_, RandomSource p_219689_) {
            List list = Registry.f_122825_.m_123024_().filter(Enchantment::m_6594_).collect(Collectors.toList());
            Enchantment enchantment = (Enchantment)list.get(p_219689_.m_188503_(list.size()));
            int i = Mth.m_216271_((RandomSource)p_219689_, (int)enchantment.m_44702_(), (int)enchantment.m_6586_());
            ItemStack itemstack = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, i));
            int j = 2 + p_219689_.m_188503_(5 + i * 10) + 3 * i;
            if (enchantment.m_6591_()) {
                j *= 2;
            }
            if (j > 64) {
                j = 64;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, j), new ItemStack((ItemLike)Items.f_42517_), itemstack, 12, this.villagerXp, 0.2f);
        }
    }

    public static class EmeraldsForVillagerTypeItem
    implements VillagerTrades.ItemListing {
        private final Map<VillagerType, Item> trades;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;

        public EmeraldsForVillagerTypeItem(int p_35669_, int p_35670_, int p_35671_, Map<VillagerType, Item> p_35672_) {
            Registry.f_122868_.m_123024_().filter(p_35680_ -> !p_35672_.containsKey(p_35680_)).findAny().ifPresent(p_35677_ -> {
                throw new IllegalStateException("Missing trade for villager type: " + Registry.f_122868_.m_7981_(p_35677_));
            });
            this.trades = p_35672_;
            this.cost = p_35669_;
            this.maxUses = p_35670_;
            this.villagerXp = p_35671_;
        }

        @Nullable
        public MerchantOffer m_213663_(Entity p_219685_, RandomSource p_219686_) {
            if (p_219685_ instanceof VillagerDataHolder) {
                ItemStack itemstack = new ItemStack((ItemLike)this.trades.get(((VillagerDataHolder)p_219685_).m_7141_().m_35560_()), this.cost);
                return new MerchantOffer(itemstack, new ItemStack((ItemLike)Items.f_42616_), this.maxUses, this.villagerXp, 0.05f);
            }
            return null;
        }
    }

    public static class EmeraldForItems
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int cost;
        private final int maxUses;
        private final int villagerXp;
        private final float priceMultiplier;

        public EmeraldForItems(ItemLike p_35657_, int p_35658_, int p_35659_, int p_35660_) {
            this.item = p_35657_.m_5456_();
            this.cost = p_35658_;
            this.maxUses = p_35659_;
            this.villagerXp = p_35660_;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity p_219682_, RandomSource p_219683_) {
            ItemStack itemstack = new ItemStack((ItemLike)this.item, this.cost);
            return new MerchantOffer(itemstack, new ItemStack((ItemLike)Items.f_42616_), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class DyedArmorForEmeralds
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int value;
        private final int maxUses;
        private final int villagerXp;

        public DyedArmorForEmeralds(Item p_35639_, int p_35640_) {
            this(p_35639_, p_35640_, 12, 1);
        }

        public DyedArmorForEmeralds(Item p_35642_, int p_35643_, int p_35644_, int p_35645_) {
            this.item = p_35642_;
            this.value = p_35643_;
            this.maxUses = p_35644_;
            this.villagerXp = p_35645_;
        }

        public MerchantOffer m_213663_(Entity p_219679_, RandomSource p_219680_) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42616_, this.value);
            ItemStack itemstack1 = new ItemStack((ItemLike)this.item);
            if (this.item instanceof DyeableArmorItem) {
                ArrayList list = Lists.newArrayList();
                list.add(DyedArmorForEmeralds.getRandomDye(p_219680_));
                if (p_219680_.m_188501_() > 0.7f) {
                    list.add(DyedArmorForEmeralds.getRandomDye(p_219680_));
                }
                if (p_219680_.m_188501_() > 0.8f) {
                    list.add(DyedArmorForEmeralds.getRandomDye(p_219680_));
                }
                itemstack1 = DyeableLeatherItem.m_41118_((ItemStack)itemstack1, (List)list);
            }
            return new MerchantOffer(itemstack, itemstack1, this.maxUses, this.villagerXp, 0.2f);
        }

        private static DyeItem getRandomDye(RandomSource p_219677_) {
            return DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)p_219677_.m_188503_(16)));
        }
    }
}

