/*
 * Decompiled with CFR 0.152.
 */
package com.binome.overweightfarming.util;

import com.binome.overweightfarming.blocks.CropFullBlock;
import com.binome.overweightfarming.init.OFBlocks;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class OvergrowthHandler {
    public static final LinkedHashMap<Block, Block> CROPS_TO_OVERGROWN = (LinkedHashMap)Util.m_137469_((Object)Maps.newLinkedHashMap(), map -> {
        map.put(Blocks.f_50249_, (Block)OFBlocks.OVERWEIGHT_CARROT.get());
        map.put(Blocks.f_50250_, (Block)OFBlocks.OVERWEIGHT_POTATO.get());
        map.put(Blocks.f_50262_, (Block)OFBlocks.OVERWEIGHT_COCOA.get());
        map.put(Blocks.f_50444_, (Block)OFBlocks.OVERWEIGHT_BEETROOT.get());
    });

    public static void overweightGrowth(Random random, BlockState state, ServerLevel world, BlockPos blockPos, Block cropBlock) {
        OvergrowthHandler.growOverweightCrop(random, state, world, blockPos, cropBlock);
    }

    public static void growOverweightCrop(Random random, BlockState state, ServerLevel world, BlockPos blockPos, Block cropBlock) {
        if (state.m_60713_(Blocks.f_50249_)) {
            OvergrowthHandler.growCarrotStem(world, blockPos, random);
        } else if (state.m_60713_(Blocks.f_50262_)) {
            world.m_7731_(blockPos, ((Block)OFBlocks.OVERWEIGHT_COCOA.get()).m_49966_(), 2);
        } else {
            OvergrowthHandler.simpleOverweightGrowth(world, blockPos, CROPS_TO_OVERGROWN.get(cropBlock).m_49966_(), ((CropFullBlock)CROPS_TO_OVERGROWN.get(cropBlock)).getStemBlock().m_49966_());
        }
    }

    private static void simpleOverweightGrowth(ServerLevel world, BlockPos blockPos, BlockState CROPS_TO_OVERGROWN, BlockState CROPS_TO_OVERGROWN1) {
        OvergrowthHandler.setBlock(world, blockPos, CROPS_TO_OVERGROWN);
        OvergrowthHandler.setBlock(world, blockPos.m_7494_(), CROPS_TO_OVERGROWN1);
    }

    public static void growCarrotStem(ServerLevel world, BlockPos blockPos, Random random) {
        int height = random.nextBoolean() && random.nextInt(5) == 0 ? (random.nextBoolean() && random.nextInt(10) == 0 ? 4 : 3) : 2;
        BlockPos startPos = blockPos.m_7494_();
        BlockPos.MutableBlockPos mutableBlockPos = startPos.m_122032_();
        for (int i = 0; i < height; ++i) {
            BlockState placeState = ((Block)OFBlocks.OVERWEIGHT_CARROT.get()).m_49966_();
            if (i == 0) {
                placeState = ((Block)OFBlocks.OVERWEIGHT_CARROT_STEM.get()).m_49966_();
            }
            OvergrowthHandler.setBlock(world, (BlockPos)mutableBlockPos, placeState);
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
    }

    private static void setBlock(ServerLevel world, BlockPos blockPos, BlockState OVERWEIGHT_CARROT_STEM) {
        for (Block cropBlock : CROPS_TO_OVERGROWN.keySet()) {
            BlockState state = world.m_8055_(blockPos);
            if (!state.m_60795_() && state.m_60734_() != cropBlock && !state.m_60713_(Blocks.f_50093_) && !state.m_60713_(Blocks.f_50493_)) continue;
            world.m_7731_(blockPos, OVERWEIGHT_CARROT_STEM, 2);
        }
    }
}

