/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.overweightfarming.items;

import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.orcinus.overweightfarming.client.models.StrawHatModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrawHatItem
extends ArmorItem {
    public static final StrawHatMaterial MATERIAL = new StrawHatMaterial();
    private static final ResourceLocation TEXTURE = new ResourceLocation("overweight_farming", "textures/entity/straw_hat/straw_hat.png");
    private static final ResourceLocation TRANS_TEXTURE = new ResourceLocation("overweight_farming", "textures/entity/straw_hat/trans_rights.png");
    private static final ResourceLocation STRAW_TEXTURE = new ResourceLocation("overweight_farming", "textures/entity/straw_hat/straw_hat_straw.png");
    private static final ResourceLocation TEXTURE_420 = new ResourceLocation("overweight_farming", "textures/entity/straw_hat/420.png");

    public StrawHatItem(EquipmentSlot slot, Item.Properties properties) {
        super((ArmorMaterial)MATERIAL, slot, properties);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return StrawHatItem.is420(stack) ? TEXTURE_420.toString() : (StrawHatItem.isStraw(stack) ? STRAW_TEXTURE.toString() : (StrawHatItem.isTrans(stack) ? TRANS_TEXTURE.toString() : TEXTURE.toString()));
    }

    public static boolean is420(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("420");
    }

    public static boolean isStraw(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("Straw");
    }

    public static boolean isTrans(ItemStack stack) {
        return StrawHatItem.getContents(stack).equals("Trans Rights");
    }

    @NotNull
    private static String getContents(ItemStack stack) {
        return stack.m_41786_().m_6111_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public HumanoidModel<?> getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return new StrawHatModel(StrawHatModel.createBodyLayer().m_171564_());
            }
        });
    }

    private static class StrawHatMaterial
    implements ArmorMaterial {
        private StrawHatMaterial() {
        }

        public int m_7366_(EquipmentSlot slot) {
            return 5;
        }

        public int m_7365_(EquipmentSlot slot) {
            return 1;
        }

        public int m_6646_() {
            return 0;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        public Ingredient m_6230_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_});
        }

        public String m_6082_() {
            return "straw";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }
}

