/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.block.entity.ancient.gateway;

import com.acikek.purpeille.advancement.ModCriteria;
import com.acikek.purpeille.block.ModBlocks;
import com.acikek.purpeille.block.entity.ModBlockEntities;
import com.acikek.purpeille.block.entity.ancient.CorePoweredAncientMachineBlockEntity;
import com.acikek.purpeille.block.entity.ancient.gateway.AncientGateway;
import com.acikek.purpeille.item.core.EncasedCore;
import com.acikek.purpeille.sound.ModSoundEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class AncientGatewayBlockEntity
extends CorePoweredAncientMachineBlockEntity {
    public static class_2591<AncientGatewayBlockEntity> BLOCK_ENTITY_TYPE;
    public int charge = 0;

    public AncientGatewayBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    @Override
    public void addCore(class_1937 world, class_1799 stack, boolean unset, class_1657 player, class_2338 pos, class_2680 state) {
        super.addCore(world, stack, unset, player, pos, state);
        if (world != null) {
            world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)AncientGateway.READY, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)AncientGateway.CHARGING, (Comparable)Boolean.valueOf(world.method_8479(pos))));
            this.playSound(class_3417.field_19197);
        }
    }

    @Override
    public void removeCore(class_1937 world, class_1657 player, boolean remove, class_2338 pos, class_2680 state) {
        super.removeCore(world, player, remove, pos, state);
        class_2680 newState = (class_2680)state.method_11657((class_2769)AncientGateway.READY, (Comparable)Boolean.valueOf(false));
        if (((Boolean)state.method_11654((class_2769)AncientGateway.CHARGING)).booleanValue()) {
            newState = (class_2680)newState.method_11657((class_2769)AncientGateway.CHARGING, (Comparable)Boolean.valueOf(false));
            this.charge = 0;
        }
        world.method_8501(pos, newState);
        this.playSound(class_3417.field_14770);
    }

    public class_1657 getPlayer(class_1937 world, class_2338 pos) {
        class_2338 top = pos.method_10084();
        class_243 center = class_243.method_24953((class_2382)top);
        class_1657 player = world.method_18459(center.field_1352, center.field_1351, center.field_1350, 1.0, false);
        if (player == null || !player.method_24515().equals((Object)top)) {
            return null;
        }
        return player;
    }

    public int getBlocks() {
        int blocks = this.charge / 4 * EncasedCore.getModifier(this.getItem());
        this.charge = 0;
        return blocks;
    }

    public class_2338 getDestinationPos(class_1657 player, class_2680 state, int blocks) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)AncientGateway.FACING);
        if (this.getCore() != null && this.getCore().type == EncasedCore.Type.VACUOUS) {
            class_243 rotation = player.method_5828(1.0f).method_1021((double)blocks);
            return player.method_24515().method_10081(new class_2382(rotation.field_1352, 0.0, rotation.field_1350));
        }
        return player.method_24515().method_10079(facing, blocks);
    }

    public class_243 getDestination(class_1937 world, class_1657 player, class_2680 state, int blocks) {
        class_2338 pos = this.getDestinationPos(player, state, blocks);
        return class_243.method_24953((class_2382)world.method_8621().method_39538((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
    }

    public class_2680 damageCore(class_1937 world, class_2680 state, int blocks) {
        EncasedCore core = this.getCore();
        if (core != null && core.type == EncasedCore.Type.CREATIVE) {
            return state;
        }
        int damage = Math.abs(blocks / 10);
        if (this.damageCore(damage > 0 ? damage : 1, world.field_9229)) {
            return (class_2680)state.method_11657((class_2769)AncientGateway.READY, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public class_2680 activate(class_1937 world, class_2338 pos, class_2680 state) {
        class_1657 player = this.getPlayer(world, pos);
        int blocks = this.getBlocks();
        if (player == null || blocks == 0) {
            return state;
        }
        class_243 destination = this.getDestination(world, player, state, blocks);
        player.method_20620(destination.method_10216(), destination.method_10214(), destination.method_10215());
        player.method_17356(ModSoundEvents.ANCIENT_GATEWAY_TELEPORT, class_3419.field_15245, 1.0f, 1.0f);
        world.method_8396(player, pos, ModSoundEvents.ANCIENT_GATEWAY_TELEPORT, class_3419.field_15245, 1.0f, 1.0f);
        ModCriteria.ANCIENT_GATEWAY_USED.trigger((class_3222)player, blocks);
        return this.damageCore(world, state, blocks);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, AncientGatewayBlockEntity blockEntity) {
        if (!world.method_8608() && ((Boolean)state.method_11654((class_2769)AncientGateway.CHARGING)).booleanValue()) {
            ++blockEntity.charge;
            if (world.method_8510() % 80L == 0L) {
                blockEntity.playSound(class_3417.field_15045, 0.5f);
            }
        }
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        this.addCore(this.field_11863, stack, false, null, this.field_11867, this.method_11010());
    }

    @Override
    public class_1799 method_5434(int slot, int count) {
        this.removeCore(this.field_11863, null, false, this.field_11867, this.method_11010());
        return super.method_5434(slot, count);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return dir != class_2350.field_11033 && (Boolean)this.method_11010().method_11654((class_2769)AncientGateway.READY) == false && stack.method_7909() instanceof EncasedCore;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return dir == class_2350.field_11033 && (Boolean)this.method_11010().method_11654((class_2769)AncientGateway.CHARGING) == false;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.charge = nbt.method_10550("Charge");
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        nbt.method_10569("Charge", this.charge);
        super.method_11007(nbt);
    }

    public static void register() {
        BLOCK_ENTITY_TYPE = ModBlockEntities.build("ancient_gateway_block_entity", AncientGatewayBlockEntity::new, new class_2248[]{ModBlocks.ANCIENT_GATEWAY});
    }
}

