/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.block.entity.ancient.guardian;

import com.acikek.purpeille.advancement.ModCriteria;
import com.acikek.purpeille.block.ModBlocks;
import com.acikek.purpeille.block.entity.CommonBlockWithEntity;
import com.acikek.purpeille.block.entity.ModBlockEntities;
import com.acikek.purpeille.block.entity.ancient.CorePoweredAncientMachineBlockEntity;
import com.acikek.purpeille.block.entity.ancient.guardian.AncientGuardian;
import com.acikek.purpeille.item.core.EncasedCore;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4969;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class AncientGuardianBlockEntity
extends CorePoweredAncientMachineBlockEntity {
    public static class_2591<AncientGuardianBlockEntity> BLOCK_ENTITY_TYPE;
    public static class_5250 VOID_TETHER_RESTORED;
    public UUID tetheredPlayer;
    public int cooldown;
    public boolean pendingRemoval;

    public AncientGuardianBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    public boolean isPlayerTethered(class_1657 player) {
        return this.tetheredPlayer != null && this.tetheredPlayer.equals(player.method_5667());
    }

    public static class_3218 getSpawnWorld(class_3222 player) {
        if (player.method_26280() == null) {
            return null;
        }
        return player.field_13995.method_3847(player.method_26281());
    }

    public static AncientGuardianBlockEntity getTether(class_3222 player) {
        class_2586 class_25862;
        class_3218 world = AncientGuardianBlockEntity.getSpawnWorld(player);
        if (world != null && (class_25862 = world.method_8321(player.method_26280())) instanceof AncientGuardianBlockEntity) {
            AncientGuardianBlockEntity blockEntity = (AncientGuardianBlockEntity)class_25862;
            return blockEntity;
        }
        return null;
    }

    public static class_2540 getBasePacket(class_1297 entity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entity.method_5628());
        return buf;
    }

    public class_2540 getActivationPacket(class_3222 player) {
        class_2540 buf = AncientGuardianBlockEntity.getBasePacket((class_1297)player);
        buf.method_10793(this.getItem());
        return buf;
    }

    public static void sendActivation(class_3222 player, class_2540 base, class_2540 activation, boolean item, boolean vacuous) {
        if (vacuous) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)AncientGuardian.VACUOUS_BLAST, (class_2540)base);
        }
        if (item) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)AncientGuardian.ANCIENT_GUARDIAN_ACTIVATED, (class_2540)activation);
        }
    }

    public static void sendActivationNearby(class_1297 entity, class_2540 base, class_2540 activation, boolean item, boolean vacuous) {
        for (class_3222 p : PlayerLookup.tracking((class_1297)entity)) {
            if (p == entity) continue;
            AncientGuardianBlockEntity.sendActivation(p, base, activation, item, vacuous);
        }
    }

    public static class_1282 getDamageSource(class_1657 player) {
        return new class_1285("guardianWrath", (class_1297)player).method_5515();
    }

    public static int damageAOE(class_3222 player) {
        class_238 area = class_238.method_30048((class_243)player.method_19538(), (double)10.0, (double)10.0, (double)10.0);
        int killed = 0;
        class_1282 damageSource = AncientGuardianBlockEntity.getDamageSource((class_1657)player);
        for (class_1297 entity : player.field_6002.method_8335((class_1297)player, area)) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            entity.method_5643(damageSource, 45.0f);
            if (livingEntity.method_29504()) {
                ++killed;
                continue;
            }
            livingEntity.method_37222(new class_1293(class_1294.field_38092, 1200, 2), (class_1297)player);
        }
        return killed;
    }

    public boolean teleportPlayer(class_3222 player) {
        boolean interdimensional = false;
        class_3218 world = AncientGuardianBlockEntity.getSpawnWorld(player);
        if (player.method_14220() != world) {
            interdimensional = true;
        }
        class_4969.method_26156((class_1299)class_1299.field_6097, (class_1941)world, (class_2338)this.field_11867).ifPresent(pos -> player.method_14251(world, pos.field_1352, pos.field_1351, pos.field_1350, player.method_36454(), player.method_36455()));
        return interdimensional;
    }

    public void activate(class_3222 player, int armorPieces) {
        this.cooldown = 6000 / this.getCore().type.modifier;
        player.method_6033((float)armorPieces * 0.25f * player.method_6063());
        player.method_6092(new class_1293(class_1294.field_5907, 60, 5));
        EncasedCore.Type coreType = this.getCore().type;
        boolean vacuous = coreType == EncasedCore.Type.VACUOUS;
        class_2540 base = AncientGuardianBlockEntity.getBasePacket((class_1297)player);
        class_2540 activation = this.getActivationPacket(player);
        AncientGuardianBlockEntity.sendActivationNearby((class_1297)player, base, activation, true, vacuous);
        player.method_17356(class_3417.field_14931, class_3419.field_15248, 1.0f, 0.75f);
        if (this.field_11863 != null) {
            this.field_11863.method_8396((class_1657)player, player.method_24515(), class_3417.field_14931, class_3419.field_15248, 1.0f, 0.75f);
            int killed = 0;
            boolean interdimensional = false;
            if (coreType == EncasedCore.Type.VACUOUS) {
                killed = AncientGuardianBlockEntity.damageAOE(player);
                interdimensional = this.teleportPlayer(player);
            }
            AncientGuardianBlockEntity.sendActivation(player, base, activation, true, vacuous);
            class_2680 newState = (class_2680)this.method_11010().method_11657((class_2769)AncientGuardian.ON_COOLDOWN, (Comparable)Boolean.valueOf(true));
            if (this.damageCore(256, this.field_11863.field_9229)) {
                newState = (class_2680)newState.method_11657((class_2769)CommonBlockWithEntity.FULL, (Comparable)Boolean.valueOf(false));
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    serverWorld.method_14178().method_14128(this.field_11867);
                }
            }
            this.field_11863.method_8501(this.field_11867, newState);
            ModCriteria.ANCIENT_GUARDIAN_USED.trigger(player, coreType, killed, interdimensional);
        }
    }

    @Override
    public void addCore(class_1937 world, class_1799 stack, boolean unset, class_1657 player, class_2338 pos, class_2680 state) {
        super.addCore(world, stack, unset, player, pos, state);
        this.tetheredPlayer = player.method_5667();
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)CommonBlockWithEntity.FULL, (Comparable)Boolean.valueOf(true)));
        if (player instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)player;
            serverPlayerEntity.method_26284(world.method_27983(), pos, 0.0f, false, false);
            this.playSound(class_3417.field_15013, 0.5f);
        }
    }

    @Override
    public void removeItem() {
        super.removeItem();
        this.pendingRemoval = true;
    }

    @Override
    public void removeCore(class_1937 world, class_1657 player, boolean remove, class_2338 pos, class_2680 state) {
        super.removeCore(world, player, remove, pos, state);
        this.tetheredPlayer = null;
        this.playSound(class_3417.field_28977);
        world.method_8501(pos, (class_2680)state.method_11657((class_2769)CommonBlockWithEntity.FULL, (Comparable)Boolean.valueOf(false)));
    }

    public class_3222 getTetheredPlayer(class_1937 world) {
        MinecraftServer server = world.method_8503();
        if (server == null) {
            return null;
        }
        return server.method_3760().method_14602(this.tetheredPlayer);
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 state, AncientGuardianBlockEntity blockEntity) {
        if (blockEntity.cooldown > 0) {
            --blockEntity.cooldown;
            if (!world.method_8608() && blockEntity.cooldown == 0) {
                class_3222 player = blockEntity.getTetheredPlayer(world);
                if (player != null) {
                    player.method_7353((class_2561)VOID_TETHER_RESTORED, false);
                }
                world.method_8501(blockPos, (class_2680)state.method_11657((class_2769)AncientGuardian.ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
            }
        }
        if (blockEntity.pendingRemoval) {
            blockEntity.removeItem();
            blockEntity.pendingRemoval = false;
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.tetheredPlayer = nbt.method_25928("TetheredPlayer") ? nbt.method_25926("TetheredPlayer") : null;
        this.cooldown = nbt.method_10550("Cooldown");
        this.pendingRemoval = nbt.method_10577("PendingRemoval");
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        if (this.tetheredPlayer != null) {
            nbt.method_25927("TetheredPlayer", this.tetheredPlayer);
        }
        nbt.method_10569("Cooldown", this.cooldown);
        nbt.method_10556("PendingRemoval", this.pendingRemoval);
        super.method_11007(nbt);
    }

    public static void register() {
        BLOCK_ENTITY_TYPE = ModBlockEntities.build("ancient_guardian_block_entity", AncientGuardianBlockEntity::new, new class_2248[]{ModBlocks.ANCIENT_GUARDIAN});
    }

    static {
        VOID_TETHER_RESTORED = class_2561.method_43471((String)"message.purpeille.ancient_guardian.void_tether_restored").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
    }
}

