/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.block.entity.ancient.oven;

import com.acikek.purpeille.advancement.ModCriteria;
import com.acikek.purpeille.block.ModBlocks;
import com.acikek.purpeille.block.entity.CommonBlockWithEntity;
import com.acikek.purpeille.block.entity.ModBlockEntities;
import com.acikek.purpeille.block.entity.ancient.AncientMachineBlockEntity;
import com.acikek.purpeille.block.entity.ancient.oven.AncientOven;
import com.acikek.purpeille.block.entity.ancient.oven.Damage;
import com.acikek.purpeille.recipe.oven.AncientOvenRecipe;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class AncientOvenBlockEntity
extends AncientMachineBlockEntity {
    public static class_2591<AncientOvenBlockEntity> BLOCK_ENTITY_TYPE;
    public int durability;
    public int cookTime;
    public int damageToTake;
    public class_1799 result = class_1799.field_8037;

    public AncientOvenBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    public AncientOvenBlockEntity(class_2338 pos, class_2680 state, Damage damage) {
        this(pos, state);
        this.durability = damage.max;
    }

    public void addRecipe(AncientOvenRecipe recipe) {
        this.cookTime = recipe.cookTime();
        this.damageToTake = recipe.damage();
        this.result = (this.field_11863 != null ? recipe.getOutput(this.field_11863.field_9229) : recipe.method_8110()).method_7972();
    }

    public boolean checkDamage(class_1937 world, class_1657 player, class_2338 pos, class_2680 state) {
        this.durability = Damage.clamp(this.durability);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof AncientOven) {
            AncientOven block = (AncientOven)class_22482;
            if (!block.damage.inRange(this.durability)) {
                class_2586 class_25862;
                Damage newDamage = Damage.getFromDurability(this.durability);
                world.method_8501(pos, AncientOven.getNextState(state, newDamage));
                block.method_33614(world, null, pos, state);
                if (player != null) {
                    ModCriteria.ANCIENT_OVEN_DAMAGED.trigger((class_3222)player, newDamage);
                }
                if ((class_25862 = world.method_8321(pos)) instanceof AncientOvenBlockEntity) {
                    AncientOvenBlockEntity blockEntity = (AncientOvenBlockEntity)class_25862;
                    blockEntity.durability = this.durability;
                }
                return false;
            }
        }
        return true;
    }

    public Optional<AncientOvenRecipe> getRecipeMatch(class_1937 world, class_1799 stack) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132((class_3956)AncientOvenRecipe.Type.INSTANCE, (class_1263)new class_1277(new class_1799[]{stack}), world);
    }

    public boolean startRecipe(class_1937 world, class_1799 stack, boolean unset, class_1657 player, class_2338 pos, class_2680 state) {
        Optional<AncientOvenRecipe> optional = this.getRecipeMatch(world, stack);
        if (optional.isEmpty()) {
            return false;
        }
        this.onAddItem(stack, unset, player);
        this.addRecipe(optional.get());
        world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)AncientOven.LIT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)CommonBlockWithEntity.FULL, (Comparable)Boolean.valueOf(true)));
        return true;
    }

    public void finishRecipe(class_1937 world, class_1657 player, class_2338 pos, class_2680 state) {
        this.onRemoveItem(player, false);
        this.durability -= this.damageToTake;
        this.damageToTake = 0;
        this.result = class_1799.field_8037;
        if (this.checkDamage(world, player, pos, state)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CommonBlockWithEntity.FULL, (Comparable)Boolean.valueOf(false)));
        }
        this.playSound(class_3417.field_17710);
    }

    public class_1799 getOvenStack(class_2680 state) {
        class_1799 stack = new class_1799((class_1935)state.method_26204());
        stack.method_7948().method_10569("AncientOvenDurability", this.durability);
        return stack;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, AncientOvenBlockEntity blockEntity) {
        if (!world.method_8608() && ((Boolean)state.method_11654((class_2769)AncientOven.LIT)).booleanValue()) {
            --blockEntity.cookTime;
            if (blockEntity.cookTime == 0) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)AncientOven.LIT, (Comparable)Boolean.valueOf(false)));
                blockEntity.setItem(blockEntity.result);
            }
        }
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        this.startRecipe(this.field_11863, stack, false, null, this.field_11867, this.method_11010());
    }

    @Override
    public class_1799 method_5434(int slot, int count) {
        this.finishRecipe(this.field_11863, null, this.field_11867, this.method_11010());
        return super.method_5434(slot, count);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return dir != class_2350.field_11033 && (Boolean)this.method_11010().method_11654((class_2769)CommonBlockWithEntity.FULL) == false && this.getRecipeMatch(this.field_11863, stack).isPresent();
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        class_2680 state = this.method_11010();
        return dir == class_2350.field_11033 && (Boolean)state.method_11654((class_2769)CommonBlockWithEntity.FULL) != false && (Boolean)state.method_11654((class_2769)AncientOven.LIT) == false;
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.durability = nbt.method_10550("Durability");
        this.cookTime = nbt.method_10550("CookTime");
        this.damageToTake = nbt.method_10550("DamageToTake");
        this.result = class_1799.method_7915((class_2487)nbt.method_10562("Result"));
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        nbt.method_10569("Durability", this.durability);
        nbt.method_10569("CookTime", this.cookTime);
        nbt.method_10569("DamageToTake", this.damageToTake);
        nbt.method_10566("Result", (class_2520)this.result.method_7953(new class_2487()));
        super.method_11007(nbt);
    }

    public static void register() {
        BLOCK_ENTITY_TYPE = ModBlockEntities.build("ancient_oven_block_entity", AncientOvenBlockEntity::new, new class_2248[]{ModBlocks.ANCIENT_OVEN, ModBlocks.ANCIENT_OVEN_DIM, ModBlocks.ANCIENT_OVEN_VERY_DIM});
    }
}

