/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.client;

import com.acikek.purpeille.Purpeille;
import com.acikek.purpeille.block.ChorusInfestedBlocks;
import com.acikek.purpeille.block.ModBlocks;
import com.acikek.purpeille.block.entity.ancient.guardian.AncientGuardian;
import com.acikek.purpeille.client.networking.AncientGuardianActivationListener;
import com.acikek.purpeille.client.networking.VacuousBlastListener;
import com.acikek.purpeille.client.particle.AncientGuardianParticle;
import com.acikek.purpeille.client.particle.ModParticleTypes;
import com.acikek.purpeille.client.render.AncientGuardianRenderer;
import com.acikek.purpeille.warpath.component.Aspect;
import com.acikek.purpeille.warpath.component.Component;
import com.acikek.purpeille.warpath.component.Revelation;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1091;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public class PurpeilleClient
implements ClientModInitializer {
    public static final class_1091 MODEL = new class_1091("purpeille:ancient_guardian_in_hand#inventory");

    public void onInitializeClient() {
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModBlocks.END_RUBBLE, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModBlocks.END_RUBBLE, class_1921.method_23583());
        ModelLoadingRegistry.INSTANCE.registerModelProvider((manager, out) -> out.accept(MODEL));
        AncientGuardianRenderer.register();
        ModParticleTypes.register();
        AncientGuardianParticle.register();
        ClientTickEvents.START_WORLD_TICK.register(world -> AncientGuardianRenderer.tick());
        PurpeilleClient.registerReceivers();
        PurpeilleClient.registerPacks();
        PurpeilleClient.handleReload("revelations", Component.REVELATIONS, Revelation::read);
        PurpeilleClient.handleReload("aspects", Component.ASPECTS, Aspect::read);
    }

    public static void registerPack(ModContainer mod, String key, String name, ResourcePackActivationType type) {
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Purpeille.id(key), (ModContainer)mod, (String)name, (ResourcePackActivationType)type);
    }

    public static void registerPacks() {
        FabricLoader.getInstance().getModContainer("purpeille").ifPresent(mod -> {
            PurpeilleClient.registerPack(mod, "old", "Purpeille Legacy", ResourcePackActivationType.NORMAL);
            PurpeilleClient.registerPack(mod, "theinar", "Theinar Language", ResourcePackActivationType.ALWAYS_ENABLED);
        });
    }

    public static void registerReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AncientGuardian.ANCIENT_GUARDIAN_ACTIVATED, (ClientPlayNetworking.PlayChannelHandler)new AncientGuardianActivationListener());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AncientGuardian.VACUOUS_BLAST, (ClientPlayNetworking.PlayChannelHandler)new VacuousBlastListener());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ChorusInfestedBlocks.INFESTATION_TRIM, (client, handler, buf, responseSender) -> {
            if (client.field_1687 != null) {
                client.field_1687.method_31595(buf.method_10811(), class_2248.method_9531((int)buf.readInt()));
            }
        });
    }

    public static <T extends Component> void handleReload(String key, Map<class_2960, T> registry, Function<class_2540, T> read) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Purpeille.id(key), (client, handler, buf, responseSender) -> {
            if (client.method_1542()) {
                return;
            }
            if (buf.readBoolean()) {
                registry.clear();
            }
            registry.put(buf.method_10810(), (Component)read.apply(buf));
        });
    }
}

