/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.compat.emi;

import com.acikek.purpeille.Purpeille;
import com.acikek.purpeille.block.ModBlocks;
import com.acikek.purpeille.compat.emi.PurpeillePlugin;
import com.acikek.purpeille.recipe.oven.AncientOvenRecipe;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;

public class EmiAncientOvenRecipe
implements EmiRecipe {
    public static final EmiTexture EMPTY_SMALL_ARROW = new EmiTexture(PurpeillePlugin.WIDGETS, 0, 0, 24, 9);
    public static final EmiTexture SMALL_ARROW = new EmiTexture(PurpeillePlugin.WIDGETS, 0, 9, 24, 10);
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(Purpeille.id("ancient_oven"), (EmiRenderable)EmiStack.of((class_1935)ModBlocks.ANCIENT_OVEN), (matrices, x, y, delta) -> {
        RenderSystem.setShaderTexture((int)0, (class_2960)PurpeillePlugin.WIDGETS);
        class_332.method_25290((class_4587)matrices, (int)x, (int)y, (float)240.0f, (float)240.0f, (int)16, (int)16, (int)256, (int)256);
    });
    public class_2960 id;
    public EmiIngredient input;
    public List<EmiStack> outputs;
    public int cookTime;
    public int damage;
    boolean isRandom;

    public EmiAncientOvenRecipe(AncientOvenRecipe recipe) {
        this.id = recipe.method_8114();
        this.input = EmiIngredient.of((class_1856)recipe.input());
        this.outputs = Arrays.stream(recipe.result()).map(EmiStack::of).collect(Collectors.toList());
        this.cookTime = recipe.cookTime();
        this.damage = recipe.damage();
        this.isRandom = this.outputs.size() != 1;
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public boolean supportsRecipeTree() {
        return !this.isRandom;
    }

    public int getDisplayWidth() {
        return 82;
    }

    public int getDisplayHeight() {
        return this.isRandom ? 20 * this.outputs.size() + 12 : 38;
    }

    public void addWidgets(WidgetHolder widgets) {
        int inputY = (this.outputs.size() - 1) * 10 + (this.isRandom ? 0 : 4);
        List<class_5684> arrowTooltip = List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"emi.cooking.time", (Object[])new Object[]{Float.valueOf((float)this.cookTime / 20.0f)}).method_30937()));
        widgets.addSlot(this.input, 0, inputY);
        if (!this.isRandom) {
            widgets.addFillingArrow(24, inputY + 1, 50 * this.cookTime).tooltip((x, y) -> arrowTooltip);
            widgets.addSlot((EmiIngredient)this.outputs.get(0), 56, 0).output(true).recipeContext((EmiRecipe)this);
        } else {
            for (int i = 0; i < this.outputs.size(); ++i) {
                int y2 = i * 20 + 5;
                widgets.addTexture(EMPTY_SMALL_ARROW, 29, y2);
                widgets.addAnimatedTexture(SMALL_ARROW, 29, y2 - 1, 50 * this.cookTime, true, false, false).tooltip((mouseX, mouseY) -> arrowTooltip);
                widgets.addSlot((EmiIngredient)this.outputs.get(i), 64, i * 20).recipeContext((EmiRecipe)this).appendTooltip(() -> PurpeillePlugin.getChanceTooltip(100.0 / (double)this.outputs.size()));
            }
        }
        widgets.addText(class_2561.method_43469((String)"emi.purpeille.ancient_oven.damage", (Object[])new Object[]{this.damage}).method_27692(this.damage > 0 ? class_124.field_1061 : class_124.field_1060).method_30937(), 1, widgets.getHeight() - 10, -1, true);
    }
}

