/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.compat.emi;

import com.acikek.purpeille.Purpeille;
import com.acikek.purpeille.block.ChorusInfestedBlocks;
import com.acikek.purpeille.block.ModBlocks;
import com.acikek.purpeille.compat.emi.EmiAncientOvenRecipe;
import com.acikek.purpeille.compat.emi.warpath.CatalystInstance;
import com.acikek.purpeille.compat.emi.warpath.EmiWarpathCreateRecipe;
import com.acikek.purpeille.compat.emi.warpath.EmiWarpathRemoveRecipe;
import com.acikek.purpeille.recipe.oven.AncientOvenRecipe;
import com.acikek.purpeille.tag.ModTags;
import com.acikek.purpeille.warpath.component.Aspect;
import com.acikek.purpeille.warpath.component.Component;
import com.acikek.purpeille.warpath.component.Revelation;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class PurpeillePlugin
implements EmiPlugin {
    public static class_2960 WIDGETS = Purpeille.id("textures/gui/emi/widgets.png");
    public static final class_2248[] ANCIENT_OVENS = new class_2248[]{ModBlocks.ANCIENT_OVEN, ModBlocks.ANCIENT_OVEN_DIM, ModBlocks.ANCIENT_OVEN_VERY_DIM};

    public static Optional<List<class_1792>> getTagItems(class_6862<class_1792> tag) {
        return class_2378.field_11142.method_40266(tag).map(holders -> holders.method_40239().map(class_6880::comp_349).collect(Collectors.toList()));
    }

    public static Map<CatalystInstance<Revelation>, List<CatalystInstance<Aspect>>> getCompatibleCatalysts(List<CatalystInstance<Revelation>> revelationInstances, List<CatalystInstance<Aspect>> aspectInstances) {
        HashMap<CatalystInstance<Revelation>, List<CatalystInstance<Aspect>>> result = new HashMap<CatalystInstance<Revelation>, List<CatalystInstance<Aspect>>>();
        for (CatalystInstance<Revelation> revelationInstance : revelationInstances) {
            List compatibleAspects = aspectInstances.stream().filter(instance -> Component.areCompatible(revelationInstance.component(), instance.component())).filter(instance -> ((Revelation)revelationInstance.component()).getFixedIndex() != ((Aspect)instance.component()).getFixedIndex()).collect(Collectors.toList());
            result.put(revelationInstance, compatibleAspects);
        }
        return result;
    }

    public static List<class_1792> getAllItems(List<CatalystInstance<Revelation>> revelationInstances, List<CatalystInstance<Aspect>> aspectInstances) {
        ArrayList<class_1792> result = new ArrayList<class_1792>();
        CatalystInstance.addItems(revelationInstances, result);
        CatalystInstance.addItems(aspectInstances, result);
        return result;
    }

    public static class_2960 getWarpathRecipeId(String method, class_1792 base) {
        return new class_2960("emi", "purpeille/warpath_" + method + "/" + class_2378.field_11142.method_10221((Object)base).method_12832());
    }

    public static class_2960 getInfestedInteractionId(String method, class_2248 block) {
        return new class_2960("emi", "purpeille/" + method + "/" + class_2378.field_11146.method_10221((Object)block).method_12832());
    }

    public static class_5684 getChanceTooltip(double chance) {
        return class_5684.method_32662((class_5481)class_2561.method_43469((String)"emi.purpeille.chance", (Object[])new Object[]{chance}).method_30937());
    }

    public void register(EmiRegistry registry) {
        registry.addCategory(EmiAncientOvenRecipe.CATEGORY);
        for (class_2248 oven : ANCIENT_OVENS) {
            registry.addWorkstation(EmiAncientOvenRecipe.CATEGORY, (EmiIngredient)EmiStack.of((class_1799)oven.method_8389().method_7854()));
        }
        List aspectCatalysts = PurpeillePlugin.getTagItems(ModTags.ASPECT_CATALYST).orElse(Collections.emptyList());
        PurpeillePlugin.getTagItems(ModTags.WARPATH_BASE).ifPresent(warpathBases -> PurpeillePlugin.getTagItems(ModTags.REVELATION_CATALYST).ifPresent(revelationCatalysts -> {
            List<CatalystInstance<Aspect>> aspectInstances = CatalystInstance.getInstances(aspectCatalysts, Component.ASPECTS);
            List<CatalystInstance<Revelation>> revelationInstances = CatalystInstance.getInstances(revelationCatalysts, Component.REVELATIONS);
            Map<CatalystInstance<Revelation>, List<CatalystInstance<Aspect>>> compatibleCatalysts = PurpeillePlugin.getCompatibleCatalysts(revelationInstances, aspectInstances);
            List<class_1792> allItems = PurpeillePlugin.getAllItems(revelationInstances, aspectInstances);
            for (class_1792 base : warpathBases) {
                registry.addRecipe((EmiRecipe)new EmiWarpathCreateRecipe(base, compatibleCatalysts, allItems, PurpeillePlugin.getWarpathRecipeId("create", base)));
                registry.addRecipe((EmiRecipe)new EmiWarpathRemoveRecipe(base, compatibleCatalysts, PurpeillePlugin.getWarpathRecipeId("remove", base)));
            }
        }));
        for (AncientOvenRecipe recipe : registry.getRecipeManager().method_30027((class_3956)AncientOvenRecipe.Type.INSTANCE)) {
            registry.addRecipe((EmiRecipe)new EmiAncientOvenRecipe(recipe));
        }
        ArrayList<EmiWorldInteractionRecipe> growingRecipes = new ArrayList<EmiWorldInteractionRecipe>();
        ArrayList<EmiWorldInteractionRecipe> shearingRecipes = new ArrayList<EmiWorldInteractionRecipe>();
        EmiStack boneMeal = EmiStack.of((class_1935)class_1802.field_8324);
        EmiStack shears = EmiStack.of((class_1935)class_1802.field_8868);
        EmiStack chorusFruit = EmiStack.of((class_1935)class_1802.field_8233);
        for (Map.Entry entry : ChorusInfestedBlocks.STAGES.entrySet()) {
            EmiStack normal = EmiStack.of((class_1935)((class_1935)entry.getKey()));
            EmiStack grown = EmiStack.of((class_1935)((class_1935)entry.getValue()));
            EmiWorldInteractionRecipe growingRecipe = EmiWorldInteractionRecipe.builder().id(PurpeillePlugin.getInfestedInteractionId("growing", (class_2248)entry.getKey())).leftInput((EmiIngredient)normal).rightInput((EmiIngredient)boneMeal, false).output(grown).build();
            EmiWorldInteractionRecipe.Builder shearingRecipeBuilder = EmiWorldInteractionRecipe.builder().id(PurpeillePlugin.getInfestedInteractionId("shearing", (class_2248)entry.getValue())).leftInput((EmiIngredient)grown).rightInput((EmiIngredient)shears, true);
            if (ChorusInfestedBlocks.CHORAL_BLOOM.contains(entry.getValue())) {
                shearingRecipeBuilder = shearingRecipeBuilder.output(chorusFruit, slot -> new SlotWidget((EmiIngredient)chorusFruit, slot.getBounds().x(), slot.getBounds().y()).appendTooltip(() -> PurpeillePlugin.getChanceTooltip(50.0)));
            }
            EmiWorldInteractionRecipe shearingRecipe = shearingRecipeBuilder.output(normal).build();
            growingRecipes.add(growingRecipe);
            shearingRecipes.add(shearingRecipe);
        }
        for (EmiRecipe emiRecipe : growingRecipes) {
            registry.addRecipe(emiRecipe);
        }
        for (EmiRecipe emiRecipe : shearingRecipes) {
            registry.addRecipe(emiRecipe);
        }
    }
}

