/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.warpath;

import com.google.gson.JsonElement;
import net.minecraft.class_124;
import net.minecraft.class_3518;
import net.minecraft.class_3532;

public class ClampedColor {
    public static final int THRESHOLD = 50;
    public static final int COLOR_MAX = 255;
    public static final long INTERVAL = 4000L;
    public static final float INTERVAL_F = 4000.0f;
    public int colorValue;
    public Value r;
    public Value g;
    public Value b;

    public ClampedColor(int colorValue) {
        this.colorValue = colorValue;
        this.r = new Value((colorValue & 0xFF0000) >> 16);
        this.g = new Value((colorValue & 0xFF00) >> 8);
        this.b = new Value(colorValue & 0xFF);
    }

    public ClampedColor(class_124 formatting) {
        this(ClampedColor.getColorValue(formatting));
    }

    public static int getColorValue(class_124 formatting) {
        Integer value = formatting.method_532();
        return value != null ? value : 0xFFFFFF;
    }

    public int getModified(int wave) {
        return class_3532.method_15383((int)this.r.clamp(wave), (int)this.g.clamp(wave), (int)this.b.clamp(wave));
    }

    public static int getWave() {
        float progress = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
        return (int)(class_3532.method_15374((float)(progress * ((float)Math.PI * 2))) * 50.0f);
    }

    public static int colorFromJson(JsonElement element) {
        if (class_3518.method_15275((JsonElement)element)) {
            return element.getAsInt();
        }
        class_124 formatting = class_124.method_533((String)element.getAsString());
        if (formatting == null) {
            throw new IllegalStateException("'" + element.getAsString() + "' is not a valid color");
        }
        return formatting.method_532() != null ? formatting.method_532() : -1;
    }

    public static class Value {
        public int value;
        public int min;
        public int max;

        public Value(int value) {
            this.value = value;
            this.min = value - 50;
            this.max = value + 50 - 255;
        }

        public int clamp(int wave) {
            int result = this.value + wave;
            if (this.min < 0) {
                result -= this.min;
            } else if (this.max > 0) {
                result -= this.max;
            }
            return result;
        }
    }
}

