/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.warpath;

import com.acikek.purpeille.warpath.component.Aspect;
import com.acikek.purpeille.warpath.component.Component;
import com.acikek.purpeille.warpath.component.Revelation;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public enum Synergy {
    OPPOSITION(-1.0),
    NEUTRAL(1.0),
    TONE(1.5),
    IDENTICAL(1.75);

    public double modifier;

    private Synergy(double modifier) {
        this.modifier = modifier;
    }

    public static Synergy getSynergy(Revelation revelation, Aspect aspect) {
        if (aspect == null) {
            return NEUTRAL;
        }
        if (revelation.synergy.containsKey(aspect.id)) {
            return revelation.synergy.get(aspect.id);
        }
        if (revelation.tone.getOpposition() == aspect.tone) {
            return OPPOSITION;
        }
        if (revelation.tone == aspect.tone) {
            return TONE;
        }
        return NEUTRAL;
    }

    public static Synergy read(class_2540 buf) {
        return (Synergy)buf.method_10818(Synergy.class);
    }

    public static void write(class_2540 buf, Synergy synergy) {
        buf.method_10817((Enum)synergy);
    }

    public static Map<class_2960, Synergy> overridesFromJson(JsonObject obj) {
        HashMap<class_2960, Synergy> result = new HashMap<class_2960, Synergy>();
        for (Map.Entry entry : obj.entrySet()) {
            class_2960 id = class_2960.method_12829((String)((String)entry.getKey()));
            Synergy synergy = Component.enumFromJson((JsonElement)entry.getValue(), Synergy::valueOf, "synergy");
            result.put(id, synergy);
        }
        return result;
    }

    public static Map<class_2960, Synergy> readOverrides(class_2540 buf) {
        return buf.method_34067(class_2540::method_10810, Synergy::read);
    }

    public static void writeOverrides(Map<class_2960, Synergy> map, class_2540 buf) {
        buf.method_34063(map, class_2540::method_10812, Synergy::write);
    }
}

