/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.warpath;

import com.acikek.purpeille.warpath.ClampedColor;
import com.acikek.purpeille.warpath.Synergy;
import com.acikek.purpeille.warpath.Type;
import com.acikek.purpeille.warpath.component.Aspect;
import com.acikek.purpeille.warpath.component.Revelation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class Warpath {
    public static final String NBT_KEY = "WarpathData";
    public static final class_5250 SEPARATOR = class_2561.method_43471((String)"separator.purpeille.warpath");
    public static final ClampedColor SEPARATOR_COLOR = new ClampedColor(class_124.field_1080);

    public static List<class_2561> getWarpath(Revelation revelation, Aspect aspect, boolean animated, boolean rite) {
        boolean hasAspect = aspect != null;
        int wave = animated ? ClampedColor.getWave() : Integer.MIN_VALUE;
        class_2583 style = hasAspect && animated && Synergy.getSynergy(revelation, aspect) == Synergy.IDENTICAL ? revelation.getStyle(wave) : null;
        class_5250 revelationText = revelation.getText(wave, style);
        if (!hasAspect) {
            return Collections.singletonList(revelationText);
        }
        ArrayList<class_2561> text = new ArrayList<class_2561>();
        class_5250 aspectText = aspect.getText(wave, style);
        class_5250 separator = SEPARATOR.method_27661().method_27694(s -> s.method_36139(SEPARATOR_COLOR.getModified(wave)));
        text.add((class_2561)aspectText.method_10852((class_2561)separator).method_10852((class_2561)revelationText));
        if (rite && Synergy.getSynergy(revelation, aspect) == Synergy.IDENTICAL) {
            text.add((class_2561)revelation.rite);
        }
        return text;
    }

    public static List<class_2561> getWarpath(class_1799 stack, boolean animated, boolean rite) {
        class_2487 data = Warpath.getData(stack);
        if (data == null) {
            return null;
        }
        Revelation revelation = Revelation.fromNbt(data);
        if (revelation == null) {
            return null;
        }
        Aspect aspect = Aspect.fromNbt(data);
        return Warpath.getWarpath(revelation, aspect, animated, rite);
    }

    public static class_2487 getData(class_1799 stack) {
        if (!stack.method_7985()) {
            return null;
        }
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545(NBT_KEY)) {
            return null;
        }
        return nbt.method_10562(NBT_KEY);
    }

    public static class_1304 getSlot(class_1799 stack) {
        if (stack.method_7909() instanceof class_1831) {
            return class_1304.field_6173;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738) {
            class_1738 armorItem = (class_1738)class_17922;
            return armorItem.method_7685();
        }
        return null;
    }

    public static void addModifiers(class_1799 stack, Revelation revelation, Aspect aspect) {
        class_1322 modifier = revelation.getModifier(stack, aspect);
        class_1304 slot = Warpath.getSlot(stack);
        if (slot != null) {
            stack.method_7916(revelation.attribute, modifier, slot);
        }
    }

    public static void addData(class_2487 nbt, Revelation revelation, Aspect aspect) {
        Type.REVELATION.addNbt(nbt, revelation.id);
        if (aspect != null) {
            Type.ASPECT.addNbt(nbt, aspect.id);
        }
    }

    public static void addData(class_2487 nbt, class_2960 revelationId, class_2960 aspectId) {
        Revelation revelation = (Revelation)Revelation.REVELATIONS.get(revelationId);
        if (revelation == null) {
            return;
        }
        Warpath.addData(nbt, revelation, (Aspect)Aspect.ASPECTS.get(aspectId));
    }

    public static void add(class_1799 stack, Revelation revelation, Aspect aspect) {
        class_2487 data = new class_2487();
        Warpath.addData(data, revelation, aspect);
        stack.method_7948().method_10566(NBT_KEY, (class_2520)data);
        Warpath.addModifiers(stack, revelation, aspect);
    }

    public static void remove(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10551(NBT_KEY);
        nbt.method_10551("AttributeModifiers");
    }
}

