/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.warpath.component;

import com.acikek.purpeille.warpath.ClampedColor;
import com.acikek.purpeille.warpath.Tone;
import com.acikek.purpeille.warpath.Type;
import com.acikek.purpeille.warpath.component.Aspect;
import com.acikek.purpeille.warpath.component.Revelation;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;

public abstract class Component {
    public static Map<class_2960, Aspect> ASPECTS = new HashMap<class_2960, Aspect>();
    public static Map<class_2960, Revelation> REVELATIONS = new HashMap<class_2960, Revelation>();
    public class_2960 id;
    public Tone tone;
    public int color;
    public class_1856 catalyst;
    public int index;
    public double modifier;
    public boolean ignoreSlot;
    public List<class_2960> whitelist;
    public int relativeIndex;
    public ClampedColor waveColor;
    public class_5250 baseText;
    public class_5250 defaultText;

    public Component(class_2960 id, Tone tone, int color, class_1856 catalyst, int index, double modifier, boolean ignoreSlot, List<class_2960> whitelist) {
        this.id = id;
        this.tone = tone;
        this.color = color;
        this.catalyst = catalyst;
        this.index = index;
        this.modifier = modifier;
        this.ignoreSlot = ignoreSlot;
        this.whitelist = whitelist;
        this.relativeIndex = tone.index * 3 + index;
        this.waveColor = new ClampedColor(color);
        this.baseText = class_2561.method_43471((String)Component.getIdKey(this.getType().translationKey, id));
        this.defaultText = this.baseText.method_27694(style -> style.method_36139(color));
    }

    public abstract Type getType();

    public class_2583 getStyle(int wave) {
        return class_2583.field_24360.method_36139(this.waveColor.getModified(wave));
    }

    public class_5250 getText(class_2583 style) {
        return this.baseText.method_27661().method_10862(style);
    }

    public class_5250 getText(int wave, class_2583 style) {
        if (style == null) {
            if (wave == Integer.MIN_VALUE) {
                return this.defaultText.method_27661();
            }
            return this.getText(this.getStyle(wave));
        }
        return this.getText(style);
    }

    public int getFixedIndex() {
        return this instanceof Aspect ? 8 - this.relativeIndex : this.relativeIndex;
    }

    public boolean isCompatible(Component other) {
        return other == null || this.whitelist == null || this.whitelist.contains(other.id);
    }

    public static boolean areCompatible(Component first, Component second) {
        return first.isCompatible(second) && (second == null || second.isCompatible(first));
    }

    public static String getIdKey(String value, class_2960 id) {
        return value + "." + id.method_12836() + "." + id.method_12832();
    }

    public static <T extends Enum<T>> T enumFromJson(JsonElement element, Function<String, T> valueOf, String name) {
        String key = element.getAsString();
        try {
            return (T)((Enum)valueOf.apply(key.toUpperCase()));
        }
        catch (Exception e) {
            throw new IllegalStateException("'" + key + "' is not a valid " + name);
        }
    }

    public static List<class_2960> whitelistFromJson(JsonObject obj) {
        JsonArray whitelistElements = class_3518.method_15292((JsonObject)obj, (String)"whitelist", null);
        if (whitelistElements == null) {
            return null;
        }
        ArrayList<class_2960> whitelist = new ArrayList<class_2960>();
        for (JsonElement element : whitelistElements) {
            whitelist.add(class_2960.method_12829((String)class_3518.method_15287((JsonElement)element, (String)"whitelist id")));
        }
        return whitelist;
    }

    public void writeWhitelist(class_2540 buf) {
        if (this.whitelist != null) {
            buf.writeInt(this.whitelist.size());
            for (class_2960 id : this.whitelist) {
                buf.method_10812(id);
            }
        } else {
            buf.writeInt(-1);
        }
    }

    public static List<class_2960> readWhitelist(class_2540 buf) {
        int size = buf.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<class_2960> whitelist = new ArrayList<class_2960>();
        for (int i = 0; i < size; ++i) {
            whitelist.add(buf.method_10810());
        }
        return whitelist;
    }

    public void write(class_2540 buf) {
        buf.method_10812(this.id);
        buf.method_10817((Enum)this.tone);
        buf.writeInt(this.color);
        this.catalyst.method_8088(buf);
        buf.writeInt(this.index);
        buf.writeDouble(this.modifier);
        buf.writeBoolean(this.ignoreSlot);
        this.writeWhitelist(buf);
    }
}

