/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.warpath.component;

import com.acikek.purpeille.warpath.Synergy;
import com.acikek.purpeille.warpath.Tone;
import com.acikek.purpeille.warpath.Type;
import com.acikek.purpeille.warpath.component.Aspect;
import com.acikek.purpeille.warpath.component.Component;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5250;

public class Revelation
extends Component {
    public static UUID WARPATH_ID = UUID.fromString("2c67c058-5d5e-4b39-98e3-b3eb9965f7eb");
    public static int RITE_RGB = 0xCCCCCC;
    public class_1320 attribute;
    public class_1856 affinity;
    public Map<class_2960, Synergy> synergy;
    public class_1322.class_1323 operation;
    public boolean forceInt;
    public class_5250 rite;

    public Revelation(class_2960 id, Tone tone, int color, class_1856 catalyst, int index, double modifier, boolean ignoreSlot, List<class_2960> whitelist, class_1320 attribute, class_1856 affinity, Map<class_2960, Synergy> synergy, boolean multiply, boolean forceInt) {
        super(id, tone, color, catalyst, index, modifier, ignoreSlot, whitelist);
        this.attribute = attribute;
        this.affinity = affinity;
        this.synergy = synergy;
        this.operation = multiply ? class_1322.class_1323.field_6331 : class_1322.class_1323.field_6328;
        this.forceInt = forceInt;
        this.rite = class_2561.method_43471((String)Revelation.getIdKey("rite", id)).method_27694(style -> style.method_36139(RITE_RGB));
    }

    public Revelation(Aspect aspect, class_1320 attribute, class_1856 affinity, Map<class_2960, Synergy> synergy, boolean multiply, boolean forceInt) {
        this(aspect.id, aspect.tone, aspect.color, aspect.catalyst, aspect.index, aspect.modifier, aspect.ignoreSlot, aspect.whitelist, attribute, affinity, synergy, multiply, forceInt);
    }

    @Override
    public Type getType() {
        return Type.REVELATION;
    }

    public double getModifierValue(class_1799 stack, Aspect aspect) {
        double value;
        double d = value = this.affinity.method_8093(stack) ? this.modifier * 1.2 : this.modifier;
        if (aspect == null) {
            return value;
        }
        return value * aspect.modifier * Synergy.getSynergy((Revelation)this, (Aspect)aspect).modifier;
    }

    public class_1322 getModifier(class_1799 stack, Aspect aspect) {
        double value = this.getModifierValue(stack, aspect);
        double adjusted = this.forceInt ? (double)((int)value) : value;
        return new class_1322(WARPATH_ID, "Warpath modifier", adjusted, this.operation);
    }

    public static Revelation fromNbt(class_2487 nbt) {
        return (Revelation)Type.REVELATION.getFromNbt(nbt, REVELATIONS);
    }

    public static Revelation fromJson(JsonObject obj, class_2960 id) {
        Aspect aspect = Aspect.fromJson(obj, id);
        class_1320 attribute = (class_1320)class_2378.field_23781.method_10223(class_2960.method_12829((String)class_3518.method_15265((JsonObject)obj, (String)"attribute")));
        class_1856 affinity = class_1856.method_8102((JsonElement)obj.get("affinity"));
        Map<class_2960, Synergy> synergy = Synergy.overridesFromJson(class_3518.method_15296((JsonObject)obj, (String)"synergy"));
        boolean multiply = class_3518.method_15270((JsonObject)obj, (String)"multiply");
        boolean forceInt = class_3518.method_15258((JsonObject)obj, (String)"force_int", (boolean)false);
        return new Revelation(aspect, attribute, affinity, synergy, multiply, forceInt);
    }

    public static Revelation read(class_2540 buf) {
        Aspect aspect = Aspect.read(buf);
        class_1320 attribute = (class_1320)class_2378.field_23781.method_10223(buf.method_10810());
        class_1856 affinity = class_1856.method_8086((class_2540)buf);
        Map<class_2960, Synergy> synergy = Synergy.readOverrides(buf);
        boolean multiply = buf.readBoolean();
        boolean forceInt = buf.readBoolean();
        return new Revelation(aspect, attribute, affinity, synergy, multiply, forceInt);
    }

    @Override
    public void write(class_2540 buf) {
        super.write(buf);
        buf.method_10812(class_2378.field_23781.method_10221((Object)this.attribute));
        this.affinity.method_8088(buf);
        Synergy.writeOverrides(this.synergy, buf);
        buf.writeBoolean(this.operation == class_1322.class_1323.field_6331);
        buf.writeBoolean(this.forceInt);
    }
}

