/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.world.reload;

import com.acikek.purpeille.Purpeille;
import com.acikek.purpeille.warpath.component.Component;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;

public class ComponentReloader<T extends Component>
extends class_4309
implements IdentifiableResourceReloadListener {
    public String type;
    public class_2960 id;
    public Map<class_2960, T> registry;
    public BiFunction<JsonObject, class_2960, T> fromJson;
    public String name;

    public ComponentReloader(String type, Map<class_2960, T> registry, BiFunction<JsonObject, class_2960, T> fromJson) {
        super(new Gson(), "warpath/" + type);
        this.type = type;
        this.id = Purpeille.id(type);
        this.registry = registry;
        this.fromJson = fromJson;
    }

    public class_2960 getFabricId() {
        return this.id;
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        this.registry.clear();
        int successful = 0;
        for (Map.Entry<class_2960, JsonElement> file : prepared.entrySet()) {
            JsonObject obj = file.getValue().getAsJsonObject();
            try {
                Component component = (Component)this.fromJson.apply(obj, file.getKey());
                this.registry.put(file.getKey(), component);
                ++successful;
            }
            catch (Exception e) {
                String typeId = this.type.substring(0, this.type.length() - 1);
                Purpeille.LOGGER.error("Error in " + typeId + " '" + file.getKey() + "': ", (Throwable)e);
            }
        }
        Purpeille.LOGGER.info("Loaded " + successful + " " + this.type);
    }
}

