/*
 * Decompiled with CFR 0.152.
 */
package com.acikek.purpeille.world.reload;

import com.acikek.purpeille.Purpeille;
import com.acikek.purpeille.warpath.component.Aspect;
import com.acikek.purpeille.warpath.component.Component;
import com.acikek.purpeille.warpath.component.Revelation;
import com.acikek.purpeille.world.reload.ComponentReloader;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;

public class ReloadHandler {
    public static <T extends Component> List<class_2540> getReloadBufs(Map<class_2960, T> registry) {
        boolean start = true;
        ArrayList<class_2540> bufs = new ArrayList<class_2540>();
        for (Map.Entry<class_2960, T> entry : registry.entrySet()) {
            Component component = (Component)entry.getValue();
            class_2540 buf = PacketByteBufs.create();
            buf.writeBoolean(start);
            if (start) {
                start = false;
            }
            buf.method_10812(entry.getKey());
            component.write(buf);
            bufs.add(buf);
        }
        return bufs;
    }

    public static <T extends Component> void handleComponentReload(String key, Map<class_2960, T> registry, BiFunction<JsonObject, class_2960, T> fromJson) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new ComponentReloader<T>(key, registry, fromJson));
        class_2960 componentId = Purpeille.id(key);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            if (server == null) {
                return;
            }
            List<class_2540> bufs = ReloadHandler.getReloadBufs(registry);
            for (class_2540 buf : bufs) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    ServerPlayNetworking.send((class_3222)player, (class_2960)componentId, (class_2540)buf);
                }
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            List<class_2540> bufs = ReloadHandler.getReloadBufs(registry);
            for (class_2540 buf : bufs) {
                ServerPlayNetworking.send((class_3222)handler.field_14140, (class_2960)componentId, (class_2540)buf);
            }
        });
    }

    public static void register() {
        ReloadHandler.handleComponentReload("revelations", Component.REVELATIONS, Revelation::fromJson);
        ReloadHandler.handleComponentReload("aspects", Component.ASPECTS, Aspect::fromJson);
    }
}

