/*
 * Decompiled with CFR 0.152.
 */
package lib;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.function.Function;
import java.util.function.Predicate;

public class EnumPredicate<T extends Enum<T>>
implements Predicate<T> {
    public T value;

    public EnumPredicate(T value) {
        this.value = value;
    }

    @Override
    public boolean test(T value) {
        if (this.value == null) {
            return true;
        }
        return this.value == value;
    }

    public static <T extends Enum<T>> EnumPredicate<T> fromJson(JsonElement json, Function<String, T> e) {
        if (json == null || json.isJsonNull()) {
            return new EnumPredicate<Object>(null);
        }
        String value = json.getAsString().toUpperCase();
        return new EnumPredicate<Enum>((Enum)e.apply(value));
    }

    public JsonElement toJson() {
        if (this.value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(((Enum)this.value).toString().toLowerCase());
    }
}

