/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens;

import com.google.gson.JsonElement;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wallywhip.resourcechickens.compat.TOP.compatTOP;
import wallywhip.resourcechickens.entity.AngryChickenEntity;
import wallywhip.resourcechickens.entity.ResourceChickenEntity;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initChickenConfigs;
import wallywhip.resourcechickens.init.initConfigs;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initRegistry;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.json.ChickenData;

@Mod(value="resourcechickens")
public class ResourceChickens {
    public static final String MOD_ID = "resourcechickens";
    public static final Logger LOGGER = LogManager.getLogger((String)"resourcechickens");
    public static final initConfigs CONFIGURATION = new initConfigs();
    private static final ResourceLocation FOOLISH_LOC = new ResourceLocation("resourcechickens:textures/entity/vanilla/chicken_fool.png");
    private static final ResourceLocation[] FESTIVE_LOC = new ResourceLocation[]{new ResourceLocation("resourcechickens:textures/entity/vanilla/chicken_fest1.png"), new ResourceLocation("resourcechickens:textures/entity/vanilla/chicken_fest2.png")};
    public static boolean isFestive = false;
    public static boolean isFoolish = false;
    public static final ItemGroup TAB = new ItemGroup("resourcechickens"){

        @OnlyIn(value=Dist.CLIENT)
        @Nonnull
        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Items.field_196163_cv);
        }
    };

    public ResourceChickens() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ResourceChickens.CONFIGURATION.COMMON);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ResourceChickens.CONFIGURATION.CLIENT);
        IEventBus MOD_EVENTBUS = FMLJavaModLoadingContext.get().getModEventBus();
        initSounds.SOUNDS.register(MOD_EVENTBUS);
        initItems.ITEMS.register(MOD_EVENTBUS);
        initBlocks.BLOCKS.register(MOD_EVENTBUS);
        initTiles.TILES.register(MOD_EVENTBUS);
        initRegistry.ENTITY_TYPES.register(MOD_EVENTBUS);
        initChickenConfigs.loadConfigs();
        MOD_EVENTBUS.addListener(this::onInterModEnqueueEvent);
        MOD_EVENTBUS.addListener(this::onEntityAttributeCreationEvent);
        MOD_EVENTBUS.addListener(this::onModConfigEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoadingEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onModConfigEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getModId().equals(MOD_ID) && event.getConfig().getType() == ModConfig.Type.CLIENT) {
            if (((Boolean)ResourceChickens.CONFIGURATION.allowEventTextures.get()).booleanValue()) {
                LocalDate date = LocalDate.now();
                int dd = date.getDayOfMonth();
                int mm = date.getMonthValue();
                isFestive = dd > 20 && mm == 12;
                isFoolish = dd == 1 && mm == 4;
            } else {
                isFoolish = false;
                isFestive = false;
            }
        }
    }

    public void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
        initRegistry.DATA.forEach((id, chickenData) -> {
            if (id.equals("angry")) {
                event.put((EntityType)chickenData.entityType.get(), AngryChickenEntity.createChickenAttributes(id).func_233813_a_());
            } else {
                event.put((EntityType)chickenData.entityType.get(), ResourceChickenEntity.createChickenAttributes(id).func_233813_a_());
            }
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)chickenData.entityType.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.WORLD_SURFACE, (entityType, world, spawnReason, blockPos, random) -> ResourceChickenEntity.checkAnimalSpawnRules((EntityType<? extends AnimalEntity>)entityType, (IWorld)world, spawnReason, blockPos, random, chickenData));
        });
    }

    public void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (event.getName() != null) {
            String biomeString = event.getName().toString();
            initRegistry.DATA.forEach((id, chickenData) -> {
                if (chickenData.spawnNaturally) {
                    if (chickenData.biomesWhitelist != null && chickenData.biomesWhitelist.size() != 0) {
                        if (chickenData.biomesWhitelist.toString().contains(biomeString)) {
                            for (JsonElement w : chickenData.biomesWhitelist) {
                                if (!w.getAsString().equals(biomeString)) continue;
                                event.getSpawns().getSpawner(chickenData.spawnType).add(new MobSpawnInfo.Spawners((EntityType)chickenData.entityType.get(), chickenData.spawnWeight, 1, 2));
                                break;
                            }
                        }
                    } else if (chickenData.biomesBlacklist != null && chickenData.biomesBlacklist.size() != 0) {
                        if (!chickenData.biomesBlacklist.toString().contains(biomeString)) {
                            for (JsonElement b : chickenData.biomesBlacklist) {
                                if (!b.getAsString().equals(biomeString)) continue;
                                event.getSpawns().getSpawner(chickenData.spawnType).add(new MobSpawnInfo.Spawners((EntityType)chickenData.entityType.get(), chickenData.spawnWeight, 1, 2));
                                break;
                            }
                        }
                    } else {
                        List spawns = event.getSpawns().getSpawner(EntityClassification.CREATURE);
                        if (spawns.stream().anyMatch(e -> e.field_242588_c == EntityType.field_200795_i)) {
                            spawns.add(new MobSpawnInfo.Spawners((EntityType)chickenData.entityType.get(), chickenData.spawnWeight, 1, 2));
                        }
                    }
                }
            });
        }
        List spawns = event.getSpawns().getSpawner(EntityClassification.CREATURE);
        spawns.removeIf(e -> e.field_242588_c == EntityType.field_200795_i);
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        ChickenData chickenData;
        if (event.getEntity() instanceof ResourceChickenEntity) {
            return;
        }
        if (event.getEntity().func_200600_R() == EntityType.field_200795_i && (chickenData = initRegistry.DATA.get("chicken")) != null && chickenData.enabled) {
            event.setCanceled(true);
            ResourceChickenEntity newChicken = (ResourceChickenEntity)((EntityType)chickenData.entityType.get()).func_200721_a(event.getWorld());
            if (newChicken != null) {
                CompoundNBT compound = new CompoundNBT();
                event.getEntity().func_70039_c(compound);
                compound.func_74757_a("analyzed", true);
                compound.func_74768_a("growth", 1);
                compound.func_74768_a("gain", 1);
                compound.func_74768_a("strength", 1);
                newChicken.func_70020_e(compound);
                event.getWorld().func_217376_c((Entity)newChicken);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        ResourceChickenEntity newChicken;
        if (event.getEntity().field_70170_p instanceof ServerWorld && event.getEntity() instanceof PlayerEntity && initRegistry.DATA.containsKey("grave") && (newChicken = (ResourceChickenEntity)((EntityType)initRegistry.DATA.get((Object)"grave").entityType.get()).func_200721_a(event.getEntity().field_70170_p)) != null) {
            PlayerEntity playerIn = (PlayerEntity)event.getEntity();
            newChicken.func_200203_b((ITextComponent)playerIn.func_145748_c_().func_230532_e_().func_240702_b_(": Death #").func_240702_b_("" + ((ServerPlayerEntity)playerIn).func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188069_A))));
            newChicken.func_82149_j(event.getEntity());
            newChicken.func_110163_bv();
            newChicken.getPersistentData().func_218657_a("Inventory", (INBT)playerIn.field_71071_by.func_70442_a(new ListNBT()));
            event.getEntity().field_70170_p.func_217376_c((Entity)newChicken);
            playerIn.field_71071_by.field_70462_a.clear();
            playerIn.field_71071_by.field_70460_b.clear();
            playerIn.field_71071_by.field_184439_c.clear();
        }
    }

    private void onInterModEnqueueEvent(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            compatTOP.register();
        }
    }

    public static int calcNewEggLayTime(Random r, ChickenData rcd, int growth) {
        if (rcd.eggLayTime == 0) {
            return 0;
        }
        int egg = r.nextInt(rcd.eggLayTime) + rcd.eggLayTime;
        return (int)Math.max(1.0f, (float)egg * (10.0f - (float)growth + 1.0f) / 10.0f);
    }

    public static int calcDropQuantity(int gain) {
        if (gain < 5) {
            return 1;
        }
        if (gain < 10) {
            return 2;
        }
        return 3;
    }

    public static List<ItemStack> calcDrops(int gain, ChickenData chickenData, int fortune) {
        Random r;
        ItemStack itemStack;
        ArrayList<ItemStack> lst = new ArrayList<ItemStack>();
        if (!chickenData.dropItemItem.equals("") && !(itemStack = ResourceChickens.getDropItem(chickenData.dropItemItem)).func_190926_b()) {
            if (chickenData.dropItemNBT != null) {
                itemStack.func_77982_d(chickenData.dropItemNBT.func_74737_b());
            }
            int dropQuantity = ResourceChickens.calcDropQuantity(gain) + fortune;
            if (itemStack.func_77985_e()) {
                itemStack.func_190920_e(dropQuantity);
                lst.add(itemStack);
            } else {
                for (int a = 0; a < dropQuantity; ++a) {
                    ItemStack itm = itemStack.func_77946_l();
                    lst.add(itm);
                }
            }
        }
        if ((r = new Random()).nextInt(8) == 0) {
            lst.add(chickenData.hasTrait == 1 ? new ItemStack((IItemProvider)initItems.FEATHER_DUCK.get()) : new ItemStack((IItemProvider)Items.field_151008_G));
        }
        return lst;
    }

    public static String formatTime(int milli) {
        int secs = milli / 20;
        int mins = secs / 60;
        int hours = mins / 60;
        if (hours == 0) {
            return String.format("%02d:%02d", mins, secs % 60);
        }
        return String.format("%02d:%02d:%02d", hours, mins, secs % 60);
    }

    public static ItemStack getDropItem(String itemDrop) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (itemDrop.startsWith("items:")) {
            ITag iTag = ItemTags.func_199903_a().func_199910_a(new ResourceLocation(itemDrop.substring(6)));
            if (iTag != null) {
                itemStack = new ItemStack((IItemProvider)iTag.func_230236_b_().get(0));
            }
        } else if (itemDrop.startsWith("blocks:")) {
            ITag iTag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation(itemDrop.substring(7)));
            if (iTag != null) {
                itemStack = new ItemStack((IItemProvider)iTag.func_230236_b_().get(0));
            }
        } else {
            itemStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemDrop)));
        }
        return itemStack;
    }

    public static ResourceLocation getTexture(ResourceChickenEntity entity) {
        if (isFestive && entity.chickenData.name.equals("chicken")) {
            long l = entity.func_110124_au().getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && entity.chickenData.name.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return entity.chickenData.chickenTexture;
    }

    public static ResourceLocation getTexture(ChickenData chickenData, UUID uuid) {
        if (isFestive && chickenData.name.equals("chicken")) {
            long l = uuid.getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && chickenData.name.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return chickenData.chickenTexture;
    }
}

