/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens.blocks;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.NameTagItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import wallywhip.resourcechickens.ResourceChickens;
import wallywhip.resourcechickens.blocks.NestTileEntity;
import wallywhip.resourcechickens.compat.TOP.ITOPInfoProvider;

public class Nest
extends ContainerBlock
implements ITOPInfoProvider {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    private static final VoxelShape NEST_SHAPE = Stream.of(Block.func_208617_a((double)12.0, (double)2.1, (double)5.0, (double)13.0, (double)3.1, (double)7.0), Block.func_208617_a((double)5.0, (double)0.1, (double)5.0, (double)11.0, (double)1.1, (double)11.0), Block.func_208617_a((double)12.0, (double)1.1, (double)7.0, (double)13.0, (double)2.1, (double)9.0), Block.func_208617_a((double)3.0, (double)1.1, (double)7.0, (double)4.0, (double)2.1, (double)9.0), Block.func_208617_a((double)4.0, (double)0.1, (double)7.0, (double)5.0, (double)1.1, (double)9.0), Block.func_208617_a((double)11.0, (double)0.1, (double)7.0, (double)12.0, (double)1.1, (double)9.0), Block.func_208617_a((double)7.0, (double)1.1, (double)3.0, (double)9.0, (double)2.1, (double)4.0), Block.func_208617_a((double)7.0, (double)0.1, (double)4.0, (double)9.0, (double)1.1, (double)5.0), Block.func_208617_a((double)7.0, (double)0.1, (double)11.0, (double)9.0, (double)1.1, (double)12.0), Block.func_208617_a((double)7.0, (double)1.1, (double)12.0, (double)9.0, (double)2.1, (double)13.0), Block.func_208617_a((double)4.0, (double)1.1, (double)9.0, (double)5.0, (double)2.1, (double)11.0), Block.func_208617_a((double)11.0, (double)1.1, (double)9.0, (double)12.0, (double)2.1, (double)11.0), Block.func_208617_a((double)11.0, (double)2.1, (double)11.0, (double)12.0, (double)3.1, (double)12.0), Block.func_208617_a((double)11.0, (double)2.1, (double)4.0, (double)12.0, (double)3.1, (double)5.0), Block.func_208617_a((double)4.0, (double)2.1, (double)4.0, (double)5.0, (double)3.1, (double)5.0), Block.func_208617_a((double)4.0, (double)2.1, (double)11.0, (double)5.0, (double)3.1, (double)12.0), Block.func_208617_a((double)11.0, (double)1.1, (double)5.0, (double)12.0, (double)2.1, (double)7.0), Block.func_208617_a((double)4.0, (double)1.1, (double)5.0, (double)5.0, (double)2.1, (double)7.0), Block.func_208617_a((double)13.0, (double)2.1, (double)7.0, (double)14.0, (double)3.1, (double)9.0), Block.func_208617_a((double)2.0, (double)2.1, (double)7.0, (double)3.0, (double)3.1, (double)9.0), Block.func_208617_a((double)7.0, (double)2.1, (double)2.0, (double)9.0, (double)3.1, (double)3.0), Block.func_208617_a((double)7.0, (double)2.1, (double)13.0, (double)9.0, (double)3.1, (double)14.0), Block.func_208617_a((double)12.0, (double)2.1, (double)9.0, (double)13.0, (double)3.1, (double)11.0), Block.func_208617_a((double)9.0, (double)2.1, (double)12.0, (double)11.0, (double)3.1, (double)13.0), Block.func_208617_a((double)5.0, (double)2.1, (double)12.0, (double)7.0, (double)3.1, (double)13.0), Block.func_208617_a((double)5.0, (double)1.1, (double)11.0, (double)7.0, (double)2.1, (double)12.0), Block.func_208617_a((double)5.0, (double)1.1, (double)4.0, (double)7.0, (double)2.1, (double)5.0), Block.func_208617_a((double)9.0, (double)1.1, (double)4.0, (double)11.0, (double)2.1, (double)5.0), Block.func_208617_a((double)9.0, (double)1.1, (double)11.0, (double)11.0, (double)2.1, (double)12.0), Block.func_208617_a((double)3.0, (double)2.1, (double)9.0, (double)4.0, (double)3.1, (double)11.0), Block.func_208617_a((double)3.0, (double)2.1, (double)5.0, (double)4.0, (double)3.1, (double)7.0), Block.func_208617_a((double)5.0, (double)2.1, (double)3.0, (double)7.0, (double)3.1, (double)4.0), Block.func_208617_a((double)9.0, (double)2.1, (double)3.0, (double)11.0, (double)3.1, (double)4.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public Nest() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151673_t).func_200943_b(0.5f).func_200947_a(SoundType.field_185850_c).harvestTool(ToolType.HOE).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return NEST_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nonnull
    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader iBlockReader) {
        return new NestTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
        NestTileEntity te = (NestTileEntity)world.func_175625_s(iProbeHitData.getPos());
        if (te == null) {
            return;
        }
        if (te.entityCaptured != null) {
            iProbeInfo.text((ITextComponent)te.entityDescription);
            if (te.entityCustomName != null) {
                iProbeInfo.text(te.entityCustomName);
            }
            if (te.entityCaptured.func_74767_n("analyzed")) {
                iProbeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.growth", new Object[]{te.chickenGrowth}));
                iProbeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.gain", new Object[]{te.chickenGain}));
                iProbeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.strength", new Object[]{te.chickenStrength}));
            }
            if (te.chickenData.eggLayTime != 0) {
                if (te.chickenAge < 0) {
                    iProbeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.growing", new Object[]{ResourceChickens.formatTime(-te.chickenAge)}));
                } else if (te.STORED_ITEMS.getStackInSlot(0).func_190926_b()) {
                    iProbeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.seeds")));
                } else {
                    iProbeInfo.text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.egg", new Object[]{ResourceChickens.formatTime(te.eggLayTime)}));
                }
            } else {
                iProbeInfo.text(CompoundText.create().style(TextStyleClass.WARNING).text((ITextComponent)new TranslationTextComponent("tip.resourcechickens.nodrop")));
            }
        }
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult p_225533_6_) {
        if (world.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        NestTileEntity te = (NestTileEntity)world.func_175625_s(pos);
        if (te == null) {
            return ActionResultType.CONSUME;
        }
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack.func_190926_b()) {
            return ActionResultType.CONSUME;
        }
        if (te.STORED_ITEMS.isItemValid(0, itemStack)) {
            int transferred = te.STORED_ITEMS.getStackInSlot(0).func_190916_E();
            ItemStack returned = ItemHandlerHelper.insertItem((IItemHandler)te.STORED_ITEMS, (ItemStack)itemStack.func_77946_l(), (boolean)false);
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, returned);
            }
            if (transferred != te.STORED_ITEMS.getStackInSlot(0).func_190916_E()) {
                if (te.entityCaptured != null) {
                    for (int a = 0; a < 4; ++a) {
                        double d0 = this.RANDOM.nextGaussian() * 0.2;
                        double d1 = this.RANDOM.nextGaussian() * 0.2;
                        double d2 = this.RANDOM.nextGaussian() * 0.2;
                        ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197633_z, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1, d0, d1, d2, 0.0);
                    }
                }
                te.func_70296_d();
            }
            return ActionResultType.SUCCESS;
        }
        if (itemStack.func_77973_b() instanceof NameTagItem) {
            te.entitySetCustomName(itemStack.func_179543_a("display"));
            te.sendRenderUpdates();
            if (!player.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, p_225533_6_);
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean notify) {
        TileEntity te;
        if (pos.func_177977_b().equals((Object)fromPos) && (te = world.func_175625_s(pos)) instanceof NestTileEntity) {
            ((NestTileEntity)te).updateCachedItemHandler();
        }
    }

    public void func_196243_a(BlockState state, @Nonnull World world, @Nonnull BlockPos pos, BlockState newState, boolean moved) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            NestTileEntity te = (NestTileEntity)world.func_175625_s(pos);
            if (te != null) {
                Entity entity;
                EntityType et;
                if (!te.STORED_ITEMS.contents().isEmpty()) {
                    te.STORED_ITEMS.contents().forEach(item -> InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)pos.func_177956_o(), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)item));
                }
                if (te.entityCaptured != null && (et = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(te.entityCaptured.func_74779_i("id")))) != null && (entity = et.func_200721_a(world)) != null) {
                    entity.func_70020_e(te.entityCaptured);
                    entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    world.func_217376_c(entity);
                    world.func_184133_a(null, pos, SoundEvents.field_187665_Y, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
            super.func_196243_a(state, world, pos, newState, moved);
        }
    }
}

